/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller.nullablespinner;

import java.awt.Color;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import javax.swing.text.NumberFormatter;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableSpinnerNumberModel;

public class NullableNumberEditorFormatter
extends NumberFormatter {
    private final NullableSpinnerNumberModel model;
    private final JFormattedTextField textField;
    private final Color colorOk;
    private final Color colorErr;

    NullableNumberEditorFormatter(NullableSpinnerNumberModel model, NumberFormat format, JFormattedTextField textField, Class valueClass) {
        super(format);
        this.model = model;
        this.setValueClass(valueClass);
        this.textField = textField;
        this.colorOk = UIManager.getColor("TextField.background");
        this.colorErr = new Color(255, 225, 232);
    }

    public void setMinimum(Comparable min) {
        this.model.setMinimum(min);
    }

    public Comparable getMinimum() {
        return this.model.getMinimum();
    }

    public void setMaximum(Comparable max) {
        this.model.setMaximum(max);
    }

    public Comparable getMaximum() {
        return this.model.getMaximum();
    }

    private boolean isValidValue(Object value, boolean wantsCCE) {
        Comparable min = this.getMinimum();
        try {
            if (min != null && min.compareTo(value) > 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        Comparable max = this.getMaximum();
        try {
            if (max != null && max.compareTo(value) < 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        return true;
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        Object value = this.stringToValue(text, this.getFormat());
        if (value != null && this.getValueClass() != null && !this.getValueClass().isInstance(value)) {
            value = super.stringToValue(value.toString());
        }
        try {
            if (!this.isValidValue(value, true)) {
                throw new ParseException("Value not within min/max range", 0);
            }
        }
        catch (ClassCastException cce) {
            throw new ParseException("Class cast exception comparing values: " + cce, 0);
        }
        return value;
    }

    private Object stringToValue(String text, Format f) throws ParseException {
        if (text == null || StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        if (f == null) {
            return text;
        }
        return f.parseObject(text);
    }

    @Override
    protected void setEditValid(boolean valid) {
        super.setEditValid(valid);
        this.decorateTextField(valid);
    }

    public void decorateTextField(boolean valid) {
        if (valid) {
            this.textField.setBackground(this.colorOk);
        } else {
            this.textField.setBackground(this.colorErr);
        }
    }
}

