/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.bigfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;
import org.gvsig.utils.bigfile.BigByteBuffer;
import org.gvsig.utils.bigfile.BigByteBuffer2;

public class TestBigByteBuffer {
    File f = new File("D:/Fjp/chiara/plano/vias.shp");
    FileInputStream fin;
    FileInputStream fin2;
    FileChannel channel2;
    BigByteBuffer2 bb;
    static int numPruebas = 50000;

    public static void main(String[] args) throws IOException {
        TestBigByteBuffer test = new TestBigByteBuffer();
        test.test();
    }

    public void test() throws IOException {
        this.fin2 = new FileInputStream(this.f);
        this.channel2 = this.fin2.getChannel();
        this.bb = new BigByteBuffer2(this.channel2, FileChannel.MapMode.READ_ONLY, 8192L);
        MyThread th = new MyThread("T1:");
        th.start();
        MyThread th2 = new MyThread("T2: ");
        th2.start();
        System.out.println("Fin de la prueba. " + numPruebas + " iteraciones.");
    }

    private void prueba2(String name, File f, int numPruebas) throws Exception {
        FileInputStream fin = new FileInputStream(f);
        FileChannel channel = fin.getChannel();
        int size = (int)channel.size();
        MappedByteBuffer bbCorrect = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        Random rnd = new Random();
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < numPruebas; ++i) {
            int pos = rnd.nextInt(size - 10);
            ((ByteBuffer)bbCorrect).position(pos);
            int bCorrect = bbCorrect.getInt();
            int bPrueba = this.bb.getInt(pos);
            if (bCorrect != bPrueba) {
                System.err.println(name + "Error de lectura. " + bCorrect + " " + bPrueba);
                throw new Exception("Error con pos=" + pos);
            }
            System.out.println(name + "Correcto: pos=" + pos + " byte= " + bPrueba);
        }
        TestBigByteBuffer.close(this.channel2, this.fin2, this.bb);
        long t2 = System.currentTimeMillis();
        System.out.println("T=" + (t2 - t1) + "mseconds");
    }

    private static void prueba1(File f, int numPruebas) throws FileNotFoundException, IOException {
        FileInputStream fin = new FileInputStream(f);
        FileChannel channel = fin.getChannel();
        int size = (int)channel.size();
        MappedByteBuffer bbCorrect = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        Random rnd = new Random();
        long t1 = System.currentTimeMillis();
        FileInputStream fin2 = new FileInputStream(f);
        FileChannel channel2 = fin2.getChannel();
        BigByteBuffer bb = new BigByteBuffer(channel2, FileChannel.MapMode.READ_ONLY, 0x100000L);
        for (int i = 0; i < numPruebas; ++i) {
            byte bPrueba;
            int pos = rnd.nextInt(size - 10);
            byte bCorrect = bbCorrect.get(pos);
            if (bCorrect == (bPrueba = bb.get(pos))) continue;
            System.err.println("Error de lectura. " + bCorrect + " " + bPrueba);
        }
        TestBigByteBuffer.close(channel2, fin2, bb);
        System.gc();
        long t2 = System.currentTimeMillis();
        System.out.println("T=" + (t2 - t1) + "mseconds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void close(FileChannel channel, FileInputStream fin, BigByteBuffer2 bb) throws IOException {
        IOException ret = null;
        try {
            channel.close();
        }
        catch (IOException e) {
            ret = e;
        }
        finally {
            try {
                fin.close();
            }
            catch (IOException e1) {
                ret = e1;
            }
        }
        if (ret != null) {
            throw ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void close(FileChannel channel, FileInputStream fin, BigByteBuffer bb) throws IOException {
        IOException ret = null;
        try {
            channel.close();
        }
        catch (IOException e) {
            ret = e;
        }
        finally {
            try {
                fin.close();
            }
            catch (IOException e1) {
                ret = e1;
            }
        }
        if (ret != null) {
            throw ret;
        }
        bb = null;
    }

    public class MyThread
    extends Thread {
        String name;

        public MyThread(String string) {
            this.name = string;
        }

        @Override
        public void run() {
            try {
                TestBigByteBuffer.this.prueba2(this.name, TestBigByteBuffer.this.f, numPruebas);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

