/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.swing.jtable;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class TextFieldCellEditor
extends JTextField
implements TableCellEditor {
    private ArrayList listeners = new ArrayList();
    private String initialValue;

    public TextFieldCellEditor() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TextFieldCellEditor.this.stopCellEditing();
                } else if (e.getKeyCode() == 27) {
                    TextFieldCellEditor.this.cancelCellEditing();
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setText(value == null ? "" : value.toString());
        return this;
    }

    @Override
    public void cancelCellEditing() {
        this.setText(this.initialValue);
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener l = (CellEditorListener)this.listeners.get(i);
            ChangeEvent evt = new ChangeEvent(this);
            l.editingCanceled(evt);
        }
    }

    @Override
    public boolean stopCellEditing() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener l = (CellEditorListener)this.listeners.get(i);
            ChangeEvent evt = new ChangeEvent(this);
            l.editingStopped(evt);
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.getText();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }
}

