/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.accessories.connection;

public class Credentials {
    private int port = -1;
    private String username = "";
    private char[] password = new char[0];
    private String hostname = "";
    private String protocol = "";
    private String defaulRemotetPath = "";

    protected Credentials(String hostname) {
        this.hostname = hostname;
    }

    public static Builder newBuilder(String hostname) {
        return new Builder(hostname);
    }

    public String toFileObjectURL() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.protocol.toLowerCase());
        sb.append("://");
        if (!this.protocol.toLowerCase().equals("file")) {
            if (!"".equals(this.username.trim())) {
                sb.append(this.username);
                if (this.password.length != 0) {
                    sb.append(":");
                    for (int i = 0; i < this.password.length; ++i) {
                        if (this.password[i] == '@') {
                            sb.append("%40");
                            continue;
                        }
                        sb.append(this.password[i]);
                    }
                }
                sb.append("@");
            }
            sb.append(this.hostname);
            if (this.port != -1) {
                sb.append(":").append(this.port);
            }
        }
        return sb.append(this.defaulRemotetPath).toString();
    }

    public String getDefaulRemotetPath() {
        return this.defaulRemotetPath;
    }

    public String getHostname() {
        return this.hostname;
    }

    public char[] getPassword() {
        return (char[])this.password.clone();
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUsername() {
        return this.username;
    }

    static /* synthetic */ char[] access$202(Credentials x0, char[] x1) {
        x0.password = x1;
        return x1;
    }

    public static final class Builder {
        private Credentials m_credentials;
        private String m_username;
        private char[] m_password;
        private String m_defaultRemotePath;
        private final String m_hostname;
        private int m_port;
        private String m_protocol;

        protected Builder(String m_hostname) {
            this.m_hostname = m_hostname;
        }

        public Credentials build() {
            this.m_credentials = new Credentials(this.m_hostname);
            this.m_credentials.username = this.m_username;
            this.m_credentials.defaulRemotetPath = this.m_defaultRemotePath;
            Credentials.access$202(this.m_credentials, this.m_password);
            this.m_credentials.protocol = this.m_protocol;
            this.m_credentials.port = this.m_port;
            return this.m_credentials;
        }

        public Builder password(char[] m_password) {
            this.m_password = (char[])m_password.clone();
            return this;
        }

        public Builder protocol(String m_protocol) {
            this.m_protocol = m_protocol;
            return this;
        }

        public Builder port(int m_portNumber) {
            this.m_port = m_portNumber;
            return this;
        }

        public Builder defaultRemotePath(String m_defaultRemotePath) {
            this.m_defaultRemotePath = m_defaultRemotePath;
            return this;
        }

        public Builder username(String m_username) {
            this.m_username = m_username;
            return this;
        }
    }
}

