/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.border;

import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class BorderManager {
    private static HashMap m_default_borders = new HashMap();
    private static LookAndFeel m_look_and_feel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Border getDefaultBorder(JComponent comp) {
        HashMap hashMap = m_default_borders;
        synchronized (hashMap) {
            if (comp != null) {
                Border default_border;
                if (m_default_borders.size() == 0 || BorderManager.isLookAndFeelChanged()) {
                    BorderManager.resetDefaultBorders();
                }
                if ((default_border = (Border)m_default_borders.get(comp.getClass())) == null) {
                    Class<?> comp_class = comp.getClass();
                    try {
                        JComponent new_comp = (JComponent)comp_class.newInstance();
                        default_border = new_comp.getBorder();
                        m_default_borders.put(comp_class, default_border);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        m_default_borders.put(comp_class, null);
                    }
                }
                return default_border;
            }
        }
        return null;
    }

    private static Border getDefaultBorder(String borderResource) {
        Border b = UIManager.getBorder(borderResource);
        return b;
    }

    private static boolean isLookAndFeelChanged() {
        LookAndFeel lf = UIManager.getLookAndFeel();
        if (m_look_and_feel != lf) {
            m_look_and_feel = lf;
            return true;
        }
        return false;
    }

    private static void resetDefaultBorders() {
        m_default_borders.clear();
        m_default_borders.put(JButton.class, BorderManager.getDefaultBorder("Button.border"));
        m_default_borders.put(JComboBox.class, BorderManager.getDefaultBorder("ComboBox.border"));
        m_default_borders.put(JLabel.class, new JLabel().getBorder());
        m_default_borders.put(JList.class, BorderManager.getDefaultBorder("List.border"));
        m_default_borders.put(JSpinner.class, BorderManager.getDefaultBorder("Spinner.border"));
        m_default_borders.put(JTable.class, new JTable().getBorder());
        m_default_borders.put(JTextArea.class, BorderManager.getDefaultBorder("TextArea.border"));
        m_default_borders.put(JTextField.class, BorderManager.getDefaultBorder("TextField.border"));
        m_default_borders.put(JTree.class, new JTree().getBorder());
        m_default_borders.put(JScrollPane.class, new JScrollPane().getBorder());
        m_default_borders.put(JCheckBox.class, new EmptyBorder(1, 0, 1, 2));
        m_default_borders.put(JRadioButton.class, new EmptyBorder(1, 0, 1, 2));
    }
}

