/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.common;

import com.jeta.forms.gui.common.FormSpecDefinition;
import com.jeta.open.registry.JETARegistry;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.rmi.server.UID;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class FormUtils {
    private static int m_count;
    static char[] letters;
    static final /* synthetic */ boolean $assertionsDisabled;

    static String _createUID() {
        UID uid = new UID();
        StringBuffer sbuff = new StringBuffer(uid.toString());
        for (int index = 0; index < sbuff.length(); ++index) {
            char c = sbuff.charAt(index);
            if (!(c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a') && c <= 'z') continue;
            int cindex = (int)(Math.random() * 26.0);
            sbuff.setCharAt(index, letters[cindex]);
        }
        char c = sbuff.charAt(0);
        if (c < 'A' || c > 'Z') {
            int cindex = (int)(Math.random() * 26.0);
            sbuff.setCharAt(0, letters[cindex]);
        }
        return sbuff.toString();
    }

    public static String createUID() {
        if (FormUtils.isDebug()) {
            Calendar c = Calendar.getInstance();
            SimpleDateFormat format = new SimpleDateFormat("EEE, MMM d, yyyy - HH:mm:ss");
            return String.valueOf(++m_count) + "." + format.format(c.getTime());
        }
        return FormUtils._createUID();
    }

    public static String fixPath(String path) {
        if (path == null) {
            return null;
        }
        char sep = '/';
        if (File.separatorChar == '/') {
            sep = '\\';
        }
        return path.replace(sep, File.separatorChar);
    }

    public static String getReasonableSize(String units) {
        if ("DLU".equalsIgnoreCase(units)) {
            return "12";
        }
        if ("PX".equalsIgnoreCase(units)) {
            return "24";
        }
        if ("PT".equalsIgnoreCase(units)) {
            return "24";
        }
        if ("IN".equalsIgnoreCase(units)) {
            return "0.5";
        }
        if ("MM".equalsIgnoreCase(units)) {
            return "10";
        }
        if ("CM".equalsIgnoreCase(units)) {
            return "1";
        }
        FormUtils.safeAssert(false);
        return "10";
    }

    public static boolean isDesignMode() {
        Boolean result = (Boolean)JETARegistry.lookup("AbeilleForms.designMode");
        return Boolean.TRUE.equals(result);
    }

    public static boolean isDebug() {
        try {
            String result = System.getProperty("jeta1.debug");
            return result != null && result.equals("true");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isRuntime() {
        Boolean result = (Boolean)JETARegistry.lookup("AbeilleForms.runTime");
        if (result == null) {
            return true;
        }
        return Boolean.TRUE.equals(result);
    }

    public static boolean isIntegralUnits(String units) {
        return "PX".equalsIgnoreCase(units) || "PT".equalsIgnoreCase(units) || "DLU".equalsIgnoreCase(units);
    }

    public static boolean isValidUnits(String units) {
        return "DLU".equalsIgnoreCase(units) || "PX".equalsIgnoreCase(units) || "PT".equalsIgnoreCase(units) || "IN".equalsIgnoreCase(units) || "MM".equalsIgnoreCase(units) || "CM".equalsIgnoreCase(units);
    }

    public static void setDesignMode(boolean bdesign) {
        JETARegistry.rebind("AbeilleForms.designMode", bdesign);
    }

    public static String fromAlignment(CellConstraints.Alignment align) {
        if (align == CellConstraints.DEFAULT) {
            return "DEFAULT";
        }
        if (align == CellConstraints.FILL) {
            return "FILL";
        }
        if (align == CellConstraints.TOP) {
            return "TOP";
        }
        if (align == CellConstraints.BOTTOM) {
            return "BOTTOM";
        }
        if (align == CellConstraints.CENTER) {
            return "CENTER";
        }
        if (align == CellConstraints.LEFT) {
            return "LEFT";
        }
        if (align == CellConstraints.RIGHT) {
            return "RIGHT";
        }
        return "DEFAULT";
    }

    public static CellConstraints.Alignment toAlignment(String val) {
        if (val.equalsIgnoreCase("DEFAULT")) {
            return CellConstraints.DEFAULT;
        }
        if (val.equalsIgnoreCase("FILL")) {
            return CellConstraints.FILL;
        }
        if (val.equalsIgnoreCase("TOP")) {
            return CellConstraints.TOP;
        }
        if (val.equalsIgnoreCase("BOTTOM")) {
            return CellConstraints.BOTTOM;
        }
        if (val.equalsIgnoreCase("CENTER")) {
            return CellConstraints.CENTER;
        }
        if (val.equalsIgnoreCase("LEFT")) {
            return CellConstraints.LEFT;
        }
        if (val.equalsIgnoreCase("RIGHT")) {
            return CellConstraints.RIGHT;
        }
        FormUtils.safeAssert(false);
        return CellConstraints.DEFAULT;
    }

    public static String toConstantSize(FormSpecDefinition fspec) {
        StringBuffer sbuff = new StringBuffer();
        if (FormUtils.isIntegralUnits(fspec.getConstantUnits())) {
            sbuff.append(Math.round(fspec.getConstantSize()));
        } else {
            DecimalFormat format = new DecimalFormat("###0.0");
            String sz = format.format(fspec.getConstantSize());
            sz = sz.replace(',', '.');
            sbuff.append(sz);
        }
        sbuff.append(fspec.getConstantUnits());
        return sbuff.toString();
    }

    public static String toEncodedString(FormSpecDefinition fspec) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(fspec.getAlignment());
        sbuff.append(":");
        if ("CONSTANT".equalsIgnoreCase(fspec.getSizeType())) {
            sbuff.append(FormUtils.toConstantSize(fspec));
        } else if ("COMPONENT".equalsIgnoreCase(fspec.getSizeType())) {
            sbuff.append(fspec.getComponentSize());
        } else if ("BOUNDED".equalsIgnoreCase(fspec.getSizeType())) {
            sbuff.append(fspec.getBoundedSize());
            sbuff.append("(");
            sbuff.append(FormUtils.toConstantSize(fspec));
            sbuff.append(";");
            sbuff.append(fspec.getComponentSize());
            sbuff.append(")");
        } else {
            FormUtils.safeAssert(false);
        }
        sbuff.append(":");
        sbuff.append(fspec.getResize());
        if ("GROW".equalsIgnoreCase(fspec.getResize())) {
            sbuff.append("(");
            double weight = fspec.getResizeWeight();
            if (weight > 1.0) {
                weight = 1.0;
            }
            DecimalFormat format = new DecimalFormat("0.0");
            String fw = format.format(weight);
            fw = fw.replace(',', '.');
            sbuff.append(fw);
            sbuff.append(")");
        }
        return sbuff.toString();
    }

    public static void updateLookAndFeel(Component c) {
        if (c == null) {
            return;
        }
        c.invalidate();
        c.validate();
        c.repaint();
        if (c instanceof JComponent) {
            ((JComponent)c).updateUI();
        }
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                FormUtils.updateLookAndFeel(children[i]);
            }
        }
    }

    public static void safeAssert(boolean assertvalue) {
        if (FormUtils.isDebug() && !$assertionsDisabled && !assertvalue) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !FormUtils.class.desiredAssertionStatus();
        m_count = 0;
        letters = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    }
}

