/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties.effects;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.effects.LinearGradientPainter;
import com.jeta.forms.gui.effects.Paintable;
import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.effects.PaintSupport;
import com.jeta.open.i18n.I18N;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;

public class GradientProperty
extends JETAProperty
implements PaintSupport {
    static final long serialVersionUID = 8426558667506208881L;
    public static final int VERSION = 3;
    public static final int TOP_BOTTOM = 0;
    public static final int BOTTOM_TOP = 1;
    public static final int LEFT_RIGHT = 2;
    public static final int RIGHT_LEFT = 3;
    public static final int UP_RIGHT = 4;
    public static final int UP_LEFT = 5;
    public static final int DOWN_RIGHT = 6;
    public static final int DOWN_LEFT = 7;
    private ColorProperty m_start_color = new ColorProperty(Color.black);
    private ColorProperty m_end_color = new ColorProperty(Color.white);
    private float m_magnitude = 1.0f;
    private int m_direction = 0;
    private transient LinearGradientPainter m_painter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GradientProperty() {
    }

    public GradientProperty(ColorProperty start, ColorProperty end, int direction) {
        this.m_start_color = start;
        this.m_end_color = end;
        this.m_direction = direction;
    }

    public Painter createPainter() {
        if (this.m_painter == null) {
            this.m_painter = new LinearGradientPainter(this);
        }
        return this.m_painter;
    }

    public int getDirection() {
        return this.m_direction;
    }

    public ColorProperty getEndColor() {
        return this.m_end_color;
    }

    public float getMagnitude() {
        return this.m_magnitude;
    }

    public ColorProperty getStartColor() {
        return this.m_start_color;
    }

    public void setDirection(int direction) {
        this.m_direction = direction;
        this.m_painter = null;
    }

    public void setStartColor(ColorProperty c) {
        this.m_start_color = c;
        this.m_painter = null;
    }

    public void setEndColor(ColorProperty c) {
        this.m_end_color = c;
        this.m_painter = null;
    }

    public void setMagnitude(float mag) {
        this.m_magnitude = mag;
        this.m_painter = null;
    }

    public void setValue(Object prop) {
        if (prop instanceof GradientProperty) {
            GradientProperty gp = (GradientProperty)prop;
            if (this.m_start_color == null) {
                this.m_start_color = new ColorProperty();
            }
            if (this.m_end_color == null) {
                this.m_end_color = new ColorProperty();
            }
            this.m_start_color.setValue(gp.m_start_color);
            this.m_end_color.setValue(gp.m_end_color);
            this.m_magnitude = gp.m_magnitude;
            this.m_direction = gp.m_direction;
            this.m_painter = null;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateBean(JETABean jbean) {
        LinearGradientPainter painter = (LinearGradientPainter)this.createPainter();
        if (jbean != null) {
            Component comp = jbean.getDelegate();
            if (comp instanceof Paintable) {
                ((Paintable)((Object)comp)).setBackgroundPainter(painter);
            } else if (comp != null) {
                System.out.println("Fill property set on non paintable. " + comp.getClass());
            }
        }
    }

    public String toString() {
        return I18N.getLocalizedMessage("Linear Gradient");
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_start_color = (ColorProperty)in.readObject("startcolor");
        this.m_end_color = (ColorProperty)in.readObject("endcolor");
        this.m_magnitude = in.readFloat("magnitude");
        this.m_direction = in.readInt("direction");
        if (version == 1) {
            boolean bl = in.readBoolean("radial");
        }
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(JETAProperty.class));
        out.writeVersion(3);
        out.writeObject("startcolor", this.m_start_color);
        out.writeObject("endcolor", this.m_end_color);
        out.writeFloat("magnitude", this.m_magnitude);
        out.writeInt("direction", this.m_direction);
    }

    static {
        $assertionsDisabled = !GradientProperty.class.desiredAssertionStatus();
    }
}

