/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.i18n;

import com.jeta.open.registry.JETARegistry;
import com.jeta.open.resources.ResourceLoader;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18NHelper {
    private Locale m_locale;
    private static I18NHelper m_singleton;
    private LinkedList m_bundles = new LinkedList();

    private I18NHelper() {
    }

    public boolean equals(String arg1, String arg2) {
        if (arg1 == null || arg2 == null) {
            return false;
        }
        return arg1.equals(arg2);
    }

    public static I18NHelper getInstance() {
        if (m_singleton == null) {
            m_singleton = new I18NHelper();
        }
        return m_singleton;
    }

    public void loadBundle(String bundleName) {
        ResourceBundle currentbundle = null;
        ResourceLoader loader = (ResourceLoader)JETARegistry.lookup("jeta.resourceloader");
        currentbundle = ResourceBundle.getBundle(bundleName, this.m_locale, loader.getClassLoader());
        this.m_bundles.add(currentbundle);
    }

    public void setLocale(Locale locale) {
        Locale.setDefault(locale);
        this.m_locale = locale;
    }

    public String format(String template, Object[] arguments) {
        MessageFormat formatter = new MessageFormat("");
        formatter.setLocale(this.m_locale);
        formatter.applyPattern(this.getLocalizedMessage(template));
        return formatter.format(arguments);
    }

    public String _getLocalizedMessage(ResourceBundle bundle, String messageId) {
        String result = null;
        try {
            result = bundle.getString(messageId);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        return result;
    }

    public String getLocalizedMessage(String messageId) {
        ResourceBundle bundle;
        if (messageId == null) {
            return null;
        }
        String result = null;
        Iterator iter = this.m_bundles.iterator();
        while (iter.hasNext() && (result = this._getLocalizedMessage(bundle = (ResourceBundle)iter.next(), messageId)) == null) {
        }
        if (result == null) {
            result = messageId;
        }
        return result;
    }

    public boolean toBoolean(String strVal) {
        if (strVal == null) {
            return false;
        }
        return strVal.compareToIgnoreCase(this.getLocalizedMessage("true")) == 0;
    }

    public char closeParenthesis() {
        return ')';
    }

    public char comma() {
        return ',';
    }

    public char newline() {
        return '\n';
    }

    public char openParenthesis() {
        return '(';
    }

    public char semicolon() {
        return ';';
    }

    public char space() {
        return ' ';
    }
}

