/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.creation.model;

import java.io.File;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class SelectFilesTreeCheckNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 8722862821986059646L;
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    protected int selectionMode;
    protected boolean isSelected;
    private File file = null;

    public SelectFilesTreeCheckNode(File file) {
        this(file, true, false);
    }

    public SelectFilesTreeCheckNode(File file, boolean allowsChildren, boolean isSelected) {
        super(file, allowsChildren);
        this.isSelected = isSelected;
        this.setSelectionMode(4);
        this.file = file;
        if (file.isDirectory()) {
            this.retrieveChildren();
        }
    }

    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        if (this.selectionMode == 4 && this.children != null) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                SelectFilesTreeCheckNode node = (SelectFilesTreeCheckNode)e.nextElement();
                node.setSelected(isSelected);
            }
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public TreeNode getChildAt(int index) {
        return super.getChildAt(index);
    }

    @Override
    public int getChildCount() {
        return super.getChildCount();
    }

    private void retrieveChildren() {
        File[] files = this.file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            this.add(new SelectFilesTreeCheckNode(files[i]));
        }
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String toString() {
        return this.file.getName();
    }
}

