/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.wizard;

import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.execution.InstallPackageService;
import org.gvsig.installer.swing.impl.execution.InstallWizardPanel_ext;
import org.gvsig.installer.swing.impl.panel.DefaultProgressPanel;
import org.gvsig.tools.task.AbstractMonitorableTask;
import org.gvsig.tools.task.CancellableTask;
import org.gvsig.tools.task.SimpleTaskStatus;

public class ProgressWizardPage
extends DefaultProgressPanel
implements OptionPanel {
    private static final long serialVersionUID = 8531884535246881448L;
    private final InstallWizardPanel_ext wizardPanel;

    public ProgressWizardPage(InstallWizardPanel_ext wizardPanel) {
        this.wizardPanel = wizardPanel;
    }

    public JPanel getJPanel() {
        return this;
    }

    public String getPanelTitle() {
        return this.wizardPanel.getTranslation("_progress");
    }

    public void lastPanel() {
        this.wizardPanel.setFinishButtonEnabled(false);
        this.wizardPanel.setCancelButtonEnabled(true);
    }

    public void nextPanel() {
    }

    public void updatePanel() {
        this.wizardPanel.setFinishButtonEnabled(false);
        this.wizardPanel.setCancelButtonEnabled(false);
        this.wizardPanel.setNextButtonEnabled(false);
        ProgressWizardPage wizard = this;
        UpdatePanel task = new UpdatePanel(wizard);
        wizard.wizardPanel.addCancellableTask((CancellableTask)task);
        this.bind(task.getTaskStatus());
        task.setDaemon(true);
        task.start();
    }

    private static class UpdatePanel
    extends AbstractMonitorableTask {
        private final ProgressWizardPage panel;

        public UpdatePanel(ProgressWizardPage panel) {
            super(panel.wizardPanel.getTranslation("_Install_package"));
            this.panel = panel;
        }

        private void showWarning(String msg) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
                catch (Exception ex) {
                    logger.warn("Cant show message to the user. " + msg);
                }
                return;
            }
            JOptionPane.showMessageDialog((Component)((Object)this.panel), msg, "Warning", 2);
        }

        public synchronized void run() {
            int errcount = 0;
            try {
                logger.info("Package installation iniitiated");
                SimpleTaskStatus taskStatus = (SimpleTaskStatus)this.getTaskStatus();
                InstallPackageService installerExecutionService = this.panel.wizardPanel.getInstallerExecutionService();
                List<PackageInfo> installersToInstall = this.panel.wizardPanel.getPackagesToInstall();
                Collections.sort(installersToInstall, new Comparator<PackageInfo>(){

                    @Override
                    public int compare(PackageInfo o1, PackageInfo o2) {
                        return o1.getCode().compareTo(o2.getCode());
                    }
                });
                taskStatus.setRangeOfValues(0L, (long)installersToInstall.size());
                for (int i = 0; i < installersToInstall.size(); ++i) {
                    PackageInfo installerInfo = installersToInstall.get(i);
                    taskStatus.message(installerInfo.getName());
                    try {
                        installerExecutionService.installPackage(this.panel.wizardPanel.getApplicationFolder(), installerInfo);
                    }
                    catch (Throwable th) {
                        logger.warn("Can't install package '" + installerInfo.getCode() + "'.", th);
                        ++errcount;
                    }
                    taskStatus.setCurValue((long)(i + 1));
                }
                this.panel.wizardPanel.setFinishButtonEnabled(true);
                this.panel.wizardPanel.setNextButtonEnabled(false);
                if (errcount > 0) {
                    this.showWarning("Failed to install " + errcount + " packages.");
                }
                taskStatus.message(this.panel.wizardPanel.getTranslation("_Finished"));
                taskStatus.terminate();
                taskStatus.remove();
                logger.info("Package installation finished");
            }
            catch (Throwable th) {
                logger.warn("Problems install packages.", th);
                this.showWarning(this.panel.wizardPanel.getTranslation("_Cant_install_packege"));
            }
        }
    }
}

