/*
 * Decompiled with CFR 0.152.
 */
package jwizardcomponent;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import jwizardcomponent.CancelAction;
import jwizardcomponent.FinishAction;
import jwizardcomponent.JWizardComponents;
import jwizardcomponent.JWizardPanel;

public class DefaultJWizardComponents
implements JWizardComponents {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("jwizardcomponent/i18n");
    JButton backButton;
    JButton nextButton;
    JButton finishButton;
    JButton cancelButton;
    FinishAction finishAction;
    CancelAction cancelAction;
    List panelList;
    int currentIndex;
    JPanel wizardPanelsContainer;
    PropertyChangeSupport propertyChangeListeners;

    public DefaultJWizardComponents() {
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addWizardPanel(JWizardPanel jWizardPanel) {
        this.getWizardPanelList().add(jWizardPanel);
        this.wizardPanelsContainer.add((Component)jWizardPanel, this.getWizardPanelList().size() - 1 + "");
    }

    public void addWizardPanel(int n, JWizardPanel jWizardPanel) {
        this.getWizardPanelList().add(n, jWizardPanel);
        this.wizardPanelsContainer.add(jWizardPanel, n + "", n);
        if (n < this.getWizardPanelList().size() - 1) {
            int n2 = n + 1;
            while (n2 < this.getWizardPanelList().size()) {
                this.wizardPanelsContainer.add((Component)((JWizardPanel)this.getWizardPanelList().get(n2)), n2 + "");
                ++n2;
            }
        }
    }

    public void addWizardPanelAfter(JWizardPanel jWizardPanel, JWizardPanel jWizardPanel2) {
        this.addWizardPanel(this.getWizardPanelList().indexOf(jWizardPanel) + 1, jWizardPanel2);
    }

    public void addWizardPanelBefore(JWizardPanel jWizardPanel, JWizardPanel jWizardPanel2) {
        this.addWizardPanel(this.getWizardPanelList().indexOf(jWizardPanel) - 1, jWizardPanel2);
    }

    public void addWizardPanelAfterCurrent(JWizardPanel jWizardPanel) {
        this.addWizardPanel(this.getCurrentIndex() + 1, jWizardPanel);
    }

    public JWizardPanel removeWizardPanel(JWizardPanel jWizardPanel) {
        int n = this.getWizardPanelList().indexOf(jWizardPanel);
        this.getWizardPanelList().remove(jWizardPanel);
        this.wizardPanelsContainer.remove(jWizardPanel);
        int n2 = n;
        while (n2 < this.getWizardPanelList().size()) {
            this.wizardPanelsContainer.add((Component)((JWizardPanel)this.getWizardPanelList().get(n2)), n2 + "");
            ++n2;
        }
        return jWizardPanel;
    }

    public JWizardPanel removeWizardPanel(int n) {
        this.wizardPanelsContainer.remove(n);
        JWizardPanel jWizardPanel = (JWizardPanel)this.getWizardPanelList().remove(n);
        int n2 = n;
        while (n2 < this.getWizardPanelList().size()) {
            this.wizardPanelsContainer.add((Component)((JWizardPanel)this.getWizardPanelList().get(n2)), n2 + "");
            ++n2;
        }
        return jWizardPanel;
    }

    public JWizardPanel removeWizardPanelAfter(JWizardPanel jWizardPanel) {
        return this.removeWizardPanel(this.getWizardPanelList().indexOf(jWizardPanel) + 1);
    }

    public JWizardPanel removeWizardPanelBefore(JWizardPanel jWizardPanel) {
        return this.removeWizardPanel(this.getWizardPanelList().indexOf(jWizardPanel) - 1);
    }

    public JWizardPanel getWizardPanel(int n) {
        return (JWizardPanel)this.getWizardPanelList().get(n);
    }

    public int getIndexOfPanel(JWizardPanel jWizardPanel) {
        return this.getWizardPanelList().indexOf(jWizardPanel);
    }

    public boolean onLastPanel() {
        return this.getCurrentIndex() == this.getWizardPanelList().size() - 1;
    }

    private void init() throws Exception {
        this.propertyChangeListeners = new PropertyChangeSupport(this);
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.finishButton = new JButton();
        this.cancelButton = new JButton();
        this.panelList = new ArrayList();
        this.currentIndex = 0;
        this.wizardPanelsContainer = new JPanel();
        this.backButton.setText(this.resourceBundle.getString("L_BackButton"));
        this.backButton.setMnemonic(this.resourceBundle.getString("L_BackButtonMnem").charAt(0));
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultJWizardComponents.this.backButton_actionPerformed(actionEvent);
            }
        });
        this.nextButton.setText(this.resourceBundle.getString("L_NextButton"));
        this.nextButton.setMnemonic(this.resourceBundle.getString("L_NextButtonMnem").charAt(0));
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultJWizardComponents.this.nextButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.setText(this.resourceBundle.getString("L_CancelButton"));
        this.cancelButton.setMnemonic(this.resourceBundle.getString("L_CancelButtonMnem").charAt(0));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultJWizardComponents.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.finishButton.setText(this.resourceBundle.getString("L_FinishButton"));
        this.finishButton.setMnemonic(this.resourceBundle.getString("L_FinishButtonMnem").charAt(0));
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultJWizardComponents.this.finishButton_actionPerformed(actionEvent);
            }
        });
        this.wizardPanelsContainer.setLayout(new CardLayout());
    }

    void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.getCancelAction().performAction();
    }

    void finishButton_actionPerformed(ActionEvent actionEvent) {
        this.getFinishAction().performAction();
    }

    void nextButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.getCurrentPanel().next();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void backButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.getCurrentPanel().back();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JWizardPanel getCurrentPanel() throws Exception {
        if (this.getWizardPanelList().get(this.currentIndex) != null) {
            return (JWizardPanel)this.getWizardPanelList().get(this.currentIndex);
        }
        throw new Exception("No panels in panelList");
    }

    public void updateComponents() {
        try {
            CardLayout cardLayout = (CardLayout)this.wizardPanelsContainer.getLayout();
            cardLayout.show(this.wizardPanelsContainer, this.currentIndex + "");
            if (this.currentIndex == 0) {
                this.backButton.setEnabled(false);
            } else {
                this.backButton.setEnabled(true);
            }
            if (this.onLastPanel()) {
                this.nextButton.setEnabled(false);
                this.finishButton.setEnabled(true);
            } else {
                this.finishButton.setEnabled(false);
                this.nextButton.setEnabled(true);
            }
            this.getCurrentPanel().update();
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "currentPanel", null, this.getCurrentPanel());
            this.propertyChangeListeners.firePropertyChange(propertyChangeEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List getWizardPanelList() {
        return this.panelList;
    }

    public void setWizardPanelList(ArrayList arrayList) {
        this.panelList = arrayList;
    }

    public FinishAction getFinishAction() {
        return this.finishAction;
    }

    public void setFinishAction(FinishAction finishAction) {
        this.finishAction = finishAction;
    }

    public CancelAction getCancelAction() {
        return this.cancelAction;
    }

    public void setCancelAction(CancelAction cancelAction) {
        this.cancelAction = cancelAction;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int n) {
        this.currentIndex = n;
    }

    public JPanel getWizardPanelsContainer() {
        return this.wizardPanelsContainer;
    }

    public void setWizardPanelsContainer(JPanel jPanel) {
        this.wizardPanelsContainer = jPanel;
    }

    public JButton getBackButton() {
        return this.backButton;
    }

    public void setBackButton(JButton jButton) {
        this.backButton = jButton;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public void setNextButton(JButton jButton) {
        this.nextButton = jButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(JButton jButton) {
        this.cancelButton = jButton;
    }

    public JButton getFinishButton() {
        return this.finishButton;
    }

    public void setFinishButton(JButton jButton) {
        this.finishButton = jButton;
    }

    public void setWizardPanelList(List list) {
        this.panelList = list;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.removePropertyChangeListener(propertyChangeListener);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }
}

