/*
 * Decompiled with CFR 0.152.
 */
package com.notification.manager;

import com.notification.Notification;
import com.notification.NotificationFactory;
import com.notification.NotificationManager;
import com.platform.Platform;
import com.utils.Screen;
import com.utils.Time;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SimpleManager
extends NotificationManager {
    private NotificationFactory.Location m_loc;
    private Screen m_screen = Screen.standard();
    private boolean m_fadeEnabled = false;
    private Time m_fadeTime = Time.seconds(1.0);
    private FaderRunnable m_fader;
    private Thread m_faderThread;
    private static final int FADE_DELAY = 50;

    public SimpleManager() {
        this.m_loc = NotificationFactory.Location.NORTHEAST;
    }

    public SimpleManager(NotificationFactory.Location loc) {
        this.m_loc = loc;
    }

    public Time getFadeTime() {
        return this.m_fadeTime;
    }

    public void setFadeTime(Time fadeTime) {
        this.m_fadeTime = fadeTime;
    }

    public boolean isFadeEnabled() {
        this.syncFadeEnabledWithPlatform();
        return this.m_fadeEnabled;
    }

    public void setFadeEnabled(boolean fadeEnabled) {
        this.m_fadeEnabled = fadeEnabled;
        if (fadeEnabled) {
            this.m_fader = new FaderRunnable();
            this.m_faderThread = new Thread(this.m_fader);
            this.m_faderThread.start();
        } else {
            this.m_fader.stop();
            this.m_fader = null;
            this.m_faderThread = null;
        }
        this.syncFadeEnabledWithPlatform();
    }

    private void syncFadeEnabledWithPlatform() {
        if (this.m_fadeEnabled && Platform.instance().isUsed()) {
            this.m_fadeEnabled = Platform.instance().isSupported("fade");
        }
    }

    public NotificationFactory.Location getLocation() {
        return this.m_loc;
    }

    public void setLocation(NotificationFactory.Location loc) {
        this.m_loc = loc;
    }

    protected Screen getScreen() {
        return this.m_screen;
    }

    @Override
    protected void notificationAdded(Notification note, Time time) {
        note.setLocation(this.m_screen.getX(this.m_loc, note), this.m_screen.getY(this.m_loc, note));
        if (this.isFadeEnabled()) {
            double opacity = note.getOpacity();
            note.setOpacity(0.0);
            this.startFade(note, opacity);
            this.scheduleRemoval(note, time.add(this.m_fadeTime));
        } else {
            this.scheduleRemoval(note, time);
        }
        note.show();
    }

    @Override
    protected void notificationRemoved(Notification note) {
        if (this.isFadeEnabled()) {
            this.startFade(note, -note.getOpacity());
        } else {
            note.hide();
        }
    }

    private void startFade(Notification note, double deltaOpacity) {
        this.m_fader.addFader(new Fader(note, this.getDeltaFade(deltaOpacity), note.getOpacity() + deltaOpacity));
    }

    private double getDeltaFade(double deltaOpacity) {
        return deltaOpacity / (double)this.m_fadeTime.getMilliseconds();
    }

    private class Fader {
        private Notification m_note;
        private long m_fadeStartTime;
        private double m_startFade;
        private double m_stopFade;
        private double m_deltaFade;

        public Fader(Notification note, double deltaFade, double stopFade) {
            this.m_note = note;
            this.m_deltaFade = deltaFade;
            this.m_stopFade = stopFade;
            this.m_startFade = note.getOpacity();
            this.m_fadeStartTime = System.currentTimeMillis();
        }

        public void updateFade() {
            long deltaTime = System.currentTimeMillis() - this.m_fadeStartTime;
            if (!this.isFinishedFading()) {
                this.m_note.setOpacity(this.m_startFade + this.m_deltaFade * (double)deltaTime);
            } else if (this.m_deltaFade < 0.0) {
                this.m_note.hide();
            }
        }

        public boolean isFinishedFading() {
            return this.m_deltaFade > 0.0 ? this.m_note.getOpacity() >= this.m_stopFade : this.m_note.getOpacity() <= this.m_stopFade;
        }
    }

    private class FaderRunnable
    implements Runnable {
        private List<Fader> m_faders = new CopyOnWriteArrayList<Fader>();
        private boolean m_shouldStop = false;

        public void addFader(Fader fader) {
            this.m_faders.add(fader);
        }

        public void stop() {
            this.m_shouldStop = true;
        }

        @Override
        public void run() {
            while (!this.m_shouldStop) {
                for (Fader fader : this.m_faders) {
                    fader.updateFade();
                    if (!fader.isFinishedFading()) continue;
                    this.m_faders.remove(fader);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

