/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ProxyWriter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Compiler;
import org.gvsig.expressionevaluator.ConverterToCode;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Grammar;
import org.gvsig.expressionevaluator.GrammarFactory;
import org.gvsig.expressionevaluator.GrammarSet;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.LexicalAnalyzer;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.Optimizer;
import org.gvsig.expressionevaluator.ReprMethod;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.SymbolTableFactory;
import org.gvsig.expressionevaluator.UserOperator;
import org.gvsig.expressionevaluator.impl.DefaultCodeBuilder;
import org.gvsig.expressionevaluator.impl.DefaultCompiler;
import org.gvsig.expressionevaluator.impl.DefaultExpression;
import org.gvsig.expressionevaluator.impl.DefaultExpressionBuilder;
import org.gvsig.expressionevaluator.impl.DefaultGrammar;
import org.gvsig.expressionevaluator.impl.DefaultInterpreter;
import org.gvsig.expressionevaluator.impl.DefaultOptimizer;
import org.gvsig.expressionevaluator.impl.DefaultSymbolTable;
import org.gvsig.expressionevaluator.impl.EncodingUtils;
import org.gvsig.expressionevaluator.impl.HostExpressionUtils;
import org.gvsig.expressionevaluator.impl.InmutableSymbolTable;
import org.gvsig.expressionevaluator.impl.SQLLexicalAnalyzer;
import org.gvsig.expressionevaluator.impl.SimpleScript;
import org.gvsig.expressionevaluator.impl.converterstocode.ArrayToCode;
import org.gvsig.expressionevaluator.impl.converterstocode.BooleanToCode;
import org.gvsig.expressionevaluator.impl.converterstocode.CharsequenceToCode;
import org.gvsig.expressionevaluator.impl.converterstocode.IterableToCode;
import org.gvsig.expressionevaluator.impl.converterstocode.IteratorToCode;
import org.gvsig.expressionevaluator.impl.converterstocode.ListToCode;
import org.gvsig.expressionevaluator.impl.converterstocode.NullToCode;
import org.gvsig.expressionevaluator.impl.converterstocode.NumberToCode;
import org.gvsig.expressionevaluator.impl.converterstocode.ObjectToCode;
import org.gvsig.expressionevaluator.impl.repr.ReprNull;
import org.gvsig.expressionevaluator.impl.repr.ReprObject;
import org.gvsig.expressionevaluator.impl.symboltable.BookmarksSymbolTable;
import org.gvsig.expressionevaluator.spi.BaseExpressionEvaluator;
import org.gvsig.expressionevaluator.spi.formatter.value.BaseFormatter;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.BookmarksAndHistoryManager;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.util.FilteredIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExpressionEvaluatorManager
implements ExpressionEvaluatorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExpressionEvaluatorManager.class);
    private Double accuracy;
    private final Map<String, SymbolTableFactory> symbolTableFactories;
    private final Map<String, GrammarFactory> grammarFactories;
    private Bookmarks<Expression> bookmarks;
    private static final String BOOKMARKSANDHISTORY_NAME = "ExpressionManager";
    private History<Expression> history;
    private SymbolTable inmutableSymbolTable;
    private ResourcesStorage scriptsResourcesStorage;
    private final List<ClassLoader> loaders;
    private Formatter<ExpressionBuilder.Value> expressionBuilderFormatter;
    private Map<String, ConverterToCode> convertersToCode;
    private Map<String, ConverterToCode> convertersToCode0;
    private Map<String, UserOperator> userOperators;
    private Map<String, Expression> bookmarksToRegister;
    private boolean needregisterAllBookmarks;
    private static final int MODE_EXPRESSION = 0;
    private static final int MODE_STATEMENT = 1;
    private static final Pattern RE_LANG = Pattern.compile(".*lang[:]\\s*([a-zA-Z_][a-zA-Z_0-9_]*).*");
    private static final Pattern RE_ENCODING = Pattern.compile(".*encoding[:]\\s*([a-zA-Z_][a-zA-Z0-9_-]*).*");
    private final List<ReprMethod> reprMethods = new ArrayList<ReprMethod>();
    private final Map<Class, ReprMethod> reprMethodsCache = new HashMap<Class, ReprMethod>();
    private final ReprMethod reprNull = new ReprNull();
    private final ReprMethod reprObject = new ReprObject();

    public DefaultExpressionEvaluatorManager() {
        this.symbolTableFactories = new HashMap<String, SymbolTableFactory>();
        this.grammarFactories = new HashMap<String, GrammarFactory>();
        this.loaders = new ArrayList<ClassLoader>();
        this.scriptsResourcesStorage = ResourcesStorage.EMPTY_RESOURCESSTORAGE;
        this.loaders.add(this.getClass().getClassLoader());
        this.expressionBuilderFormatter = new BaseFormatter();
        this.bookmarksToRegister = new HashMap<String, Expression>();
        this.needregisterAllBookmarks = false;
    }

    public SymbolTable getSymbolTable(String name) {
        if (name == null) {
            return null;
        }
        SymbolTableFactory factory = this.symbolTableFactories.get(name.toUpperCase());
        if (factory == null) {
            return null;
        }
        return factory.create(new Object[0]);
    }

    public Collection<SymbolTableFactory> getSymbolTableFactories() {
        return this.symbolTableFactories.values();
    }

    public final void registerSymbolTable(SymbolTableFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory can't be null");
        }
        this.symbolTableFactories.put(factory.getName().toUpperCase(), factory);
        this.inmutableSymbolTable = null;
    }

    public SymbolTable getInmutableSymbolTable() {
        if (this.inmutableSymbolTable == null) {
            this.inmutableSymbolTable = new InmutableSymbolTable();
        }
        return this.inmutableSymbolTable;
    }

    public Object evaluate(String source) {
        Compiler compiler = this.createCompiler();
        Code code = compiler.compileExpression(source);
        DefaultInterpreter interpreter = new DefaultInterpreter();
        return interpreter.run(code);
    }

    public Object evaluate(SymbolTable symbolTable, String source) {
        Compiler compiler = this.createCompiler();
        Code code = compiler.compileExpression(source);
        return this.evaluate(symbolTable, code);
    }

    public Object evaluate(SymbolTable symbolTable, Code code) {
        DefaultInterpreter interpreter = new DefaultInterpreter();
        if (symbolTable != null) {
            interpreter.setSymbolTable(symbolTable);
        }
        return interpreter.run(code);
    }

    public String evaluateDynamicText(String source) {
        return this.evaluateDynamicText(null, source);
    }

    public boolean isDynamicText(String source) {
        Object[] sources = StringUtils.substringsBetween((String)source, (String)"<%", (String)"%>");
        return !ArrayUtils.isEmpty((Object[])sources);
    }

    public static String dynamicTextToScript(String s, String contentsName) {
        PushbackReader reader = new PushbackReader(new StringReader(s), 100);
        StringBuilder script = new StringBuilder();
        StringBuilder buffer = new StringBuilder();
        try {
            int ch;
            script.append("begin\n");
            block6: while ((ch = reader.read()) != -1) {
                switch (ch) {
                    case 60: {
                        boolean mode;
                        int ch2 = reader.read();
                        if (ch2 != 37) {
                            buffer.append((char)ch);
                            buffer.append((char)ch2);
                            continue block6;
                        }
                        ch2 = reader.read();
                        if (ch2 == 61) {
                            mode = false;
                        } else {
                            mode = true;
                            reader.unread(ch2);
                        }
                        if (buffer.length() > 0) {
                            script.append(contentsName);
                            script.append(".append('");
                            script.append(buffer.toString());
                            script.append("');");
                        }
                        buffer.setLength(0);
                        while ((ch = reader.read()) != -1) {
                            if (ch == 37) {
                                ch2 = reader.read();
                                if (ch2 == 62) {
                                    if (!mode) {
                                        if (buffer.length() > 0) {
                                            script.append(contentsName);
                                            script.append(".append(");
                                            script.append(buffer.toString());
                                            script.append(");");
                                        }
                                    } else {
                                        script.append(buffer.toString());
                                    }
                                    buffer.setLength(0);
                                    continue block6;
                                }
                                buffer.append((char)ch);
                                buffer.append((char)ch2);
                                continue;
                            }
                            buffer.append((char)ch);
                        }
                        continue block6;
                    }
                    case 39: {
                        buffer.append('\'');
                        buffer.append('\'');
                        continue block6;
                    }
                }
                buffer.append((char)ch);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (buffer.length() > 0) {
            script.append(contentsName);
            script.append(".append('");
            script.append(buffer.toString());
            script.append("');");
            script.append("\n");
        }
        script.append("end\n");
        return script.toString();
    }

    public String evaluateDynamicText(SymbolTable symbolTable, String source) {
        return this.evaluateDynamicText(symbolTable, source, null);
    }

    public String evaluateDynamicText(SymbolTable symbolTable, String source, Writer output) {
        return this.evaluateDynamicText(symbolTable, source, output, this.scriptsResourcesStorage);
    }

    public String evaluateDynamicText(SymbolTable symbolTable, String source, Writer output, ResourcesStorage resources) {
        try {
            if (!StringUtils.contains((CharSequence)source, (CharSequence)"<%")) {
                if (output == null) {
                    return source;
                }
                output.append(source);
                return null;
            }
            AppendExWriter writer = output == null ? new AppendExWriter(new StringWriter()) : new AppendExWriter(output);
            String script = DefaultExpressionEvaluatorManager.dynamicTextToScript(source, "contents");
            MutableSymbolTable st = this.createSymbolTable();
            if (symbolTable != null) {
                st.addSymbolTable(symbolTable);
            }
            st.setVar("contents", (Object)writer);
            Compiler compiler = this.createCompiler();
            DefaultInterpreter interpreter = new DefaultInterpreter();
            interpreter.setSymbolTable((SymbolTable)st);
            if (resources != null) {
                interpreter.setResourcesStorage(resources);
            }
            Code code = compiler.compileExpression(script);
            interpreter.run(code);
            if (output == null) {
                return ((StringWriter)writer.getWriter()).toString();
            }
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't evaluate dynamic-text.", ex);
        }
    }

    public String evaluateDynamicText_old(SymbolTable symbolTable, String source) {
        Object[] sources = StringUtils.substringsBetween((String)source, (String)"<%", (String)"%>");
        if (ArrayUtils.isEmpty((Object[])sources)) {
            return source;
        }
        String[] values = new String[sources.length];
        DefaultInterpreter interpreter = new DefaultInterpreter();
        if (symbolTable != null) {
            interpreter.setSymbolTable(symbolTable);
        }
        StringWriter writer = new StringWriter();
        interpreter.setWriter(writer);
        DefaultCompiler compiler = new DefaultCompiler(this);
        for (int i = 0; i < sources.length; ++i) {
            Code code;
            Object theSource = sources[i];
            if (StringUtils.startsWith((CharSequence)theSource, (CharSequence)"=")) {
                code = compiler.compileExpression(((String)theSource).substring(1));
                Object value = interpreter.run(code);
                values[i] = Objects.toString(value, "");
            } else {
                code = compiler.compileExpression(((String)theSource).substring(0));
                writer.getBuffer().setLength(0);
                interpreter.run(code);
                values[i] = writer.toString();
            }
            sources[i] = "<%" + (String)sources[i] + "%>";
        }
        String output = StringUtils.replaceEach((String)source, (String[])sources, (String[])values);
        return output;
    }

    public Code compile(String source) {
        Compiler compiler = this.createCompiler();
        return compiler.compileExpression(source);
    }

    public Code compile(LexicalAnalyzer lex, String source) {
        Compiler compiler = this.createCompiler();
        compiler.setLexicalAnalyzer(lex);
        return compiler.compileExpression(source);
    }

    public Code optimize(SymbolTable symbolTable, Code code) {
        Optimizer optimizer = this.createOptimizer();
        return optimizer.optimize(symbolTable, code);
    }

    public MutableSymbolTable createSymbolTable() {
        DefaultSymbolTable theSymbolTable = new DefaultSymbolTable();
        return theSymbolTable;
    }

    public MutableSymbolTable createEmptySymbolTable() {
        DefaultSymbolTable theSymbolTable = new DefaultSymbolTable(false);
        return theSymbolTable;
    }

    public void populateSymbolTable(SymbolTable aSymbolTable) {
        for (SymbolTableFactory factory : this.getSymbolTableFactories()) {
            try {
                if (!factory.isAutoload()) continue;
                SymbolTable symbolTable = factory.create(new Object[0]);
                aSymbolTable.addSymbolTable(symbolTable);
            }
            catch (Throwable th) {
                String factoryName = "Unknown";
                try {
                    factoryName = factory.getName();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                LOGGER.warn("Can't create symbol table '" + factoryName + "', ignore this symbol table.");
                LOGGER.debug("Error creating symbol table.", th);
            }
        }
    }

    public LexicalAnalyzer createLexicalAnalyzer() {
        return new SQLLexicalAnalyzer();
    }

    public CodeBuilder createCodeBuilder() {
        return new DefaultCodeBuilder(this);
    }

    public Compiler createCompiler() {
        DefaultCompiler compiler = new DefaultCompiler(this);
        this.populateGrammars(compiler);
        return compiler;
    }

    public Interpreter createInterpreter() {
        DefaultInterpreter interpreter = new DefaultInterpreter();
        interpreter.setResourcesStorage(this.scriptsResourcesStorage);
        return interpreter;
    }

    public Double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(Double accuracy) {
        this.accuracy = accuracy;
    }

    public Expression createExpression() {
        DefaultExpression e = new DefaultExpression(this);
        return e;
    }

    public ExpressionBuilder createExpressionBuilder() {
        DefaultExpressionBuilder x = new DefaultExpressionBuilder(this);
        return x;
    }

    public Optimizer createOptimizer() {
        DefaultOptimizer x = new DefaultOptimizer(this);
        return x;
    }

    public void registerGrammar(GrammarFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory can't be null");
        }
        this.grammarFactories.put(factory.getName(), factory);
    }

    public Collection<GrammarFactory> getGrammarFactories() {
        return this.grammarFactories.values();
    }

    public void populateGrammars(Compiler compiler) {
        GrammarSet grammarSet = compiler.getGrammars();
        for (GrammarFactory factory : this.getGrammarFactories()) {
            if (!factory.isAutoload()) continue;
            Grammar grammar = factory.create(new Object[0]);
            grammarSet.add(grammar);
        }
    }

    public Grammar createGrammar(String name) {
        DefaultGrammar grammar = new DefaultGrammar(name);
        return grammar;
    }

    public Bookmarks<Expression> getBookmarks() {
        BookmarksAndHistoryManager bookmarkManager = ToolsLocator.getBookmarksAndHistoryManager();
        if (this.bookmarks == null) {
            BookmarksAndHistoryManager manager = ToolsLocator.getBookmarksAndHistoryManager();
            if (manager.getPrimaryStorage() == null && manager.getSecondaryStorage() == null) {
                return null;
            }
            this.bookmarks = bookmarkManager.getBookmarksGroup(BOOKMARKSANDHISTORY_NAME);
        }
        return this.bookmarks;
    }

    public History<Expression> getHistory() {
        if (this.history == null) {
            this.history = ToolsLocator.getBookmarksAndHistoryManager().getHistoryGroup(BOOKMARKSANDHISTORY_NAME);
        }
        return this.history;
    }

    public Script createScript(String name, String code, String languaje) {
        SimpleScript sc = new SimpleScript(this.createInterpreter(), name, code);
        return sc;
    }

    public Script locateScript(String name) {
        return this.loadScript(this.scriptsResourcesStorage, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script loadScript(URI location) {
        Script script;
        String resourceName;
        ResourcesStorage.Resource res;
        block7: {
            block6: {
                res = null;
                if (location != null) break block6;
                Script script2 = null;
                IOUtils.closeQuietly(res);
                return script2;
            }
            resourceName = FilenameUtils.getBaseName((String)location.getPath());
            res = ResourcesStorage.createResource((String)resourceName, (URI)location);
            if (res != null && res.exists()) break block7;
            Script script3 = null;
            IOUtils.closeQuietly((Closeable)res);
            return script3;
        }
        try {
            Script script4;
            script = script4 = this.loadScript(res, resourceName);
        }
        catch (Exception ex) {
            Script script5;
            try {
                LOGGER.warn("Can't load script from URI.", (Throwable)ex);
                script5 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(res);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)res);
            return script5;
        }
        IOUtils.closeQuietly((Closeable)res);
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script loadScript(ResourcesStorage storage, String name) {
        Script script;
        ResourcesStorage.Resource res;
        block7: {
            block6: {
                res = null;
                if (storage != null) break block6;
                Script script2 = null;
                IOUtils.closeQuietly(res);
                return script2;
            }
            res = storage.getResource(name);
            if (res != null && res.exists()) break block7;
            Script script3 = null;
            IOUtils.closeQuietly((Closeable)res);
            return script3;
        }
        try {
            Script script4;
            script = script4 = this.loadScript(res, name);
        }
        catch (Exception ex) {
            Script script5;
            try {
                LOGGER.warn("Can't load script from resources storage.", (Throwable)ex);
                script5 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(res);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)res);
            return script5;
        }
        IOUtils.closeQuietly((Closeable)res);
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Script loadScript(ResourcesStorage.Resource res, String name) {
        try {
            Script script;
            String s;
            if (res == null || !res.exists()) {
                Script script2 = null;
                return script2;
            }
            String head = EncodingUtils.getFirstLine(res.asInputStream());
            IOUtils.closeQuietly((Closeable)res);
            if (StringUtils.isEmpty((CharSequence)head)) {
                Script script3 = null;
                return script3;
            }
            String encoding = EncodingUtils.getEncoding(head);
            String lang = "cosa";
            Matcher m = RE_LANG.matcher(head);
            if (m != null && m.matches() && m.groupCount() == 1 && !StringUtils.isBlank((CharSequence)(s = m.group(1)))) {
                lang = s;
            }
            String source = StringUtils.isBlank((CharSequence)encoding) ? IOUtils.toString((InputStream)res.asInputStream()) : IOUtils.toString((InputStream)res.asInputStream(), (String)encoding);
            Script script4 = script = this.createScript(name, source, lang);
            return script4;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't load script from resource.", (Throwable)ex);
            Script script = null;
            return script;
        }
        finally {
            IOUtils.closeQuietly((Closeable)res);
        }
    }

    public ResourcesStorage getScriptsResourcesStorage() {
        return this.scriptsResourcesStorage;
    }

    public void setScriptsResourcesStorage(ResourcesStorage scriptsResourcesStorage) {
        if (this.scriptsResourcesStorage != null) {
            DisposeUtils.disposeQuietly((Disposable)this.scriptsResourcesStorage);
        }
        DisposeUtils.bind((Disposable)scriptsResourcesStorage);
        this.scriptsResourcesStorage = scriptsResourcesStorage;
    }

    public void addReprMethod(ReprMethod method) {
        this.reprMethods.add(method);
        this.reprMethodsCache.clear();
    }

    public ReprMethod getReprMethod(Object value) {
        if (value == null) {
            return this.reprNull;
        }
        ReprMethod method = this.reprMethodsCache.get(value.getClass());
        if (method != null) {
            return method;
        }
        for (ReprMethod theMethod : this.reprMethods) {
            if (!theMethod.isApplicable(value)) continue;
            this.reprMethodsCache.put(value.getClass(), theMethod);
            return theMethod;
        }
        return this.reprObject;
    }

    public void registerClassLoader(ClassLoader loader) {
        this.loaders.add(loader);
    }

    public List<ClassLoader> getClassLoaders() {
        return Collections.unmodifiableList(this.loaders);
    }

    public Formatter<ExpressionBuilder.Value> getExpressionBuilderFormatter() {
        return this.expressionBuilderFormatter;
    }

    public void registerExpressionBuilderFormatter(Formatter<ExpressionBuilder.Value> formatter) {
        this.expressionBuilderFormatter = formatter;
    }

    public ExpressionEvaluator createExpressionEvaluator(Expression expression) {
        return new BaseExpressionEvaluator(expression);
    }

    public ExpressionEvaluator createEvaluator(String expression) {
        Expression exp = this.createExpression();
        exp.setPhrase(expression);
        return new BaseExpressionEvaluator(exp);
    }

    public boolean hasHostExpressions(Code statement) {
        try {
            ArrayList hostExpressions = new ArrayList();
            statement.accept(code -> {
                if (!(code instanceof Code.Callable)) {
                    return;
                }
                Code.Callable callable = (Code.Callable)code;
                if (StringUtils.equalsIgnoreCase((CharSequence)callable.name(), (CharSequence)"$HOSTEXPRESSION")) {
                    hostExpressions.add(callable);
                }
            }, null);
            return !hostExpressions.isEmpty();
        }
        catch (BaseException ex) {
            throw new RuntimeException("Can't check host expressions", ex);
        }
    }

    public boolean hasHostExpressions(ExpressionBuilder.Value statement) {
        return HostExpressionUtils.hasHostExpressions(statement);
    }

    public Code resolveHostExpressions(Code statement, Interpreter interpreter) {
        return HostExpressionUtils.resolveHostExpressions(statement, interpreter);
    }

    public ExpressionBuilder.Value resolveHostExpressions(ExpressionBuilder.Value statement, SymbolTable symbolTable) {
        return HostExpressionUtils.resolveHostExpressions(statement, symbolTable);
    }

    public Code resolveHostExpressions(Code statement, SymbolTable symbolTable) {
        return HostExpressionUtils.resolveHostExpressions(statement, symbolTable);
    }

    public Expression resolveHostExpressions(Expression expression, SymbolTable symbolTable) {
        return HostExpressionUtils.resolveHostExpressions(expression, symbolTable);
    }

    public boolean hasHostExpressions(String statement) {
        return HostExpressionUtils.hasHostExpressions(statement);
    }

    public ExpressionBuilder.Value getHostExpressionValue(ExpressionBuilder.Function hostExpression, ExpressionBuilder expbuilder) {
        return HostExpressionUtils.getHostExpressionValue(hostExpression, expbuilder);
    }

    public ExpressionBuilder.Value getHostExpressionValue(ExpressionBuilder.Function hostExpression, ExpressionBuilder expbuilder, SymbolTable symbolTable) {
        return HostExpressionUtils.getHostExpressionValue(hostExpression, expbuilder, symbolTable);
    }

    public void initConvertersToCode() {
        ConverterToCode[] converters;
        this.convertersToCode0 = new LinkedHashMap<String, ConverterToCode>();
        for (ConverterToCode converter : converters = new ConverterToCode[]{new NullToCode(), new CharsequenceToCode(), new NumberToCode(), new BooleanToCode(), new IteratorToCode(), new IterableToCode(), new ListToCode(), new ArrayToCode(), new ObjectToCode()}) {
            this.convertersToCode0.put(converter.getName(), converter);
        }
        this.convertersToCode = new LinkedHashMap<String, ConverterToCode>();
    }

    public void registerCodeConverter(ConverterToCode converter) {
        if (this.convertersToCode == null) {
            this.initConvertersToCode();
        }
        this.convertersToCode.put(converter.getName(), converter);
    }

    public ConverterToCode getConverterToCode(Object ob) {
        if (this.convertersToCode == null) {
            this.initConvertersToCode();
        }
        for (ConverterToCode converter : this.convertersToCode.values()) {
            if (!converter.isApplicable(new Object[]{ob})) continue;
            return converter;
        }
        for (ConverterToCode converter : this.convertersToCode0.values()) {
            if (!converter.isApplicable(new Object[]{ob})) continue;
            return converter;
        }
        return null;
    }

    public ExpressionBuilder.Value convertToValue(Object obj) {
        Code code = this.convertToCode(obj);
        ExpressionBuilder.Value value = code.toValue();
        return value;
    }

    public Code convertToCode(Object obj) {
        return this.convertToCode(null, obj, null);
    }

    public Code convertToCode(CodeBuilder builder, Object obj, Map<String, Object> props) {
        if (this.convertersToCode == null) {
            this.initConvertersToCode();
        }
        if (builder == null) {
            builder = this.createCodeBuilder();
        }
        for (ConverterToCode converter : this.convertersToCode.values()) {
            if (!converter.isApplicable(new Object[]{obj})) continue;
            return converter.toCode(builder, obj, props);
        }
        for (ConverterToCode converter : this.convertersToCode0.values()) {
            if (!converter.isApplicable(new Object[]{obj})) continue;
            return converter.toCode(builder, obj, props);
        }
        return null;
    }

    public ConverterToCode getConverterToCodeByName(String name) {
        ConverterToCode converter = this.convertersToCode.get(name);
        if (converter != null) {
            return converter;
        }
        converter = this.convertersToCode0.get(name);
        return converter;
    }

    public void registerUserOperator(UserOperator userOperator) {
        if (this.userOperators == null) {
            this.userOperators = new HashMap<String, UserOperator>();
        }
        this.userOperators.put(userOperator.name(), userOperator);
    }

    public Iterable<UserOperator> getUserDefinedOperators(String precedence) {
        if (this.userOperators == null) {
            return Collections.EMPTY_LIST;
        }
        if (StringUtils.isBlank((CharSequence)precedence)) {
            return this.userOperators.values();
        }
        return new FilteredIterable(this.userOperators.values(), t -> StringUtils.equalsIgnoreCase((CharSequence)precedence, (CharSequence)t.precedence()));
    }

    public SymbolTable createBookmarksSymbolTable(String bookmarkGroup) {
        BookmarksSymbolTable symbolTable = new BookmarksSymbolTable(bookmarkGroup);
        return symbolTable;
    }

    public static class AppendExWriter
    extends ProxyWriter {
        public AppendExWriter(Writer writer) {
            super(writer);
        }

        public Writer append(Object x) throws IOException {
            if (x != null) {
                this.append(x.toString());
            }
            return this;
        }

        public Writer getWriter() {
            return this.out;
        }
    }
}

