/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.numeric;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class ATanFunction
extends AbstractFunction {
    public ATanFunction() {
        super("Numeric", "ATAN", Range.is((Comparable)Integer.valueOf(1)), "Returns the arc tangent of a value; the returned angle is in the range -pi/2 through pi/2. Special cases:\n- If the argument is NaN, then the result is NaN.\n- If the argument is zero, then the result is a zero with the same sign as the argument.\nThe computed result must be within 1 ulp of the exact result. Results must be semi-monotonic.\n", "ATAN({{a}})", new String[]{"a - the value whose arc tangent is to be returned."}, "Double", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        double r = Math.atan(this.getDouble(args, 0));
        return r;
    }
}

