/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.PrettyFormatter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;

public class CaseFunction
extends AbstractFunction {
    public static final String NAME = "CASE";

    public CaseFunction() {
        super("Programming", NAME, Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), "", "CASE\n  WHEN {{condition}} THEN PASS\n  ELSE PASS\nEND CASE\n", null, "Object", true);
    }

    public boolean isHidden() {
        return true;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        int elseValue;
        int firstValue;
        int count;
        Coercion toBoolean = ToolsLocator.getDataTypesManager().getCoercion(1);
        if (args.size() % 2 == 0) {
            firstValue = count = args.size() / 2;
            elseValue = -1;
        } else {
            firstValue = count = (args.size() - 1) / 2;
            elseValue = args.size() - 1;
        }
        boolean needElse = true;
        Object value = null;
        for (int n = 0; n < count; ++n) {
            Object condition_o = this.getObject(interpreter, args, n);
            Boolean condition = (Boolean)toBoolean.coerce(condition_o);
            if (condition == null || !condition.booleanValue()) continue;
            needElse = false;
            value = this.getObject(interpreter, args, n + firstValue);
            return value;
        }
        if (needElse && elseValue > 0) {
            value = this.getObject(interpreter, args, elseValue);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Codes args, Formatter<Code> formatter) {
        PrettyFormatter builder = PrettyFormatter.get(formatter);
        try {
            int elseValue;
            int firstValue;
            int count;
            builder.push();
            Code codeElse = null;
            if (args.size() % 2 == 0) {
                firstValue = count = args.size() / 2;
                elseValue = -1;
            } else {
                firstValue = count = (args.size() - 1) / 2;
                elseValue = args.size() - 1;
                codeElse = elseValue > 0 ? (Code)args.get(elseValue) : null;
            }
            builder.append((Object)"CASE ");
            builder.indent();
            for (int n = 0; n < count; ++n) {
                builder.nl();
                builder.append((Object)"WHEN ");
                builder.append((Object)((Code)args.get(n)).toString(formatter));
                builder.append((Object)" THEN ");
                builder.indent();
                builder.nl();
                Code codeBody = (Code)args.get(n + firstValue);
                if (Code.isFunction((Code)codeBody, (String)"BLOCK")) {
                    Code.Callable block = (Code.Callable)codeBody;
                    for (Code parameter : block.parameters()) {
                        builder.nl();
                        builder.append((Object)parameter.toString(formatter));
                        builder.append((Object)"; ");
                    }
                } else {
                    builder.nl();
                    builder.append((Object)codeBody.toString(formatter));
                    builder.append((Object)"; ");
                }
                builder.unindent();
            }
            if (codeElse != null) {
                builder.nl();
                builder.append((Object)"ELSE ");
                builder.indent();
                builder.nl();
                if (Code.isFunction((Code)codeElse, (String)"BLOCK")) {
                    Code.Callable block = (Code.Callable)codeElse;
                    for (Code parameter : block.parameters()) {
                        builder.nl();
                        builder.append((Object)parameter.toString(formatter));
                        builder.append((Object)"; ");
                    }
                } else {
                    builder.nl();
                    builder.append((Object)codeElse.toString(formatter));
                    builder.append((Object)"; ");
                }
                builder.unindent();
            }
            builder.unindent();
            builder.nl();
            builder.append((Object)"END");
            String string = builder.build();
            return string;
        }
        finally {
            builder.pop();
        }
    }
}

