/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class IIFFunction
extends AbstractFunction {
    public IIFFunction() {
        super("Boolean", "IIF", Range.is((Comparable)Integer.valueOf(3)), "IIF() function tests a specified numeric expression and returns one of two values, based on whether the expression tested was true or false.", "IIF({{condition}},true,false)", null, "Object", true);
    }

    public boolean useArgumentsInsteadObjects() {
        return false;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        boolean condition = this.getBoolean(args, 0);
        if (condition) {
            return args[1];
        }
        return args[2];
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        boolean condition = this.getBoolean(interpreter, args, 0);
        Object value = condition ? this.getObject(interpreter, args, 1) : (args.size() > 2 && args.get(2) != null ? this.getObject(interpreter, args, 2) : null);
        return value;
    }
}

