/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.PrettyFormatter;
import org.gvsig.expressionevaluator.impl.function.programming.BreakFunction;
import org.gvsig.expressionevaluator.impl.function.programming.ReturnFunction;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class WhileFunction
extends AbstractFunction {
    public static final String NAME = "WHILE";

    public WhileFunction() {
        super("Programming", NAME, Range.is((Comparable)Integer.valueOf(2)), "The while() function evaluate expression while the condition is true.", "WHILE {{condition}} BEGIN\n  PASS;\nEND WHILE\n", null, "Object", false);
    }

    public boolean isHidden() {
        return true;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        Object body = null;
        int argn = 0;
        boolean condition = this.getBoolean(interpreter, args, 0);
        while (condition) {
            try {
                body = this.getObject(interpreter, args, 1);
            }
            catch (BreakFunction.BreakException ex) {
                break;
            }
            catch (ReturnFunction.ReturnException ex) {
                throw ex;
            }
            catch (Exception ex) {
                String stmt = "unknown";
                try {
                    stmt = Objects.toString(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOGGER.warn("Error in while function calling arg " + argn + ", " + stmt, (Throwable)ex);
                throw ex;
            }
            condition = this.getBoolean(interpreter, args, 0);
            ++argn;
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Codes args, Formatter<Code> formatter) {
        Code codeCondition = (Code)args.get(0);
        Code codeLoopBody = (Code)args.get(1);
        PrettyFormatter builder = PrettyFormatter.get(formatter);
        try {
            builder.push();
            builder.append((Object)"WHILE ");
            builder.append((Object)codeCondition.toString(formatter));
            builder.append((Object)" LOOP ");
            builder.indent();
            builder.nl();
            if (Code.isFunction((Code)codeLoopBody, (String)"BLOCK")) {
                Code.Callable block = (Code.Callable)codeLoopBody;
                for (Code parameter : block.parameters()) {
                    builder.nl();
                    builder.append((Object)parameter.toString(formatter));
                    builder.append((Object)"; ");
                }
            } else {
                builder.nl();
                builder.append((Object)codeLoopBody.toString(formatter));
                builder.append((Object)" ");
            }
            builder.unindent();
            builder.nl();
            builder.append((Object)"END LOOP ");
            String string = builder.build();
            return string;
        }
        finally {
            builder.pop();
        }
    }
}

