/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.string;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class InstrFunction
extends AbstractFunction {
    public InstrFunction() {
        super("String", "INSTR", Range.is((Comparable)Integer.valueOf(2)), "The functions search string for substring. The function returns an integer indicating the position of the character in string that is the first character of this occurrence.\nThe function returns a numeric value. The first position in the string is 1. If substring is not found in string, then the function will return 0", "INSTR({{string}}, substring)", new String[]{"string - String in which to perform the search.  ", "substring - String to search"}, "Integer", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        String str = this.getStr(args, 0);
        String search = this.getStr(args, 1);
        if (str == null || search == null) {
            return null;
        }
        int n = str.indexOf(search);
        if (n < 0) {
            return 0;
        }
        return n + 1;
    }
}

