/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.typeconversion;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonPathContext;
import org.gvsig.json.PathNotFoundException;
import org.gvsig.tools.util.ToolsUtilLocator;

public class JsonValueFunction
extends AbstractFunction {
    public JsonValueFunction() {
        super("Conversion", "JSON_VALUE", Range.is((Comparable)Integer.valueOf(2)), "finds a specified scalar JSON value in JSON data and returns it.", "JSON_VALUE({{expr}}, JsonPath)", new String[]{"expr - specify an expression that evaluates to a text literal.", "JsonPath - specify a JSON path expression."}, "Object", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public static Object json_value(String json, String path) {
        Object value;
        JsonPathContext context;
        if (json == null || path == null) {
            return null;
        }
        JsonManager manager = ToolsUtilLocator.getJsonManager();
        try {
            context = manager.createJSonPathContext(json);
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException("Invalid input syntax for type json", (Throwable)ex);
        }
        try {
            value = context.get(path);
        }
        catch (PathNotFoundException ex) {
            return null;
        }
        if (value instanceof List) {
            List l = (List)value;
            value = l.get(0);
        } else if (value instanceof Object[]) {
            Object[] a = (Object[])value;
            value = a[0];
        }
        return value;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        String json = Objects.toString(this.getObject(args, 0), null);
        String path = Objects.toString(this.getObject(args, 1), null);
        Object value = JsonValueFunction.json_value(json, path);
        return value;
    }
}

