/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaScrollBarUI;
import ch.randelshofer.quaqua.QuaquaScrollPaneLayout;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class QuaquaScrollPaneUI
extends BasicScrollPaneUI
implements VisuallyLayoutable {
    private Handler handler;
    private boolean setValueCalled = false;
    private PropertyChangeListener vsbPropertyChangeListener;
    private PropertyChangeListener hsbPropertyChangeListener;
    private MouseWheelListener mouseScrollListener;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaScrollPaneUI();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    @Override
    protected void installDefaults(JScrollPane scrollpane) {
        super.installDefaults(scrollpane);
        if (scrollpane.getLayout() instanceof UIResource) {
            QuaquaScrollPaneLayout.UIResource layout = new QuaquaScrollPaneLayout.UIResource();
            scrollpane.setLayout(layout);
            layout.syncWithScrollPane(scrollpane);
        }
        if (QuaquaManager.getProperty("java.version").startsWith("1.5")) {
            scrollpane.setOpaque(UIManager.getBoolean("ScrollPane.opaque"));
        } else {
            QuaquaUtilities.installProperty(scrollpane, "opaque", UIManager.get("ScrollPane.opaque"));
        }
        scrollpane.setFocusable(UIManager.getBoolean("ScrollPane.focusable"));
    }

    @Override
    protected void uninstallDefaults(JScrollPane scrollpane) {
        super.uninstallDefaults(scrollpane);
        if (scrollpane.getLayout() instanceof UIResource) {
            ScrollPaneLayout.UIResource layout = new ScrollPaneLayout.UIResource();
            scrollpane.setLayout(layout);
            layout.syncWithScrollPane(scrollpane);
        }
    }

    @Override
    protected void installListeners(JScrollPane c) {
        this.vsbChangeListener = this.createVSBChangeListener();
        this.vsbPropertyChangeListener = this.createVSBPropertyChangeListener();
        this.hsbChangeListener = this.createHSBChangeListener();
        this.hsbPropertyChangeListener = this.createHSBPropertyChangeListener();
        this.viewportChangeListener = this.createViewportChangeListener();
        this.spPropertyChangeListener = this.createPropertyChangeListener();
        JViewport viewport = this.scrollpane.getViewport();
        JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
        JScrollBar hsb = this.scrollpane.getHorizontalScrollBar();
        if (viewport != null) {
            viewport.addChangeListener(this.viewportChangeListener);
        }
        if (vsb != null) {
            vsb.getModel().addChangeListener(this.vsbChangeListener);
            vsb.addPropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (hsb != null) {
            hsb.getModel().addChangeListener(this.hsbChangeListener);
            hsb.addPropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.addPropertyChangeListener(this.spPropertyChangeListener);
        this.mouseScrollListener = this.createMouseWheelListener();
        this.scrollpane.addMouseWheelListener(this.mouseScrollListener);
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        JViewport viewport = this.scrollpane.getViewport();
        JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
        JScrollBar hsb = this.scrollpane.getHorizontalScrollBar();
        if (viewport != null) {
            viewport.removeChangeListener(this.viewportChangeListener);
        }
        if (vsb != null) {
            vsb.getModel().removeChangeListener(this.vsbChangeListener);
            vsb.removePropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (hsb != null) {
            hsb.getModel().removeChangeListener(this.hsbChangeListener);
            hsb.removePropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.removePropertyChangeListener(this.spPropertyChangeListener);
        if (this.mouseScrollListener != null) {
            this.scrollpane.removeMouseWheelListener(this.mouseScrollListener);
        }
        this.vsbChangeListener = null;
        this.hsbChangeListener = null;
        this.viewportChangeListener = null;
        this.spPropertyChangeListener = null;
        this.mouseScrollListener = null;
        this.handler = null;
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        return this.getHandler();
    }

    private PropertyChangeListener createVSBPropertyChangeListener() {
        return this.getHandler();
    }

    private PropertyChangeListener createHSBPropertyChangeListener() {
        return this.getHandler();
    }

    @Override
    protected ChangeListener createVSBChangeListener() {
        return this.getHandler();
    }

    @Override
    protected ChangeListener createHSBChangeListener() {
        return this.getHandler();
    }

    @Override
    protected ChangeListener createViewportChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    public Insets getVisualMargin(Component c) {
        Insets margin = (Insets)((JComponent)c).getClientProperty("Quaqua.Component.visualMargin");
        if (margin == null) {
            margin = UIManager.getInsets("Component.visualMargin");
        }
        return margin == null ? new Insets(0, 0, 0, 0) : margin;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Debug.paint(g, c, this);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            Insets margin = this.getVisualMargin(c);
            g.fillRect(margin.left, margin.top, c.getWidth() - margin.left - margin.right, c.getHeight() - margin.top - margin.bottom);
            this.paint(g, c);
            Debug.paint(g, c, this);
        }
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        return -1;
    }

    @Override
    public Rectangle getVisualBounds(JComponent c, int type, int width, int height) {
        Rectangle bounds = new Rectangle(0, 0, width, height);
        if (type == 0) {
            return bounds;
        }
        JScrollPane b = (JScrollPane)c;
        if (type == 1 && b.getBorder() != null) {
            Border border = b.getBorder();
            if (border instanceof UIResource) {
                InsetsUtil.subtractInto(this.getVisualMargin(b), bounds);
            }
            return bounds;
        }
        return bounds;
    }

    @Override
    protected void syncScrollPaneWithViewport() {
        JViewport viewport = this.scrollpane.getViewport();
        JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
        JScrollBar hsb = this.scrollpane.getHorizontalScrollBar();
        JViewport rowHead = this.scrollpane.getRowHeader();
        JViewport colHead = this.scrollpane.getColumnHeader();
        boolean ltr = this.scrollpane.getComponentOrientation().isLeftToRight();
        if (viewport != null) {
            int value;
            int max;
            int extent;
            Dimension extentSize = viewport.getExtentSize();
            Dimension viewSize = viewport.getViewSize();
            Point viewPosition = viewport.getViewPosition();
            if (vsb != null) {
                extent = extentSize.height;
                max = viewSize.height;
                value = Math.max(0, Math.min(viewPosition.y, max - extent));
                vsb.setValues(value, extent, 0, max);
            }
            if (hsb != null) {
                extent = extentSize.width;
                max = viewSize.width;
                if (ltr) {
                    value = Math.max(0, Math.min(viewPosition.x, max - extent));
                } else {
                    int currentValue = hsb.getValue();
                    if (this.setValueCalled && max - currentValue == viewPosition.x) {
                        value = Math.max(0, Math.min(max - extent, currentValue));
                        if (extent != 0) {
                            this.setValueCalled = false;
                        }
                    } else if (extent > max) {
                        viewPosition.x = max - extent;
                        viewport.setViewPosition(viewPosition);
                        value = 0;
                    } else {
                        value = Math.max(0, Math.min(max - extent, max - extent - viewPosition.x));
                    }
                }
                hsb.setValues(value, extent, 0, max);
            }
            if (rowHead != null) {
                Point p = rowHead.getViewPosition();
                p.y = viewport.getViewPosition().y;
                p.x = 0;
                rowHead.setViewPosition(p);
            }
            if (colHead != null) {
                Point p = colHead.getViewPosition();
                p.x = ltr ? viewport.getViewPosition().x : Math.max(0, viewport.getViewPosition().x);
                p.y = 0;
                colHead.setViewPosition(p);
            }
        }
    }

    private void updateHorizontalScrollBar(PropertyChangeEvent pce) {
        this.updateScrollBar(pce, this.hsbChangeListener, this.hsbPropertyChangeListener);
    }

    private void updateVerticalScrollBar(PropertyChangeEvent pce) {
        this.updateScrollBar(pce, this.vsbChangeListener, this.vsbPropertyChangeListener);
    }

    private void updateScrollBar(PropertyChangeEvent pce, ChangeListener cl, PropertyChangeListener pcl) {
        JScrollBar sb = (JScrollBar)pce.getOldValue();
        if (sb != null) {
            if (cl != null) {
                sb.getModel().removeChangeListener(cl);
            }
            if (pcl != null) {
                sb.removePropertyChangeListener(pcl);
            }
        }
        if ((sb = (JScrollBar)pce.getNewValue()) != null) {
            if (cl != null) {
                sb.getModel().addChangeListener(cl);
            }
            if (pcl != null) {
                sb.addPropertyChangeListener(pcl);
            }
        }
    }

    class Handler
    implements ChangeListener,
    PropertyChangeListener,
    MouseWheelListener {
        Handler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (QuaquaScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && e.getWheelRotation() != 0) {
                JScrollBar toScroll;
                int direction = e.getWheelRotation() < 0 ? -1 : 1;
                int orientation = (e.getModifiersEx() & 0x40) == 0 ? 1 : 0;
                JScrollBar jScrollBar = toScroll = orientation == 1 ? QuaquaScrollPaneUI.this.scrollpane.getVerticalScrollBar() : QuaquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                if (orientation == 1 && QuaquaScrollPaneUI.this.scrollpane.getVerticalScrollBarPolicy() == 21 || orientation == 0 && QuaquaScrollPaneUI.this.scrollpane.getHorizontalScrollBarPolicy() == 31) {
                    JScrollPane parentPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, QuaquaScrollPaneUI.this.scrollpane);
                    if (parentPane != null) {
                        parentPane.dispatchEvent(e);
                    }
                    return;
                }
                if (!(toScroll != null && toScroll.isVisible() || (toScroll = QuaquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) != null && toScroll.isVisible())) {
                    return;
                }
                if (e.getScrollType() == 0) {
                    JViewport vp = QuaquaScrollPaneUI.this.scrollpane.getViewport();
                    if (vp == null) {
                        return;
                    }
                    Component comp = vp.getView();
                    int units = Math.abs(e.getUnitsToScroll());
                    boolean limitScroll = Math.abs(e.getWheelRotation()) == 1;
                    Object fastWheelScroll = toScroll.getClientProperty("JScrollBar.fastWheelScrolling");
                    if (Boolean.TRUE == fastWheelScroll && comp instanceof Scrollable) {
                        Scrollable scrollComp = (Scrollable)((Object)comp);
                        Rectangle viewRect = vp.getViewRect();
                        int startingX = viewRect.x;
                        boolean leftToRight = comp.getComponentOrientation().isLeftToRight();
                        int scrollMin = toScroll.getMinimum();
                        int scrollMax = toScroll.getMaximum() - toScroll.getModel().getExtent();
                        if (limitScroll) {
                            int blockIncr = scrollComp.getScrollableBlockIncrement(viewRect, orientation, direction);
                            if (direction < 0) {
                                scrollMin = Math.max(scrollMin, toScroll.getValue() - blockIncr);
                            } else {
                                scrollMax = Math.min(scrollMax, toScroll.getValue() + blockIncr);
                            }
                        }
                        for (int i = 0; i < units; ++i) {
                            int unitIncr = scrollComp.getScrollableUnitIncrement(viewRect, orientation, direction);
                            if (orientation == 1) {
                                if (direction < 0) {
                                    viewRect.y -= unitIncr;
                                    if (viewRect.y > scrollMin) continue;
                                    viewRect.y = scrollMin;
                                    break;
                                }
                                viewRect.y += unitIncr;
                                if (viewRect.y < scrollMax) continue;
                                viewRect.y = scrollMax;
                                break;
                            }
                            if (leftToRight && direction < 0 || !leftToRight && direction > 0) {
                                viewRect.x -= unitIncr;
                                if (!leftToRight || viewRect.x >= scrollMin) continue;
                                viewRect.x = scrollMin;
                                break;
                            }
                            if (leftToRight && direction > 0 || !leftToRight && direction < 0) {
                                viewRect.x += unitIncr;
                                if (!leftToRight || viewRect.x <= scrollMax) continue;
                                viewRect.x = scrollMax;
                                break;
                            }
                            assert (false) : "Non-sensical ComponentOrientation / scroll direction";
                        }
                        if (orientation == 1) {
                            toScroll.setValue(viewRect.y);
                        } else if (leftToRight) {
                            toScroll.setValue(viewRect.x);
                        } else {
                            int newPos = toScroll.getValue() - (viewRect.x - startingX);
                            if (newPos < scrollMin) {
                                newPos = scrollMin;
                            } else if (newPos > scrollMax) {
                                newPos = scrollMax;
                            }
                            toScroll.setValue(newPos);
                        }
                    } else {
                        QuaquaScrollBarUI.scrollByUnits(toScroll, direction, units, limitScroll);
                    }
                } else if (e.getScrollType() == 1) {
                    QuaquaScrollBarUI.scrollByBlock(toScroll, direction);
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JViewport viewport = QuaquaScrollPaneUI.this.scrollpane.getViewport();
            if (viewport != null) {
                if (e.getSource() == viewport) {
                    this.viewportStateChanged(e);
                } else {
                    JScrollBar hsb = QuaquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    if (hsb != null && e.getSource() == hsb.getModel()) {
                        this.hsbStateChanged(viewport, e);
                    } else {
                        JScrollBar vsb = QuaquaScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                        if (vsb != null && e.getSource() == vsb.getModel()) {
                            this.vsbStateChanged(viewport, e);
                        }
                    }
                }
            }
        }

        private void vsbStateChanged(JViewport viewport, ChangeEvent e) {
            BoundedRangeModel model = (BoundedRangeModel)e.getSource();
            Point p = viewport.getViewPosition();
            p.y = model.getValue();
            viewport.setViewPosition(p);
        }

        private void hsbStateChanged(JViewport viewport, ChangeEvent e) {
            BoundedRangeModel model = (BoundedRangeModel)e.getSource();
            Point p = viewport.getViewPosition();
            int value = model.getValue();
            if (QuaquaScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight()) {
                p.x = value;
            } else {
                int max = viewport.getViewSize().width;
                int extent = viewport.getExtentSize().width;
                int oldX = p.x;
                p.x = max - extent - value;
                if (extent == 0 && value != 0 && oldX == max) {
                    QuaquaScrollPaneUI.this.setValueCalled = true;
                } else if (extent != 0 && oldX < 0 && p.x == 0) {
                    p.x += value;
                }
            }
            viewport.setViewPosition(p);
        }

        private void viewportStateChanged(ChangeEvent e) {
            QuaquaScrollPaneUI.this.syncScrollPaneWithViewport();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("Frame.active".equals(name)) {
                QuaquaUtilities.repaintBorder((JComponent)e.getSource());
            } else if ("JComponent.sizeVariant".equals(name)) {
                QuaquaUtilities.applySizeVariant(QuaquaScrollPaneUI.this.scrollpane);
            }
            if (e.getSource() == QuaquaScrollPaneUI.this.scrollpane) {
                this.scrollPanePropertyChange(e);
            } else {
                this.sbPropertyChange(e);
            }
        }

        private void scrollPanePropertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("verticalScrollBarDisplayPolicy".equals(propertyName)) {
                QuaquaScrollPaneUI.this.updateScrollBarDisplayPolicy(e);
            } else if ("horizontalScrollBarDisplayPolicy".equals(propertyName)) {
                QuaquaScrollPaneUI.this.updateScrollBarDisplayPolicy(e);
            } else if ("viewport".equals(propertyName)) {
                QuaquaScrollPaneUI.this.updateViewport(e);
            } else if ("rowHeader".equals(propertyName)) {
                QuaquaScrollPaneUI.this.updateRowHeader(e);
            } else if ("columnHeader".equals(propertyName)) {
                QuaquaScrollPaneUI.this.updateColumnHeader(e);
            } else if ("verticalScrollBar".equals(propertyName)) {
                QuaquaScrollPaneUI.this.updateVerticalScrollBar(e);
            } else if ("horizontalScrollBar".equals(propertyName)) {
                QuaquaScrollPaneUI.this.updateHorizontalScrollBar(e);
            } else if ("componentOrientation".equals(propertyName)) {
                QuaquaScrollPaneUI.this.scrollpane.revalidate();
                QuaquaScrollPaneUI.this.scrollpane.repaint();
            }
        }

        private void sbPropertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            Object source = e.getSource();
            if ("model".equals(propertyName)) {
                JScrollBar sb = QuaquaScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                BoundedRangeModel oldModel = (BoundedRangeModel)e.getOldValue();
                ChangeListener cl = null;
                if (source == sb) {
                    cl = QuaquaScrollPaneUI.this.vsbChangeListener;
                } else if (source == QuaquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                    sb = QuaquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    cl = QuaquaScrollPaneUI.this.hsbChangeListener;
                }
                if (cl != null) {
                    if (oldModel != null) {
                        oldModel.removeChangeListener(cl);
                    }
                    if (sb.getModel() != null) {
                        sb.getModel().addChangeListener(cl);
                    }
                }
            } else if ("componentOrientation".equals(propertyName) && source == QuaquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                JScrollBar hsb = QuaquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                JViewport viewport = QuaquaScrollPaneUI.this.scrollpane.getViewport();
                Point p = viewport.getViewPosition();
                p.x = QuaquaScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight() ? hsb.getValue() : viewport.getViewSize().width - viewport.getExtentSize().width - hsb.getValue();
                viewport.setViewPosition(p);
            }
        }
    }
}

