/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.colorchooser;

import ch.randelshofer.quaqua.colorchooser.ColorSliderModel;
import ch.randelshofer.quaqua.colorchooser.ColorSliderTextFieldHandler;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;

public class ColorSliderHexTextFieldHandler
extends ColorSliderTextFieldHandler {
    public ColorSliderHexTextFieldHandler(JTextField textField, ColorSliderModel ccModel, int component) {
        super(textField, ccModel, component);
    }

    @Override
    protected void docChanged() {
        if (this.textField.hasFocus()) {
            DefaultBoundedRangeModel brm = this.ccModel.getBoundedRangeModel(this.component);
            try {
                int value = Integer.decode("#" + this.textField.getText());
                if (brm.getMinimum() <= value && value <= brm.getMaximum()) {
                    brm.setValue(value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.textField.hasFocus()) {
            String str = Integer.toHexString(this.ccModel.getBoundedRangeModel(this.component).getValue()).toUpperCase();
            this.textField.setText(str.length() == 2 ? str : "0" + str);
        }
    }
}

