/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.lion;

import ch.randelshofer.quaqua.QuaquaUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class QuaquaLionScrollBarThumbBorder
implements Border,
UIResource {
    private static final Color activeThumbColor = new Color(0x74747474, false);
    private static final Color thumbColor = new Color(-1010580541, false);

    @Override
    public void paintBorder(Component c, Graphics gr, int x, int y, int width, int height) {
        Insets ins;
        JScrollBar sb = (JScrollBar)c;
        Graphics2D g = (Graphics2D)gr;
        Object oldHints = QuaquaUtilities.beginGraphics(g);
        Dimension ps = sb.getUI().getPreferredSize(sb);
        boolean isActive = sb.getValueIsAdjusting();
        QuaquaUtilities.SizeVariant sv = QuaquaUtilities.getSizeVariant(c);
        switch (sv) {
            default: {
                ins = UIManager.getInsets("ScrollBar.thumbInsets");
                break;
            }
            case SMALL: {
                ins = UIManager.getInsets("ScrollBar.thumbInsets.small");
                break;
            }
            case MINI: {
                ins = UIManager.getInsets("ScrollBar.thumbInsets.mini");
            }
        }
        g.setColor(isActive ? activeThumbColor : thumbColor);
        if (sb.getOrientation() == 0) {
            height = Math.min(ps.height, height);
            g.fillRoundRect(x + ins.top, y + ins.left, width - ins.top - ins.bottom, height - ins.left - ins.right, height - ins.left - ins.right, height - ins.left - ins.right);
        } else {
            width = Math.min(ps.width, width);
            g.fillRoundRect(x + ins.left, y + ins.top, width - ins.left - ins.right, height - ins.top - ins.bottom, width - ins.left - ins.right, width - ins.left - ins.right);
        }
        QuaquaUtilities.endGraphics(g, oldHints);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(2, 2, 2, 2);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

