/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.euclidean;

import java.awt.geom.Point2D;
import org.gvsig.euclidean.EuclideanLine2D;

public class EuclideanLine2DImpl
implements EuclideanLine2D {
    double coefA;
    double coefB;
    double coefC;
    double m;
    double b;

    public EuclideanLine2DImpl(double coefA, double coefB, double coefC) {
        this.coefA = coefA;
        this.coefB = coefB;
        this.coefC = coefC;
        this.reduceCoefs();
        this.m = -coefA / coefB;
        if (this.m == -0.0) {
            this.m = 0.0;
        }
        this.b = -coefC / coefB;
    }

    public EuclideanLine2DImpl(double m, double b) {
        this.m = m;
        this.b = b;
        this.coefA = m;
        this.coefB = -1.0;
        this.coefC = b;
        this.reduceCoefs();
    }

    public EuclideanLine2DImpl(double x0, double y0, double x1, double y1) {
        this(y1 - y0, -(x1 - x0), -(y1 - y0) * x0 + (x1 - x0) * y0);
    }

    public EuclideanLine2DImpl(Point2D p0, Point2D p1) {
        this(p0.getX(), p0.getY(), p1.getX(), p1.getY());
    }

    private void reduceCoefs() {
        if (this.coefA != 0.0 && Double.isFinite(this.coefA)) {
            this.coefC /= this.coefA;
            this.coefB /= this.coefA;
            this.coefA = 1.0;
        } else if (this.coefB != 0.0 && Double.isFinite(this.coefB)) {
            this.coefA /= this.coefB;
            this.coefC /= this.coefB;
            this.coefB = 1.0;
        }
    }

    public double getA() {
        return this.coefA;
    }

    public double getB() {
        return this.coefB;
    }

    public double getC() {
        return this.coefC;
    }

    public double getSlope() {
        return this.m;
    }

    public double getYIntercept() {
        return this.b;
    }

    public double getY(double x) {
        return (-this.coefA * x - this.coefC) / this.coefB;
    }

    public double getX(double y) {
        return (-this.coefB * y - this.coefC) / this.coefA;
    }

    public double getAngle() {
        return Math.atan(this.m);
    }

    public double getDegreesAngle() {
        return Math.toDegrees(this.getAngle());
    }

    public double getAngle(EuclideanLine2D line) {
        double m1 = line.getSlope();
        return Math.atan(Math.abs((m1 - this.m) / (1.0 + m1 * this.m)));
    }

    public double getAngle(EuclideanLine2D line, Point2D quadrant) {
        EuclideanLine2D[] bisectors = this.getBisectors(line);
        if (bisectors[0].getDistance(quadrant) <= bisectors[1].getDistance(quadrant)) {
            return 2.0 * this.getAngle(bisectors[0]);
        }
        return 2.0 * this.getAngle(bisectors[1]);
    }

    public double getDegreesAngle(EuclideanLine2D line) {
        return Math.toDegrees(this.getAngle(line));
    }

    public double getDegreesAngle(EuclideanLine2D line, Point2D quadrant) {
        return Math.toDegrees(this.getAngle(line, quadrant));
    }

    public double getDistance(double pointX, double pointY) {
        double den = Math.abs(Math.sqrt(Math.pow(this.coefA, 2.0) + Math.pow(this.coefB, 2.0)));
        return Math.abs(this.coefA * pointX + this.coefB * pointY + this.coefC) / den;
    }

    public double getDistance(Point2D point) {
        return this.getDistance(point.getX(), point.getY());
    }

    public double getDistance(EuclideanLine2D line) {
        if (this.isParallel(line)) {
            Double num = Math.abs(line.getC() - this.coefC);
            if (Double.isInfinite(this.m)) {
                return num;
            }
            Double den = Math.sqrt(Math.pow(this.coefA, 2.0) + Math.pow(this.coefB, 2.0));
            return num / den;
        }
        return 0.0;
    }

    public boolean isParallel(EuclideanLine2D line) {
        double m1 = line.getSlope();
        return this.m == m1 || Double.isInfinite(this.m) && Double.isInfinite(m1);
    }

    public boolean isPerpendicularl(EuclideanLine2D line) {
        double m1 = line.getSlope();
        return this.m * m1 == -1.0 || Double.isInfinite(this.m) && m1 == 0.0 || this.m == 0.0 && Double.isInfinite(m1);
    }

    public Point2D getIntersection(EuclideanLine2D line) {
        double a1 = this.coefA;
        double b1 = this.coefB;
        double c1 = this.coefC;
        Double a2 = line.getA();
        Double b2 = line.getB();
        Double c2 = line.getC();
        Double det = a1 * b2 - a2 * b1;
        Double detX = -c1 * b2 + c2 * b1;
        Double detY = -a1 * c2 + a2 * c1;
        Double x = detX / det;
        Double y = detY / det;
        return new Point2D.Double(x, y);
    }

    public EuclideanLine2D getPerpendicular(double pointX, double pointY) {
        if (Math.abs(this.m) == 0.0) {
            return new EuclideanLine2DImpl(1.0, 0.0, -pointX);
        }
        if (Double.isInfinite(this.m)) {
            return new EuclideanLine2DImpl(0.0, 1.0, -pointY);
        }
        Double m1 = -1.0 / this.m;
        Double b1 = pointY - m1 * pointX;
        return new EuclideanLine2DImpl(m1, b1);
    }

    public EuclideanLine2D getPerpendicular(Point2D point) {
        return this.getPerpendicular(point.getX(), point.getY());
    }

    public EuclideanLine2D getParallel(double pointX, double pointY) {
        if (Math.abs(this.m) == 0.0) {
            return new EuclideanLine2DImpl(0.0, 1.0, -pointY);
        }
        if (Double.isInfinite(this.m)) {
            return new EuclideanLine2DImpl(1.0, 0.0, -pointX);
        }
        Double m1 = this.m;
        Double b1 = pointY - m1 * pointX;
        return new EuclideanLine2DImpl(m1, b1);
    }

    public EuclideanLine2D getParallel(Point2D point) {
        return this.getParallel(point.getX(), point.getY());
    }

    public Point2D getNearestPoint(double pointX, double pointY) {
        double x;
        double y;
        if (Double.isInfinite(this.m)) {
            y = pointY;
            x = (-this.coefB * y - this.coefC) / this.coefA;
        } else if (Math.abs(this.m) == 0.0) {
            x = pointX;
            y = this.b;
        } else {
            EuclideanLine2D perp = this.getPerpendicular(pointX, pointY);
            Double m1 = perp.getSlope();
            Double b1 = perp.getYIntercept();
            x = (b1 - this.b) / (this.m - m1);
            y = this.m * x + this.b;
        }
        return new Point2D.Double(x, y);
    }

    public Point2D getNearestPoint(Point2D point) {
        return this.getNearestPoint(point.getX(), point.getY());
    }

    public EuclideanLine2D[] getBisectors(EuclideanLine2D line) {
        Double a1 = this.coefA;
        Double b1 = this.coefB;
        Double c1 = this.coefC;
        Double a2 = line.getA();
        Double b2 = line.getB();
        Double c2 = line.getC();
        Double den1 = Math.sqrt(Math.pow(a1, 2.0) + Math.pow(b1, 2.0));
        Double den2 = Math.sqrt(Math.pow(a2, 2.0) + Math.pow(b2, 2.0));
        EuclideanLine2D[] result = new EuclideanLine2DImpl[]{new EuclideanLine2DImpl(den2 * a1 - den1 * a2, den2 * b1 - den1 * b2, den2 * c1 - den1 * c2), new EuclideanLine2DImpl(den2 * a1 + den1 * a2, den2 * b1 + den1 * b2, den2 * c1 + den1 * c2)};
        return result;
    }

    public Point2D getSymmetricalPoint(Point2D point) {
        Point2D nearestPoint = this.getNearestPoint(point);
        Point2D.Double symmetricalPoint = new Point2D.Double(2.0 * nearestPoint.getX() - point.getX(), 2.0 * nearestPoint.getY() - point.getY());
        return symmetricalPoint;
    }
}

