/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.simplehttpserver;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ExceptionLogger;
import org.apache.http.impl.nio.bootstrap.HttpServer;
import org.apache.http.impl.nio.bootstrap.ServerBootstrap;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.gvsig.simplehttpserver.HttpHandler;
import org.gvsig.simplehttpserver.SimpleServer;
import org.gvsig.simplehttpserver.SimpleServerConfig;
import org.gvsig.simplehttpserver.commands.Command;
import org.gvsig.simplehttpserver.commands.CommandFactory;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleServerImpl
implements SimpleServer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleServerImpl.class);
    private static final List<HttpServer> SERVERS = new ArrayList<HttpServer>();
    private HttpServer server;
    private final Set<SimpleServer.LoggerListener> loglisteners;
    private Map<String, Command> commands;
    private final SimpleServerConfig config;
    private final PropertiesSupportHelper properties;

    public SimpleServerImpl(SimpleServerConfig config) {
        this.config = config;
        this.loglisteners = new HashSet<SimpleServer.LoggerListener>();
        this.properties = new PropertiesSupportHelper();
    }

    public Map<String, Command> getCommands() {
        if (this.commands == null) {
            LinkedHashMap<String, Command> theCommands = new LinkedHashMap<String, Command>();
            for (CommandFactory factory : this.config.getCommandFactories()) {
                theCommands.put(factory.getName(), factory.create((SimpleServer)this));
            }
            this.commands = theCommands;
        }
        return this.commands;
    }

    public Command getCommand(String commandName) {
        if (commandName == null) {
            return null;
        }
        Command command = this.getCommands().get(commandName.toLowerCase());
        return command;
    }

    public Command getCommand(List<String> args) {
        try {
            String commandName = args.get(0);
            if (commandName == null) {
                return null;
            }
            Command command = this.getCommands().get(commandName.toLowerCase());
            if (command != null) {
                return command;
            }
            String s = StringUtils.join(args, (String)"/");
            ArrayList<Command> cmds = new ArrayList<Command>(this.getCommands().values());
            Collections.sort(cmds, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
            for (Command cmd : cmds) {
                if (!StringUtils.startsWith((CharSequence)s, (CharSequence)cmd.getName())) continue;
                args.set(0, cmd.getName());
                for (int n = StringUtils.split((String)cmd.getName(), (char)'/').length; n > 1; --n) {
                    args.remove(1);
                }
                return cmd;
            }
            return null;
        }
        catch (Exception ex) {
            this.log(1, "Can't locate command from args");
            return null;
        }
    }

    public SimpleServerConfig getConfig() {
        return this.config;
    }

    public void addLogListener(SimpleServer.LoggerListener logger) {
        this.loglisteners.add(logger);
    }

    public void removeLogListener(SimpleServer.LoggerListener logger) {
        this.loglisteners.remove(logger);
    }

    public URL getURL(String path) {
        try {
            URL url = StringUtils.isBlank((CharSequence)path) ? new URL("http", "127.0.0.1", this.config.getPort(), "/") : new URL("http", "127.0.0.1", this.config.getPort(), path);
            return url;
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public String getHost() {
        String host = "http://127.0.0.1:" + this.config.getPort();
        return host;
    }

    public void log(int level, String message) {
        switch (level) {
            default: {
                LOG.info(message);
                break;
            }
            case 1: {
                LOG.warn(message);
                break;
            }
            case 2: {
                LOG.debug(message);
            }
        }
        for (SimpleServer.LoggerListener logger : this.loglisteners) {
            logger.log(level, message);
        }
    }

    public synchronized void start() {
        if (this.server != null) {
            this.stop();
        }
        IOReactorConfig theConfig = IOReactorConfig.custom().setSoTimeout(this.config.getTimeout()).setTcpNoDelay(true).build();
        this.server = ServerBootstrap.bootstrap().setListenerPort(this.config.getPort()).setServerInfo(this.config.getServerInfo()).setIOReactorConfig(theConfig).setExceptionLogger(ExceptionLogger.STD_ERR).registerHandler("*", (HttpAsyncRequestHandler)new HttpHandler(this)).create();
        try {
            this.server.start();
            SERVERS.add(this.server);
            this.log(0, "Server started.");
        }
        catch (Exception ex) {
            this.log(1, "Can't start server (" + ex.getMessage() + ").");
        }
    }

    public void reload() {
    }

    public synchronized boolean isStarted() {
        return this.server != null;
    }

    public synchronized void stop() {
        if (this.server == null) {
            this.log(0, "Server already stoped.");
            return;
        }
        this.server.shutdown(5L, TimeUnit.SECONDS);
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SERVERS.remove(this.server);
        this.server = null;
        this.log(0, "Server stoped.");
    }

    public Object getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.properties.getProperties();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (HttpServer server : SERVERS) {
                    server.shutdown(5L, TimeUnit.SECONDS);
                }
            }
        });
    }
}

