/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.awt.event.specificCaretPosition;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.gvsig.gui.awt.event.specificCaretPosition.ISpecificCaretPosition;

public class SpecificCaretPositionListeners {
    public static void setListeners(final JTextComponent component) {
        component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                switch (((ISpecificCaretPosition)((Object)component)).getCaretPositionMode()) {
                    case 1: {
                        component.setCaretPosition(0);
                        break;
                    }
                    case 2: {
                        component.setCaretPosition(component.getDocument().getLength());
                        break;
                    }
                }
            }
        });
        component.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!component.isFocusOwner()) {
                    switch (((ISpecificCaretPosition)((Object)component)).getCaretPositionMode()) {
                        case 1: {
                            component.setCaretPosition(0);
                            break;
                        }
                        case 2: {
                            component.setCaretPosition(component.getDocument().getLength());
                            break;
                        }
                    }
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!component.isFocusOwner()) {
                    switch (((ISpecificCaretPosition)((Object)component)).getCaretPositionMode()) {
                        case 1: {
                            component.setCaretPosition(0);
                            break;
                        }
                        case 2: {
                            component.setCaretPosition(component.getDocument().getLength());
                            break;
                        }
                    }
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!component.isFocusOwner()) {
                    switch (((ISpecificCaretPosition)((Object)component)).getCaretPositionMode()) {
                        case 1: {
                            component.setCaretPosition(0);
                            break;
                        }
                        case 2: {
                            component.setCaretPosition(component.getDocument().getLength());
                            break;
                        }
                    }
                }
            }
        });
        component.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (!component.isFocusOwner()) {
                    switch (((ISpecificCaretPosition)((Object)component)).getCaretPositionMode()) {
                        case 1: {
                            if (component.getCaretPosition() == 0) break;
                            component.setCaretPosition(0);
                            break;
                        }
                        case 2: {
                            if (component.getCaretPosition() == component.getDocument().getLength()) break;
                            component.setCaretPosition(component.getDocument().getLength());
                            break;
                        }
                    }
                }
            }
        });
    }
}

