/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.buttonspanel;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;

public class ButtonsPanel
extends JPanel {
    private static final long serialVersionUID = -1660559792086305063L;
    private ArrayList<ButtonsPanelListener> actionCommandListeners = new ArrayList();
    private ArrayList<JButton> buttonsList = new ArrayList();
    private static int eventId = Integer.MIN_VALUE;
    public static final int BUTTON_ACCEPT = 1;
    public static final int BUTTON_CANCEL = 2;
    public static final int BUTTON_APPLY = 3;
    public static final int BUTTON_YES = 4;
    public static final int BUTTON_NO = 5;
    public static final int BUTTON_CLOSE = 6;
    public static final int BUTTON_EXIT = 7;
    public static final int BUTTON_SEEDETAILS = 8;
    public static final int BUTTON_HIDEDETAILS = 9;
    public static final int BUTTON_PAUSE = 10;
    public static final int BUTTON_RESTART = 11;
    public static final int BUTTON_SAVE = 12;
    public static final int BUTTON_LAST = 12;
    public static final int BUTTONS_ACCEPT = 1;
    public static final int BUTTONS_ACCEPTCANCEL = 2;
    public static final int BUTTONS_ACCEPTCANCELAPPLY = 3;
    public static final int BUTTONS_CANCEL = 4;
    public static final int BUTTONS_YESNO = 5;
    public static final int BUTTONS_CLOSE = 6;
    public static final int BUTTONS_EXIT = 7;
    public static final int BUTTONS_NONE = 8;
    public static final int BUTTONS_APPLYCLOSE = 9;

    public ButtonsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new FlowLayout(2, 2, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
    }

    public ButtonsPanel(int items) {
        this.initialize();
        switch (items) {
            case 1: {
                this.addAccept();
                break;
            }
            case 2: {
                this.addAccept();
                this.addCancel();
                break;
            }
            case 3: {
                this.addApply();
                this.addAccept();
                this.addCancel();
                break;
            }
            case 9: {
                this.addApply();
                this.addClose();
                break;
            }
            case 4: {
                this.addCancel();
                break;
            }
            case 5: {
                this.addYes();
                this.addNo();
                break;
            }
            case 6: {
                this.addClose();
                break;
            }
            case 7: {
                this.addExit();
                break;
            }
        }
    }

    public void addButtonPressedListener(ButtonsPanelListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public Object[] getButtonPressedListeners() {
        return this.actionCommandListeners.toArray();
    }

    public void removeButtonPressedListener(ButtonsPanelListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    private void callActionCommandListeners(int buttonID) {
        for (ButtonsPanelListener listener : this.actionCommandListeners) {
            listener.actionButtonPressed(new ButtonsPanelEvent(this, buttonID));
        }
        ++eventId;
    }

    public void addAccept() {
        this.addButton(Messages.getText("aceptar"), 1);
    }

    public void addSave() {
        this.addButton(Messages.getText("guardar"), 12);
    }

    public void addCancel() {
        this.addButton(Messages.getText("cancelar"), 2);
    }

    public void addYes() {
        this.addButton(Messages.getText("si"), 4);
    }

    public void addNo() {
        this.addButton(Messages.getText("no"), 5);
    }

    public void addApply() {
        this.addButton(Messages.getText("aplicar"), 3);
    }

    public void addClose() {
        this.addButton(Messages.getText("cerrar"), 6);
    }

    public void addExit() {
        this.addButton(Messages.getText("salir"), 7);
    }

    public void addSeeDetails() {
        this.addButton(Messages.getText("verdetalles"), 8);
    }

    public void addHideDetails() {
        this.addButton(Messages.getText("ocultardetalles"), 9);
    }

    public void addPause() {
        this.addButton(Messages.getText("pausar"), 10);
    }

    public void addRestart() {
        this.addButton(Messages.getText("reanudar"), 11);
    }

    public void addButton(String text, int id) {
        JButton button = new JButton();
        button.setText(text);
        this.buttonsList.add(button);
        button.setActionCommand(id + "");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonsPanel.this.callActionCommandListeners(Integer.parseInt(e.getActionCommand()));
            }
        });
        this.add(button);
    }

    public JButton getButton(int id) {
        for (JButton button : this.buttonsList) {
            if (Integer.parseInt(button.getActionCommand()) != id) continue;
            return button;
        }
        return null;
    }

    public boolean removeButton(int id) {
        String b_text = this.getButtonText(id);
        for (JButton button : this.buttonsList) {
            if (button.getText().compareTo(b_text) != 0) continue;
            this.buttonsList.remove(button);
            return true;
        }
        return false;
    }

    protected String getButtonText(int id) {
        switch (id) {
            case 1: {
                return Messages.getText("aceptar");
            }
            case 2: {
                return Messages.getText("cancelar");
            }
            case 3: {
                return Messages.getText("aplicar");
            }
            case 4: {
                return Messages.getText("si");
            }
            case 5: {
                return Messages.getText("no");
            }
            case 6: {
                return Messages.getText("cerrar");
            }
            case 7: {
                return Messages.getText("salir");
            }
            case 8: {
                return Messages.getText("verdetalles");
            }
            case 9: {
                return Messages.getText("ocultardetalles");
            }
            case 10: {
                return Messages.getText("pausar");
            }
            case 11: {
                return Messages.getText("reanudar");
            }
            case 12: {
                return Messages.getText("guardar");
            }
        }
        return null;
    }

    public boolean setEnabled(int id, boolean b) {
        String b_text = this.getButtonText(id);
        for (JButton button : this.buttonsList) {
            if (button.getText().compareTo(b_text) != 0) continue;
            button.setEnabled(b);
            return true;
        }
        return false;
    }
}

