/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.filterPanel.filterButtons;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.controls.MultiLineToolTip;
import org.gvsig.gui.beans.swing.textBoxWithCalendar.JCalendarDateDialog;

public class FilterButtonsJPanel
extends JPanel
implements Serializable {
    private static final long serialVersionUID = -6976915487897365666L;
    public static final int default_FilterButtonsJPanelWidth = 190;
    public static final int default_FilterButtonsJPanelHeight = 104;
    private final int buttonsGroupJPanelWidth = 190;
    private final int buttonsGroupJPanelHeight = 104;
    private final int buttonHeight = 20;
    private final int buttonWidthUnit = 40;
    private JButtonML btnEqual = null;
    private JButtonML btnDistinct = null;
    private JButtonML btnGreater = null;
    private JButtonML btnSmaller = null;
    private JButtonML btnEqualGreater = null;
    private JButtonML btnEqualSmaller = null;
    private JButtonML btnAnd = null;
    private JButtonML btnOr = null;
    private JButtonML btnNot = null;
    private JButtonML btnDate = null;
    private JButtonML btnParenthesis = null;
    private JButtonML btnDeleteText = null;
    private JPanelML buttonsJPanel = null;
    private DateFormat dateFormat = DateFormat.getDateInstance();
    private Date lastSelectedDate = null;
    private JCalendarDateDialog jCalendarDateDialog = null;
    public static final int DEFAULT = 0;
    public static final int EQUAL = 1;
    public static final int DISTINCT = 2;
    public static final int GREATER = 3;
    public static final int SMALLER = 4;
    public static final int EQUALGREATER = 5;
    public static final int EQUALSMALLER = 6;
    public static final int AND = 7;
    public static final int OR = 8;
    public static final int NOT = 9;
    public static final int DATE = 10;
    public static final int PARENTHESIS = 11;
    public static final int DELETE_TEXT = 12;
    public static final int BUTTON_CLICKED_ACTION_ID = 13;
    public static final String BUTTON_CLICKED_ACTION_COMMAND = "Button Clicked";
    private HashMap<String, String> map;
    private ActionListener actionListener = null;

    public FilterButtonsJPanel() {
        this.initialize();
    }

    public FilterButtonsJPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initialize();
    }

    public FilterButtonsJPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initialize();
    }

    public FilterButtonsJPanel(LayoutManager layout) {
        super(layout);
        this.initialize();
    }

    private void initialize() {
        this.map = new HashMap();
        this.setPreferredSize(new Dimension(190, 104));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.getButtonsJPanel(), gridBagConstraints);
    }

    private JPanel getButtonsJPanel() {
        if (this.buttonsJPanel == null) {
            this.buttonsJPanel = new JPanelML();
            this.buttonsJPanel.setPreferredSize(new Dimension(190, 104));
            this.buttonsJPanel.add(this.getBtnEqual());
            this.buttonsJPanel.add(this.getBtnDistinct());
            this.buttonsJPanel.add(this.getBtnDate());
            this.buttonsJPanel.add(this.getBtnSmaller());
            this.buttonsJPanel.add(this.getBtnGreater());
            this.buttonsJPanel.add(this.getBtnEqualSmaller());
            this.buttonsJPanel.add(this.getBtnEqualGreater());
            this.buttonsJPanel.add(this.getBtnAnd());
            this.buttonsJPanel.add(this.getBtnOr());
            this.buttonsJPanel.add(this.getBtnNot());
            this.buttonsJPanel.add(this.getBtnParenthesis());
            this.buttonsJPanel.add(this.getBtnDeleteText());
        }
        return this.buttonsJPanel;
    }

    private JButton getBtnDistinct() {
        if (this.btnDistinct == null) {
            this.btnDistinct = new JButtonML();
            this.btnDistinct.setText("!=");
            this.btnDistinct.setMargin(new Insets(2, 2, 2, 2));
            this.btnDistinct.setPreferredSize(new Dimension(40, 20));
            this.btnDistinct.setToolTipText(Messages.getText("operator_distinct_explanation"));
            this.map.put("!=", Integer.toString(2));
            this.btnDistinct.addActionListener(this.getActionListener());
        }
        return this.btnDistinct;
    }

    private JButton getBtnEqual() {
        if (this.btnEqual == null) {
            this.btnEqual = new JButtonML();
            this.btnEqual.setText("=");
            this.btnEqual.setMargin(new Insets(2, 2, 2, 2));
            this.btnEqual.setPreferredSize(new Dimension(40, 20));
            this.btnEqual.setToolTipText(Messages.getText("operator_equal_explanation"));
            this.map.put("=", Integer.toString(1));
            this.btnEqual.addActionListener(this.getActionListener());
        }
        return this.btnEqual;
    }

    private JButton getBtnGreater() {
        if (this.btnGreater == null) {
            this.btnGreater = new JButtonML();
            this.btnGreater.setText(">");
            this.btnGreater.setMargin(new Insets(2, 2, 2, 2));
            this.btnGreater.setPreferredSize(new Dimension(40, 20));
            this.btnGreater.setToolTipText(Messages.getText("operator_greater_explanation"));
            this.map.put(">", Integer.toString(3));
            this.btnGreater.addActionListener(this.getActionListener());
        }
        return this.btnGreater;
    }

    private JButton getBtnEqualGreater() {
        if (this.btnEqualGreater == null) {
            this.btnEqualGreater = new JButtonML();
            this.btnEqualGreater.setText(">=");
            this.btnEqualGreater.setMargin(new Insets(2, 2, 2, 2));
            this.btnEqualGreater.setPreferredSize(new Dimension(40, 20));
            this.btnEqualGreater.setToolTipText(Messages.getText("operator_equal_greater_explanation"));
            this.map.put(">=", Integer.toString(5));
            this.btnEqualGreater.addActionListener(this.getActionListener());
        }
        return this.btnEqualGreater;
    }

    private JButton getBtnSmaller() {
        if (this.btnSmaller == null) {
            this.btnSmaller = new JButtonML();
            this.btnSmaller.setText("<");
            this.btnSmaller.setMargin(new Insets(2, 2, 2, 2));
            this.btnSmaller.setPreferredSize(new Dimension(40, 20));
            this.btnSmaller.setToolTipText(Messages.getText("operator_smaller_explanation"));
            this.map.put("<", Integer.toString(4));
            this.btnSmaller.addActionListener(this.getActionListener());
        }
        return this.btnSmaller;
    }

    private JButton getBtnEqualSmaller() {
        if (this.btnEqualSmaller == null) {
            this.btnEqualSmaller = new JButtonML();
            this.btnEqualSmaller.setText("<=");
            this.btnEqualSmaller.setMargin(new Insets(2, 2, 2, 2));
            this.btnEqualSmaller.setPreferredSize(new Dimension(40, 20));
            this.btnEqualSmaller.setToolTipText(Messages.getText("operator_equal_smaller_explanation"));
            this.map.put("<=", Integer.toString(6));
            this.btnEqualSmaller.addActionListener(this.getActionListener());
        }
        return this.btnEqualSmaller;
    }

    private JButton getBtnDate() {
        if (this.btnDate == null) {
            this.btnDate = new JButtonML();
            this.btnDate.setText("Date");
            this.btnDate.setMargin(new Insets(2, 2, 2, 2));
            this.btnDate.setPreferredSize(new Dimension(86, 20));
            this.btnDate.setToolTipText(Messages.getText("date_button_explanation"));
            this.map.put("Date", Integer.toString(10));
            this.btnDate.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    FilterButtonsJPanel.this.getCDD().setVisible(true);
                }
            });
        }
        return this.btnDate;
    }

    protected JCalendarDateDialog getCDD() {
        if (this.jCalendarDateDialog == null) {
            this.jCalendarDateDialog = new JCalendarDateDialog(350, 230);
            this.jCalendarDateDialog.setModal(true);
            this.jCalendarDateDialog.setLocationRelativeTo(this.btnDate);
            this.jCalendarDateDialog.setMinimumWidth(350);
            this.jCalendarDateDialog.setMinimumHeight(170);
            this.jCalendarDateDialog.setMaximumWidth(500);
            this.jCalendarDateDialog.setMaximumHeight(400);
            this.jCalendarDateDialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    FilterButtonsJPanel.this.lastSelectedDate = FilterButtonsJPanel.this.jCalendarDateDialog.getDate();
                    FilterButtonsJPanel.this.actionListener.actionPerformed(new ActionEvent(FilterButtonsJPanel.this.btnDate, 13, FilterButtonsJPanel.BUTTON_CLICKED_ACTION_COMMAND));
                }
            });
        }
        return this.jCalendarDateDialog;
    }

    private JButton getBtnAnd() {
        if (this.btnAnd == null) {
            this.btnAnd = new JButtonML();
            this.btnAnd.setText("And");
            this.btnAnd.setMargin(new Insets(2, 2, 2, 2));
            this.btnAnd.setPreferredSize(new Dimension(40, 20));
            this.btnAnd.setToolTipText(Messages.getText("operator_and_explanation"));
            this.map.put("And", Integer.toString(7));
            this.btnAnd.addActionListener(this.getActionListener());
        }
        return this.btnAnd;
    }

    private JButton getBtnNot() {
        if (this.btnNot == null) {
            this.btnNot = new JButtonML();
            this.btnNot.setText("Not");
            this.btnNot.setMargin(new Insets(2, 2, 2, 2));
            this.btnNot.setPreferredSize(new Dimension(40, 20));
            this.btnNot.setToolTipText(Messages.getText("operator_not_explanation"));
            this.map.put("Not", Integer.toString(9));
            this.btnNot.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    new ActionEvent(this, 13, FilterButtonsJPanel.BUTTON_CLICKED_ACTION_COMMAND);
                }
            });
            this.btnNot.addActionListener(this.getActionListener());
        }
        return this.btnNot;
    }

    private JButton getBtnOr() {
        if (this.btnOr == null) {
            this.btnOr = new JButtonML();
            this.btnOr.setText("Or");
            this.btnOr.setMargin(new Insets(2, 2, 2, 2));
            this.btnOr.setPreferredSize(new Dimension(40, 20));
            this.btnOr.setToolTipText(Messages.getText("operator_or_explanation"));
            this.map.put("Or", Integer.toString(8));
            this.btnOr.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    new ActionEvent(this, 13, FilterButtonsJPanel.BUTTON_CLICKED_ACTION_COMMAND);
                }
            });
            this.btnOr.addActionListener(this.getActionListener());
        }
        return this.btnOr;
    }

    private JButton getBtnParenthesis() {
        if (this.btnParenthesis == null) {
            this.btnParenthesis = new JButtonML();
            this.btnParenthesis.setText("()");
            this.btnParenthesis.setMargin(new Insets(2, 2, 2, 2));
            this.btnParenthesis.setPreferredSize(new Dimension(40, 20));
            this.btnParenthesis.setToolTipText(Messages.getText("parenthesis_explanation"));
            this.map.put("()", Integer.toString(11));
            this.btnParenthesis.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    new ActionEvent(this, 13, FilterButtonsJPanel.BUTTON_CLICKED_ACTION_COMMAND);
                }
            });
            this.btnParenthesis.addActionListener(this.getActionListener());
        }
        return this.btnParenthesis;
    }

    private JButton getBtnDeleteText() {
        if (this.btnDeleteText == null) {
            this.btnDeleteText = new JButtonML();
            this.btnDeleteText.setText(Messages.getText("deleteText"));
            this.btnDeleteText.setMargin(new Insets(2, 2, 2, 2));
            this.btnDeleteText.setPreferredSize(new Dimension(176, 20));
            this.btnDeleteText.setToolTipText(Messages.getText("deleteText_on_filter_use_explanation"));
            this.map.put(Messages.getText("deleteText"), Integer.toString(12));
            this.btnDeleteText.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    new ActionEvent(this, 13, FilterButtonsJPanel.BUTTON_CLICKED_ACTION_COMMAND);
                }
            });
            this.btnDeleteText.addActionListener(this.getActionListener());
        }
        return this.btnDeleteText;
    }

    private ActionListener getActionListener() {
        if (this.actionListener == null) {
            this.actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    FilterButtonsJPanel.this.firePropertyChange(FilterButtonsJPanel.BUTTON_CLICKED_ACTION_COMMAND, 0, FilterButtonsJPanel.this.map.get(((JButton)event.getSource()).getText()));
                }
            };
        }
        return this.actionListener;
    }

    public String getLastSelectedDate() {
        if (this.lastSelectedDate == null) {
            return "";
        }
        return "Date(" + this.dateFormat.format(this.lastSelectedDate) + ")";
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    protected class JPanelML
    extends JPanel {
        private static final long serialVersionUID = -5282313934096892711L;

        public JPanelML() {
        }

        public JPanelML(boolean isDoubleBuffered) {
            super(isDoubleBuffered);
        }

        public JPanelML(LayoutManager layout, boolean isDoubleBuffered) {
            super(layout, isDoubleBuffered);
        }

        public JPanelML(LayoutManager layout) {
            super(layout);
        }

        @Override
        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent(this);
            return tip;
        }
    }

    protected class JButtonML
    extends JButton {
        private static final long serialVersionUID = -6052122756677251026L;

        public JButtonML() {
        }

        public JButtonML(Action a) {
            super(a);
        }

        public JButtonML(Icon icon) {
            super(icon);
        }

        public JButtonML(String text, Icon icon) {
            super(text, icon);
        }

        public JButtonML(String text) {
            super(text);
        }

        @Override
        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent(this);
            return tip;
        }
    }
}

