/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.panelGroup.panels;

import java.awt.Dimension;
import javax.swing.JPanel;
import org.gvsig.gui.beans.panelGroup.AbstractPanelGroup;
import org.gvsig.gui.beans.panelGroup.panels.IPanel;

public abstract class AbstractPanel
extends JPanel
implements IPanel {
    protected boolean remainsWithDefaultPreferredSize;
    private String id;
    private String label;
    private String labelGroup;
    private Object reference;
    private AbstractPanelGroup panelGroup;
    protected boolean hasChanged;
    private boolean alwaysApplicable;
    private int priority = 0;

    public AbstractPanel() {
        this.id = null;
        this.label = null;
        this.labelGroup = null;
        this.remainsWithDefaultPreferredSize = true;
        this.hasChanged = false;
        this.alwaysApplicable = true;
        this.priority = 0;
    }

    public AbstractPanel(String id, String label, String labelGroup) {
        this.id = id;
        this.label = label;
        this.labelGroup = labelGroup;
        this.remainsWithDefaultPreferredSize = true;
        this.hasChanged = false;
        this.alwaysApplicable = true;
        this.priority = 0;
    }

    protected abstract void initialize();

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getLabelGroup() {
        return this.labelGroup;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setLabelGroup(String labelGroup) {
        this.labelGroup = labelGroup;
    }

    @Override
    public Object getReference() {
        return this.reference;
    }

    @Override
    public void setReference(Object ref) {
        this.reference = ref;
    }

    @Override
    public AbstractPanelGroup getPanelGroup() {
        return this.panelGroup;
    }

    @Override
    public void setPanelGroup(AbstractPanelGroup panelGroup) {
        this.panelGroup = panelGroup;
    }

    @Override
    public synchronized void setInGroupGUI(boolean visible) {
        if (this.panelGroup != null) {
            this.panelGroup.setPanelInGUI(this, visible);
        }
    }

    @Override
    public synchronized boolean isInGroupGUI() {
        if (this.panelGroup == null) {
            return false;
        }
        return this.panelGroup.isPanelInGUI(this);
    }

    @Override
    public String toString() {
        return this.label == null ? "" : this.label;
    }

    @Override
    public boolean remainsWithItsDefaultPreferredSize() {
        return this.remainsWithDefaultPreferredSize;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        this.remainsWithDefaultPreferredSize = false;
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void resetChangedStatus() {
        this.hasChanged = false;
    }

    @Override
    public void setAlwaysApplicable(boolean b) {
        this.alwaysApplicable = b;
    }

    @Override
    public boolean isAlwaysApplicable() {
        return this.alwaysApplicable;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(IPanel comparedPanel) {
        int comparedPriority = comparedPanel.getPriority();
        return comparedPriority - this.priority;
    }
}

