/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.slidertext;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.gui.beans.doubleslider.DoubleSlider;
import org.gvsig.gui.beans.doubleslider.DoubleSliderEvent;
import org.gvsig.gui.beans.doubleslider.DoubleSliderListener;

public class ColorSliderTextContainer
extends JPanel
implements ChangeListener,
DoubleSliderListener {
    private static final long serialVersionUID = 1876415954410511634L;
    private ArrayList<DoubleSliderListener> actionCommandListeners = new ArrayList();
    private JPanel pText = null;
    private DoubleSlider slider = null;
    private JSpinner jSpinner = null;
    private int min = 0;
    private int max = 255;
    private int defaultPos = 0;
    boolean spinnerEvent = true;
    int lastDragged = -1;

    public ColorSliderTextContainer(int min, int max, int defaultPos) {
        this.min = min;
        this.max = max;
        this.defaultPos = defaultPos;
        this.initialize();
        this.slider.setTwoSliders(false);
    }

    public ColorSliderTextContainer() {
        this(0, 100, 0);
    }

    private void initialize() {
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.getSlider(), "Center");
        this.add((Component)this.getPText(), "East");
    }

    private JPanel getPText() {
        if (this.pText == null) {
            this.pText = new JPanel();
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 10, 8, 0);
            this.pText.setLayout(new GridBagLayout());
            this.pText.add((Component)this.getJSpinner(), gridBagConstraints1);
        }
        return this.pText;
    }

    public DoubleSlider getSlider() {
        if (this.slider == null) {
            this.slider = new DoubleSlider();
            this.slider.setMinimum(this.min);
            this.slider.setMaximum(this.max);
            this.slider.setValue(this.defaultPos);
            this.slider.addValueChangedListener(this);
        }
        return this.slider;
    }

    public JSpinner getJSpinner() {
        if (this.jSpinner == null) {
            this.jSpinner = new JSpinner();
            this.jSpinner.setValue(this.defaultPos);
            this.jSpinner.setPreferredSize(new Dimension(50, 26));
            this.jSpinner.setMinimumSize(new Dimension(50, 26));
            this.jSpinner.addChangeListener(this);
        }
        return this.jSpinner;
    }

    public void setComponentSize(int w, int h) {
    }

    public int getValue() {
        return Integer.parseInt(this.getJSpinner().getValue() + "");
    }

    public void setValue(int value) {
        this.getJSpinner().setValue(value);
        this.getSlider().setValue(value);
    }

    public void setControlEnabled(boolean active) {
        this.getSlider().setEnabled(active);
        this.getJSpinner().setEnabled(active);
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.setMaximum(max);
    }

    public void setMaximum(int max) {
        this.max = max;
        this.updateInterval();
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.setMinimum(min);
    }

    public void setMinimum(int min) {
        this.min = min;
        this.updateInterval();
    }

    private void updateInterval() {
        int aux = this.getValue();
        this.getSlider().setMinimum(this.min);
        this.getSlider().setMaximum(this.max);
        this.setValue(aux);
    }

    public void setColor1(Color color, boolean refresh) {
        this.slider.setColor1(color, refresh);
    }

    public void setColor2(Color color, boolean refresh) {
        this.slider.setColor2(color, refresh);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value = Integer.parseInt(this.getJSpinner().getValue().toString());
        if (value != this.getSlider().getValue()) {
            this.getSlider().setValue(value);
        }
        if (Integer.parseInt(this.getJSpinner().getValue().toString()) != this.getSlider().getValue()) {
            this.getJSpinner().setValue(this.getSlider().getValue());
        }
        if (this.spinnerEvent) {
            this.callChangeValue();
        }
    }

    protected void callChangeValue() {
        for (DoubleSliderListener listener : this.actionCommandListeners) {
            listener.actionValueChanged(new DoubleSliderEvent(this));
        }
    }

    protected void callDraggedValue() {
        for (DoubleSliderListener listener : this.actionCommandListeners) {
            listener.actionValueDragged(new DoubleSliderEvent(this));
        }
    }

    public void addValueChangedListener(DoubleSliderListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeValueChangedListener(DoubleSliderListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.jSpinner.setEnabled(enabled);
        this.slider.setEnabled(enabled);
    }

    @Override
    public void actionValueChanged(DoubleSliderEvent e) {
        int value = this.getSlider().getValue();
        this.getJSpinner().setValue(value);
        if (this.isEnabled()) {
            this.callChangeValue();
        }
    }

    @Override
    public void actionValueDragged(DoubleSliderEvent e) {
        int value = this.getSlider().getValue();
        if (this.lastDragged != value) {
            this.lastDragged = value;
            this.spinnerEvent = false;
            this.getJSpinner().setValue(value);
            this.spinnerEvent = true;
            if (this.isEnabled()) {
                this.callDraggedValue();
            }
        }
    }
}

