/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.swing.cellrenderers;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.jfree.layout.CenterLayout;

public class BooleanTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 2121615214282741840L;
    private JCheckBox chk;
    private boolean isBordered;
    private MatteBorder selectedBorder;
    private MatteBorder unselectedBorder;

    public BooleanTableCellRenderer(boolean bordered) {
        this.isBordered = bordered;
        this.setOpaque(true);
    }

    public JCheckBox getCheck() {
        return this.chk;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (this.isBordered) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        try {
            Boolean v = (Boolean)value;
            JPanel content = new JPanel((LayoutManager)new CenterLayout());
            content.setBackground(table.getBackground());
            this.chk = new JCheckBox("", (boolean)v);
            this.chk.setBackground(table.getBackground());
            content.add((Component)this.chk, "Center");
            return content;
        }
        catch (ClassCastException ccEx) {
            throw new RuntimeException("Trying to use a Boolean cell renderer with a non-Boolean datatype");
        }
    }
}

