/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.table.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.gui.beans.table.MoveRowsPanel;
import org.gvsig.gui.beans.table.Table;
import org.gvsig.gui.beans.table.TableContainer;
import org.gvsig.gui.beans.table.TableControlerPanel;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.gui.beans.table.models.IModel;

public class TableListener
implements ActionListener,
ListSelectionListener {
    public static boolean comboEventEnable = true;
    private TableContainer tableContainer = null;
    private TableControlerPanel controlPanel = null;
    private MoveRowsPanel moveRowsPanel = null;
    private Table table = null;
    public boolean enableNewLineListener = true;

    public TableListener(TableContainer tableContainer) {
        this.tableContainer = tableContainer;
    }

    private void initialize() {
        this.controlPanel = this.tableContainer.getPTableControl();
        this.moveRowsPanel = this.tableContainer.getMoveRowsPanel();
        this.table = this.tableContainer.getTable();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.controlPanel == null || this.table == null) {
            this.initialize();
        }
        try {
            int i;
            int[] lista;
            if (this.enableNewLineListener && e.getSource() == this.controlPanel.getBNew() && this.table.getTableModel() instanceof IModel) {
                this.tableContainer.addRow(((IModel)((Object)this.table.getTableModel())).getNewLine());
            }
            if (this.enableNewLineListener && e.getSource() == this.controlPanel.getBClear()) {
                this.tableContainer.removeAllRows();
            }
            if (this.enableNewLineListener && e.getSource() == this.controlPanel.getBDelPoint()) {
                lista = this.tableContainer.getSelectedRows();
                for (i = lista.length - 1; i >= 0; --i) {
                    this.tableContainer.delRow(lista[i]);
                }
            }
            if (e.getSource() == this.moveRowsPanel.getBUp() && (lista = this.tableContainer.getSelectedRows()).length > 0) {
                for (i = 0; i < lista.length; ++i) {
                    this.tableContainer.swapRow(lista[i] - 1, lista[i]);
                }
                if (lista[0] > 0) {
                    this.tableContainer.setSelectedIndex(lista[0] - 1);
                }
            }
            if (e.getSource() == this.moveRowsPanel.getBDown() && (lista = this.tableContainer.getSelectedRows()).length > 0) {
                for (i = lista.length - 1; i >= 0; --i) {
                    this.tableContainer.swapRow(lista[i], lista[i] + 1);
                }
                this.tableContainer.setSelectedIndex(lista[0] + 1);
            }
            if (e.getSource() == this.controlPanel.getBFirst()) {
                this.tableContainer.setSelectedIndex(0);
            }
            if (e.getSource() == this.controlPanel.getBLast()) {
                this.tableContainer.setSelectedIndex(this.tableContainer.getRowCount() - 1);
            }
            if (e.getSource() == this.controlPanel.getBNext() && this.tableContainer.getSelectedRow() < this.tableContainer.getRowCount()) {
                this.tableContainer.setSelectedIndex(this.tableContainer.getSelectedRow() + 1);
            }
            if (e.getSource() == this.controlPanel.getBPrev() && this.tableContainer.getSelectedRow() > 0) {
                this.tableContainer.setSelectedIndex(this.tableContainer.getSelectedRow() - 1);
            }
            if (e.getSource() == this.controlPanel.getCPoint() && comboEventEnable) {
                this.tableContainer.setSelectedIndex(this.controlPanel.getCPoint().getSelectedIndex());
            }
        }
        catch (NotInitializeException notInitializeException) {
            // empty catch block
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            this.tableContainer.setSelectedIndex(this.tableContainer.getSelectedRow());
        }
        catch (NotInitializeException e1) {
            e1.printStackTrace();
        }
    }
}

