/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.spi;

import java.util.function.Supplier;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.LexicalAnalyzer;
import org.gvsig.expressionevaluator.MutableCodes;
import org.gvsig.expressionevaluator.UserOperator;

public class UserOperatorBase
implements UserOperator {
    private final String name;
    private String precedence;
    protected String functionName;
    protected String tokenLiteral;

    public UserOperatorBase(String name, String precedence) {
        this.name = name;
        this.precedence = precedence;
        this.tokenLiteral = name;
        this.functionName = name;
    }

    public UserOperatorBase(String name, String precedence, String tokenLiteral, String functionName) {
        this(name, precedence);
        this.tokenLiteral = tokenLiteral;
        this.functionName = functionName;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String precedence() {
        return this.precedence;
    }

    @Override
    public Code parse(LexicalAnalyzer lexer, CodeBuilder codebuilder, Code op1, Supplier<Code> op2) {
        if (this.parse_operator(lexer)) {
            MutableCodes args = codebuilder.args();
            args.add(op1);
            args.add(op2.get());
            Code.Callable x = codebuilder.function(this.functionName, 1, args);
            return x;
        }
        return null;
    }

    protected boolean parse_operator(LexicalAnalyzer lexer) {
        String s;
        lexer.save_state();
        StringBuilder ss = new StringBuilder();
        do {
            LexicalAnalyzer.Token token;
            if ((token = lexer.next()).getType() == -1) {
                lexer.restore_state();
                return false;
            }
            ss.append(token.getLiteral());
            s = ss.toString();
            if (!this.tokenLiteral.equals(s)) continue;
            lexer.drop_state();
            return true;
        } while (this.tokenLiteral.startsWith(s));
        lexer.restore_state();
        return false;
    }
}

