/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformset.base;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.texteditor.TextEditorManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.AbortActionException;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.JDynFormSet;
import org.gvsig.tools.dynform.services.dynformset.base.FormSetButtonBar;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformset.AbstractJDynFormSet;
import org.gvsig.tools.dynform.spi.dynformset.ActionStore;
import org.gvsig.tools.dynform.spi.dynformset.JDynFormSetFactory;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.viewer.JViewer;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;

public class BaseJDynFormSet
extends AbstractJDynFormSet
implements FormSetButtonBar.FormSetListener,
JDynForm.JDynFormListener {
    private JLabel jlabel_messages = null;
    private JDynForm form = null;
    private FormSetButtonBar buttonBar = null;
    private int current = 0;

    public BaseJDynFormSet(DynFormSPIManager manager, JDynFormSetFactory factory, JDynForm.DynFormContext context, DynFormDefinition definition, Tags contextTags) {
        super(manager, factory, context, definition, contextTags);
    }

    public JComponent asJComponent() {
        if (this.contents == null) {
            this.initComponents();
            if (this.buttonBar != null) {
                this.buttonBar.setReadOnly(this.isReadOnly());
            }
            if (this.form != null) {
                this.form.setReadOnly(this.isReadOnly());
            }
        }
        this.fireFormMovedToEvent(this.current);
        return this.contents;
    }

    public JDynForm getForm() {
        return this.form;
    }

    public JLabel getMessagesJLabel() {
        if (this.jlabel_messages == null) {
            this.jlabel_messages = new JLabel();
            this.jlabel_messages.setText(" ");
            this.jlabel_messages.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    int count = evt.getClickCount();
                    if (count == 2) {
                        JOptionPane.showMessageDialog(BaseJDynFormSet.this.contents, BaseJDynFormSet.this.jlabel_messages.getText(), "Status", 1);
                    }
                }
            });
        }
        return this.jlabel_messages;
    }

    public void message() {
        this.getMessagesJLabel().setText(" ");
    }

    public void message(String msg) {
        this.getMessagesJLabel().setText(msg);
    }

    private FormSetButtonBar getButtonBar() {
        if (this.buttonBar == null) {
            this.initComponents();
        }
        return this.buttonBar;
    }

    private void initComponents() {
        this.contents = new JPanel();
        this.contents.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.contents.setLayout(new BorderLayout());
        this.form = this.getManager().getDynFormManager().createJDynForm(this.getContext(), this.getDefinition());
        this.form.setReadOnly(this.isReadOnly());
        this.form.setLayoutMode(this.getLayoutMode());
        this.form.setUseScrollBars(this.getUseScrollBars());
        this.form.addListener((JDynForm.JDynFormListener)this);
        if (!this.actionsBuffer.isEmpty()) {
            for (ActionStore actStore : this.actionsBuffer) {
                if (actStore.isSeparator()) {
                    this.form.addSeparatorToPopupMenu(actStore.getDataType());
                    continue;
                }
                this.form.addActionToPopupMenu(actStore.getDataType(), actStore.getActionName(), actStore.getAction());
            }
        }
        if (this.getUseScrollBars() && this.formHeight > -1 && this.formWidth > -1) {
            this.setFormSize(this.formWidth, this.formHeight);
        }
        this.form.setShowMessageStatus(false);
        this.form.addListener((JDynForm.JDynFormListener)this);
        this.buttonBar = new FormSetButtonBar();
        this.buttonBar.addListener(this);
        this.buttonBar.setActionActive(8, this.allowDelete());
        this.buttonBar.setActionActive(6, this.allowNew());
        this.buttonBar.setActionActive(7, this.allowNew());
        this.buttonBar.setActionActive(5, this.allowUpdate());
        this.buttonBar.setActionActive(9, this.allowSearch());
        this.buttonBar.setActionActive(10, this.allowClose());
        this.buttonBar.setVisible(7, false);
        this.buttonBar.setReadOnly(this.isReadOnly());
        this.buttonBar.getActionButton("set-current-record").setComponentPopupMenu(this.getFormsetPopupMenu());
        this.contents.add((Component)this.form.asJComponent(), "Center");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        this.buttonBar.asJComponent().setAlignmentX(0.0f);
        this.getMessagesJLabel().setAlignmentX(0.0f);
        p.add(this.buttonBar.asJComponent());
        p.add(this.getMessagesJLabel());
        this.contents.add((Component)p, "South");
        this.doChangeValues();
    }

    public void setAllowDelete(boolean allowDelete) {
        super.setAllowDelete(allowDelete);
        if (this.buttonBar != null) {
            this.buttonBar.setActionActive(8, this.allowDelete());
        }
    }

    public void setAllowNew(boolean allowNew) {
        super.setAllowNew(allowNew);
        if (this.buttonBar != null) {
            this.buttonBar.setActionActive(6, this.allowNew());
        }
    }

    public void setAllowSearch(boolean allowSearch) {
        super.setAllowSearch(allowSearch);
        if (this.buttonBar != null) {
            this.buttonBar.setActionActive(9, this.allowNew());
        }
    }

    public void setAllowUpdate(boolean allowUpdate) {
        super.setAllowUpdate(allowUpdate);
        if (this.buttonBar != null) {
            this.buttonBar.setActionActive(5, this.allowNew());
        }
    }

    public void setAllowClose(boolean allowClose) {
        super.setAllowClose(allowClose);
        if (this.buttonBar != null) {
            this.buttonBar.setActionActive(10, this.allowNew());
        }
    }

    private void doChangeValues() {
        this.current = 0;
        if (this.values == null || this.values.isEmpty()) {
            this.form.setReadOnly(true);
            this.getButtonBar().setEnabled(8, false);
            this.getButtonBar().setEnabled(5, false);
            this.getButtonBar().setEnabled(6, this.allowNew() && !this.isReadOnly());
            this.getButtonBar().setNumrecords(0);
            this.form.clear();
        } else {
            this.form.setValues((DynObject)this.values.get(this.current));
            this.getButtonBar().setEnabled(8, this.allowDelete() && !this.isReadOnly());
            this.getButtonBar().setEnabled(5, this.allowUpdate() && !this.isReadOnly());
            this.getButtonBar().setNumrecords(this.values.size());
        }
        this.getButtonBar().setCurrent(this.current);
    }

    public void setValues(List values) {
        super.setValues(values);
        if (this.contents != null) {
            this.doChangeValues();
        }
    }

    public void setValues(DynObjectSet values) {
        super.setValues(values);
        if (this.contents != null) {
            this.doChangeValues();
        }
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (this.buttonBar != null) {
            this.buttonBar.setReadOnly(readOnly);
        }
        if (this.form != null) {
            this.form.setReadOnly(readOnly);
        }
    }

    @Override
    public boolean doActionFirst() {
        if (this.values.isEmpty()) {
            return false;
        }
        if (this.autosave && (this.form.isModified() || this.isInNewState()) && !this.doActionSave()) {
            return false;
        }
        this.callUserEvent("form_beforeFirst", new Object[]{this.getForm()});
        this.current = 0;
        this.form.setValues((DynObject)this.values.get(this.current));
        this.buttonBar.setCurrent(this.current);
        try {
            this.getButtonBar().setEnabled(8, this.allowDelete() && !this.isReadOnly());
            this.getButtonBar().setEnabled(5, this.allowUpdate() && !this.isReadOnly());
        }
        catch (Exception ex) {
            LOGGER.warn("Can't enable/disable delete and save buttons", (Throwable)ex);
        }
        this.callUserEvent("form_afterFirst", new Object[]{this.getForm()});
        this.doButtonBarStateChanged();
        this.fireFormMovedToEvent(this.current);
        return true;
    }

    @Override
    public boolean doActionPrevious() {
        if (this.values.isEmpty()) {
            return false;
        }
        if (this.autosave && (this.form.isModified() || this.isInNewState()) && !this.doActionSave()) {
            return false;
        }
        this.callUserEvent("form_beforePrevious", new Object[]{this.getForm()});
        if (this.current > 0) {
            --this.current;
        }
        this.form.setValues((DynObject)this.values.get(this.current));
        this.buttonBar.setCurrent(this.current);
        this.callUserEvent("form_afterPrevious", new Object[]{this.getForm()});
        this.doButtonBarStateChanged();
        this.fireFormMovedToEvent(this.current);
        return true;
    }

    @Override
    public boolean doActionNext() {
        if (this.values.isEmpty()) {
            return false;
        }
        if (this.autosave && (this.form.isModified() || this.isInNewState()) && !this.doActionSave()) {
            return false;
        }
        this.callUserEvent("form_beforeNext", new Object[]{this.getForm()});
        if (this.current < this.values.size() - 1) {
            ++this.current;
        }
        this.form.setValues((DynObject)this.values.get(this.current));
        this.buttonBar.setCurrent(this.current);
        this.callUserEvent("form_afterNext", new Object[]{this.getForm()});
        this.doButtonBarStateChanged();
        this.fireFormMovedToEvent(this.current);
        return true;
    }

    @Override
    public boolean doActionLast() {
        if (this.values.isEmpty()) {
            return false;
        }
        if (this.autosave && (this.form.isModified() || this.isInNewState()) && !this.doActionSave()) {
            return false;
        }
        this.callUserEvent("form_beforeLast", new Object[]{this.getForm()});
        this.current = this.values.size() - 1;
        this.form.setValues((DynObject)this.values.get(this.current));
        this.buttonBar.setCurrent(this.current);
        this.callUserEvent("form_afterLast", new Object[]{this.getForm()});
        this.doButtonBarStateChanged();
        this.fireFormMovedToEvent(this.current);
        return true;
    }

    @Override
    public boolean doActionSave() {
        if (!this.isInNewState() && this.values.isEmpty()) {
            return false;
        }
        try {
            this.listeners.accept(listener -> ((JDynFormSet.JDynFormSetListener)listener).formBeforeSave((JDynFormSet)this));
        }
        catch (AbortActionException e) {
            return false;
        }
        catch (BaseException e) {
            LOGGER.warn("Can't notify to listeners before save.", (Throwable)e);
            return false;
        }
        this.callUserEvent("form_beforeSave", new Object[]{this.getForm()});
        ArrayList fieldsName = new ArrayList();
        if (!this.form.hasValidValues(fieldsName)) {
            String errores = "";
            for (String name : fieldsName) {
                errores = errores + "     - " + name + "\n";
            }
            int r = this.confirmDialog("There are incorrect data in the following fields:\n" + errores + "\nContinuing the incorrect values \u00e2\u0080\u008bwill not be saved. Do you want to continue?", "warning", 2, 0);
            if (r != 0) {
                return false;
            }
        }
        if (!this.isInNewState()) {
            if (this.current >= 0 && this.current < this.values.size()) {
                this.form.getValues((DynObject)this.values.get(this.current));
            } else {
                LOGGER.warn("current out of range.");
            }
        }
        this.leaveTheNewState();
        this.callUserEvent("form_afterSave", new Object[]{this.getForm()});
        this.doButtonBarStateChanged();
        try {
            this.listeners.accept(listener -> ((JDynFormSet.JDynFormSetListener)listener).formAfterSave((JDynFormSet)this));
        }
        catch (AbortActionException e) {
            return false;
        }
        catch (BaseException e) {
            LOGGER.warn("Can't notify to listeners after save.", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean doActionNew() {
        try {
            this.listeners.accept(listener -> ((JDynFormSet.JDynFormSetListener)listener).formBeforeNew((JDynFormSet)this));
        }
        catch (BaseException e) {
            return true;
        }
        this.callUserEvent("form_beforeNew", new Object[]{this.getForm()});
        this.enterStateNew();
        this.callUserEvent("form_afterNew", new Object[]{this.getForm()});
        this.doButtonBarStateChanged();
        try {
            this.listeners.accept(listener -> ((JDynFormSet.JDynFormSetListener)listener).formAfterNew((JDynFormSet)this));
        }
        catch (BaseException e) {
            return true;
        }
        return true;
    }

    @Override
    public boolean doActionCancelNew() {
        try {
            this.listeners.accept(listener -> ((JDynFormSet.JDynFormSetListener)listener).formBeforeCancelNew((JDynFormSet)this));
        }
        catch (BaseException e) {
            return true;
        }
        this.callUserEvent("form_beforeCancelNew", new Object[]{this.getForm()});
        this.leaveTheNewState();
        this.callUserEvent("form_afterCancelNew", new Object[]{this.getForm()});
        this.doButtonBarStateChanged();
        try {
            this.listeners.accept(listener -> ((JDynFormSet.JDynFormSetListener)listener).formAfterCancelNew((JDynFormSet)this));
        }
        catch (BaseException e) {
            return true;
        }
        return true;
    }

    protected void enterStateNew() {
        if (this.isInNewState()) {
            return;
        }
        try {
            FormSetButtonBar bar = this.getButtonBar();
            super.enterStateNew();
            bar.setCurrentLabel(ToolsLocator.getI18nManager().getTranslation("nuevo"));
            bar.setNumrecords(this.countValues());
            bar.setVisible(7, true);
            bar.setVisible(6, false);
            bar.setEnabled(5, true);
            bar.setEnabled(7, true);
            bar.setEnabled(8, false);
            bar.setEnabled(1, false);
            bar.setEnabled(3, false);
            bar.setEnabled(2, false);
            bar.setEnabled(4, false);
            bar.setEnabled(9, false);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't enable/disable delete and save buttons", (Throwable)ex);
        }
    }

    protected void leaveTheNewState() {
        if (!this.isInNewState()) {
            return;
        }
        super.leaveTheNewState();
        try {
            FormSetButtonBar bar = this.getButtonBar();
            bar.setVisible(7, false);
            bar.setVisible(6, true);
            bar.setEnabled(5, true);
            bar.setEnabled(6, true);
            bar.setEnabled(8, true);
            bar.setEnabled(9, true);
            bar.setCurrentLabel(null);
            bar.setNumrecords(this.countValues());
            bar.setCurrent(this.current);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't enable/disable delete and save buttons", (Throwable)ex);
        }
    }

    @Override
    public boolean doActionDelete() {
        if (this.values.isEmpty()) {
            return false;
        }
        if (this.countValues() < 1) {
            return true;
        }
        try {
            this.listeners.accept(listener -> ((JDynFormSet.JDynFormSetListener)listener).formBeforeDelete((JDynFormSet)this));
        }
        catch (BaseException e) {
            return true;
        }
        if (this.current >= this.countValues()) {
            this.current = this.countValues() - 1;
        }
        if (this.current > -1) {
            this.form.setValues((DynObject)this.values.get(this.current));
        }
        this.buttonBar.setNumrecords(this.countValues());
        this.buttonBar.setCurrent(this.current);
        this.doButtonBarStateChanged();
        try {
            this.listeners.accept(listener -> ((JDynFormSet.JDynFormSetListener)listener).formAfterDelete((JDynFormSet)this));
        }
        catch (BaseException e) {
            return true;
        }
        return true;
    }

    @Override
    public boolean doActionSearch() {
        if (this.values.isEmpty()) {
            return false;
        }
        try {
            this.listeners.accept(listener -> ((JDynFormSet.JDynFormSetListener)listener).formBeforeSearch((JDynFormSet)this));
        }
        catch (BaseException e) {
            return true;
        }
        try {
            this.listeners.accept(listener -> ((JDynFormSet.JDynFormSetListener)listener).formAfterSearch((JDynFormSet)this));
        }
        catch (BaseException e) {
            return true;
        }
        return true;
    }

    @Override
    public boolean doActionClose() {
        this.fireCloseEvent();
        return true;
    }

    @Override
    public void doSetCurrentRecord(int index) {
        this.setCurrentIndex(index);
        this.doButtonBarStateChanged();
    }

    public JPopupMenu getFormsetPopupMenu() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        JPopupMenu popup = new JPopupMenu();
        JMenu moveMenu = new JMenu(i18n.getTranslation("_Move"));
        moveMenu.add(new JMenuItem(BaseJDynFormSet.createAction("first", "_first", null, "common-form-first", () -> this.buttonBar.isEnabled("first"), e -> this.doActionFirst())));
        moveMenu.add(new JMenuItem(BaseJDynFormSet.createAction("previous", "_back", null, "common-form-previous", () -> this.buttonBar.isEnabled("previous"), e -> this.doActionPrevious())));
        moveMenu.add(new JMenuItem(BaseJDynFormSet.createAction("set-current-record", "_first", null, "common-form-first", () -> this.buttonBar.isEnabled("set-current-record"), e -> this.buttonBar.doGoRecord())));
        moveMenu.add(new JMenuItem(BaseJDynFormSet.createAction("next", "_next", null, "common-form-next", () -> this.buttonBar.isEnabled("next"), e -> this.doActionNext())));
        moveMenu.add(new JMenuItem(BaseJDynFormSet.createAction("last", "_last", null, "common-form-last", () -> this.buttonBar.isEnabled("last"), e -> this.doActionFirst())));
        popup.add(moveMenu);
        popup.addSeparator();
        popup.add(new JMenuItem(BaseJDynFormSet.createAction("save", "guardar", null, "common-form-save", () -> this.buttonBar.isEnabled("save"), e -> this.doActionSave())));
        popup.add(new JMenuItem(BaseJDynFormSet.createAction("new", "nuevo", null, "common-form-new", () -> this.buttonBar.isEnabled("new"), e -> this.doActionNew())));
        popup.add(new JMenuItem(BaseJDynFormSet.createAction("cancel-new", "cancelar nuevo", null, "common-form-cancelnew", () -> this.buttonBar.isEnabled("cancel-new"), e -> this.doActionCancelNew())));
        popup.add(new JMenuItem(BaseJDynFormSet.createAction("delete", "borrar", null, "common-form-delete", () -> this.buttonBar.isEnabled("delete"), e -> this.doActionDelete())));
        popup.add(new JMenuItem(BaseJDynFormSet.createAction("search", "search", null, "common-form-search", () -> this.buttonBar.isEnabled("search"), e -> this.doActionSearch())));
        popup.addSeparator();
        popup.add(new JMenuItem(BaseJDynFormSet.createAction("SHOW_SCRIPT", "_Show_script", null, null, () -> this.form.getScript() != null, e -> this.doShowScript())));
        return popup;
    }

    private void doShowScript() {
        Script script = this.form.getScript();
        if (script == null) {
            return;
        }
        String source = script.getCode();
        TextEditorManager editorFactory = ToolsSwingLocator.getTextEditorManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        boolean isEditable = !this.getForm().isReadOnly() && editorFactory.isEditable();
        String title = (isEditable ? i18n.getTranslation("_Script_editor") : i18n.getTranslation("_Script_viewer")) + " " + script.getName();
        try {
            JViewer viewer = editorFactory.createViewer();
            viewer.setContents((Object)source);
            viewer.setEditable(isEditable);
            viewer.setEnabled(true);
            WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            Dialog dialog = winmanager.createDialog(viewer.asJComponent(), title, null, 3);
            dialog.setButtonEnabled(1, isEditable);
            dialog.addActionListener(e -> {
                if (isEditable && dialog.getAction() == 1) {
                    try {
                        this.form.putScript(Objects.toString(viewer.getContents(), null));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't bytes from editor.", (Throwable)ex);
                        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                        dialogs.messageDialog(i18n.getTranslation("_Cant_get_save_script") + "\n\n" + BaseException.getHTMLMessageStack((Throwable)ex), title, 2);
                    }
                }
            });
            dialog.show(WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show editor.", (Throwable)ex);
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog(i18n.getTranslation("_Cant_show_viewer"), title, 2);
            return;
        }
    }

    public void setFormSize(int width, int height) {
        super.setFormSize(width, height);
        if (this.form != null) {
            this.form.setFormSize(width, height);
        }
    }

    public int getCurrentIndex() {
        return this.current;
    }

    public void setCurrentIndex(int index) {
        if (index < 0 || index > this.countValues()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") out of range [0.." + this.countValues() + "].");
        }
        this.current = index;
        this.form.setValues((DynObject)this.values.get(this.current));
        this.buttonBar.setCurrent(this.current);
        this.fireFormMovedToEvent(this.current);
    }

    public void fieldChanged(JDynFormField field) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Ha cambiado el field: " + field.getName() + " con el valor => " + field.getValue());
        }
    }

    public DynObject get(int position) {
        LOGGER.debug("Recojo el field: " + position);
        return (DynObject)this.values.get(position);
    }

    public List getValues() {
        if (this.current >= 0 && this.current < this.values.size()) {
            this.form.getValues((DynObject)this.values.get(this.current));
        }
        return this.values;
    }

    public boolean hasValidValues() {
        return this.form.hasValidValues();
    }

    public boolean hasValidValues(List<String> fieldsName) {
        return this.form.hasValidValues(fieldsName);
    }

    public void clear() {
        if (this.form != null) {
            this.form.clear();
        }
    }

    public void getFormValues(DynObject values) {
        this.form.getValues(values);
    }

    public void addAction(Action action) {
        this.getButtonBar().addAction(action);
    }

    public Action getAction(String actionId) {
        if (this.buttonBar == null) {
            return null;
        }
        return this.getButtonBar().getAction(actionId);
    }

    public List<Action> getActions() {
        if (this.buttonBar == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getButtonBar().getActions();
    }

    public void setActionVisible(String action, boolean visible) {
        this.getButtonBar().setVisible(action, visible);
    }

    public void setActionEnabled(String action, boolean enabled) {
        this.getButtonBar().setEnabled(action, enabled);
    }

    public boolean isActionEnabled(String action) {
        return this.getButtonBar().isEnabled(action);
    }

    public boolean isActionVisible(String action) {
        return this.getButtonBar().isVisible(action);
    }

    public JComponent getActionButton(String action) {
        return this.getButtonBar().getActionButton(action);
    }

    public void fireEvent(String action, Object value) {
        this.getButtonBar().fireEvent(action, value);
    }

    private static Action createAction(String name, String text, String tip, String image, final BooleanSupplier isEnabled, final ActionListener actionListener) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (actionListener != null) {
                    actionListener.actionPerformed(e);
                }
            }

            @Override
            public boolean isEnabled() {
                if (isEnabled == null) {
                    return super.isEnabled();
                }
                return isEnabled.getAsBoolean();
            }

            @Override
            public Object getValue(String key) {
                if (isEnabled != null && StringUtils.equals((CharSequence)key, (CharSequence)"enabled")) {
                    return isEnabled.getAsBoolean();
                }
                return super.getValue(key);
            }
        };
        if (StringUtils.isNotBlank((CharSequence)image)) {
            IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
            IconTheme theme = iconThemeManager.getCurrent();
            action.putValue("SmallIcon", theme.get(image));
        }
        if (StringUtils.isNotBlank((CharSequence)tip)) {
            action.putValue("ShortDescription", tip);
        }
        if (StringUtils.isNotBlank((CharSequence)text)) {
            if (text.startsWith("_")) {
                text = ToolsLocator.getI18nManager().getTranslation(text);
            }
            action.putValue("Name", text);
        }
        return action;
    }

    private void doButtonBarStateChanged() {
        this.buttonBar.getActionButton("set-current-record").setComponentPopupMenu(this.getFormsetPopupMenu());
    }
}

