/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox.view;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.View;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.swingbox.util.Anchor;
import org.fit.cssbox.swingbox.view.CSSBoxView;
import org.w3c.dom.Element;

public class BackgroundView
extends View
implements CSSBoxView {
    private ElementBox box;
    private int order;
    private AttributeSet attributes;
    private boolean refreshAttributes;
    private Anchor anchor;

    public BackgroundView(javax.swing.text.Element elem) {
        super(elem);
        AttributeSet tmpAttr = elem.getAttributes();
        Object obj = tmpAttr.getAttribute("attribute_box_reference");
        this.anchor = (Anchor)tmpAttr.getAttribute("attribute_anchor_reference");
        Integer i = (Integer)tmpAttr.getAttribute("attribute_drawing_order");
        int n = this.order = i == null ? -1 : i;
        if (!(obj instanceof ElementBox)) {
            throw new IllegalArgumentException("Box reference is not an instance of ElementBox");
        }
        this.box = (ElementBox)obj;
        if (this.box.toString().contains("\"btn\"")) {
            System.out.println("jo!");
        }
        if (this.box.getElement() != null) {
            Map<String, String> elementAttributes = this.anchor.getProperties();
            Element pelem = Anchor.findAnchorElement(this.box.getElement());
            if (pelem != null) {
                this.anchor.setActive(true);
                elementAttributes.put("a_href", pelem.getAttribute("href"));
                elementAttributes.put("a_name", pelem.getAttribute("name"));
                elementAttributes.put("a_title", pelem.getAttribute("title"));
                String target = pelem.getAttribute("target");
                if ("".equals(target)) {
                    target = "_self";
                }
                elementAttributes.put("a_target", target);
            } else {
                this.anchor.setActive(false);
                elementAttributes.clear();
            }
        }
    }

    public String toString() {
        return "Background " + this.order + ": " + this.box;
    }

    @Override
    public void paint(Graphics graphics, Shape allocation) {
        if (!(graphics instanceof Graphics2D)) {
            throw new RuntimeException("Unknown graphics enviroment, java.awt.Graphics2D required !");
        }
        Graphics2D g = (Graphics2D)graphics;
        this.box.getVisualContext().updateGraphics(g);
        this.box.drawBackground(g);
    }

    @Override
    public void setParent(View parent) {
        super.setParent(parent);
        this.refreshAttributes = true;
    }

    @Override
    public boolean isVisible() {
        return this.box.isVisible();
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        Rectangle alloc;
        Rectangle rectangle = alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        if (x < (float)(alloc.x + alloc.width / 2)) {
            bias[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        bias[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (pos >= p0 && pos <= p1) {
            Rectangle r;
            Rectangle rectangle = r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            if (pos == p1) {
                r.x += r.width;
            }
            r.width = 0;
            return r;
        }
        throw new BadLocationException(pos + " not in range " + p0 + "," + p1, pos);
    }

    @Override
    public float getPreferredSpan(int axis) {
        switch (axis) {
            case 0: {
                return 10.0f;
            }
            case 1: {
                return 10.0f;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public int getDrawingOrder() {
        return this.order;
    }

    @Override
    public AttributeSet getAttributes() {
        if (this.refreshAttributes) {
            this.attributes = this.createAttributes();
            this.refreshAttributes = false;
        }
        return this.attributes;
    }

    protected SimpleAttributeSet createAttributes() {
        SimpleAttributeSet res = new SimpleAttributeSet();
        res.addAttribute("attribute_anchor_reference", this.anchor);
        res.addAttribute("attribute_box_reference", this.box);
        return res;
    }
}

