/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.TimeStampable;
import org.exolab.castor.jdo.engine.JDOCallback;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.persist.CollectionProxy;
import org.exolab.castor.persist.DatingService;
import org.exolab.castor.persist.DepositBox;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.Lazy;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectLock;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.RelationCollection;
import org.exolab.castor.persist.TransactionContext;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.Complex;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public class ClassMolder {
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$persist$ClassMolder == null ? (class$org$exolab$castor$persist$ClassMolder = ClassMolder.class$("org.exolab.castor.persist.ClassMolder")) : class$org$exolab$castor$persist$ClassMolder);
    private String _name;
    private FieldMolder[] _ids;
    private FieldMolder[] _fhs;
    private ClassMolder _extends;
    private ClassMolder _depends;
    private Vector _dependent;
    private Vector _extendent;
    private AccessMode _accessMode;
    private Persistence _persistence;
    private LockEngine _engine;
    private CallbackInterceptor _callback;
    private String _cachetype;
    private int _cacheparam;
    private boolean _isKeyGenUsed;
    private boolean _debug = Boolean.getBoolean("org.exolab.castor.debug");
    private boolean _timeStampable;
    private int _priority = -1;
    static /* synthetic */ Class class$org$exolab$castor$persist$ClassMolder;
    static /* synthetic */ Class class$org$exolab$castor$jdo$TimeStampable;
    static /* synthetic */ Class class$org$exolab$castor$jdo$Persistent;

    ClassMolder(DatingService ds, MappingLoader loader, LockEngine lock, ClassDescriptor clsDesc, Persistence persist) throws ClassNotFoundException, MappingException {
        ClassMapping clsMap = ((ClassDescriptorImpl)clsDesc).getMapping();
        this._engine = lock;
        this._persistence = persist;
        this._name = clsMap.getName();
        this._accessMode = AccessMode.getAccessMode(clsMap.getAccess().toString());
        this._timeStampable = (class$org$exolab$castor$jdo$TimeStampable == null ? (class$org$exolab$castor$jdo$TimeStampable = ClassMolder.class$("org.exolab.castor.jdo.TimeStampable")) : class$org$exolab$castor$jdo$TimeStampable).isAssignableFrom(clsDesc.getJavaClass());
        ds.register(this._name, this);
        ClassMapping dep = (ClassMapping)clsMap.getDepends();
        ClassMapping ext = (ClassMapping)clsMap.getExtends();
        if (dep != null) {
            ds.pairDepends(this, dep.getName());
        }
        if (ext != null) {
            ds.pairExtends(this, ext.getName());
        }
        if (clsDesc instanceof JDOClassDescriptor) {
            if (((JDOClassDescriptor)clsDesc).getCacheType() != null) {
                this._cachetype = ((JDOClassDescriptor)clsDesc).getCacheType();
                this._cacheparam = ((JDOClassDescriptor)clsDesc).getCacheParam();
            }
            this._isKeyGenUsed = ((JDOClassDescriptor)clsDesc).getKeyGeneratorDescriptor() != null;
        }
        FieldMapping[] fmId = this.getIdFields(clsMap);
        this._ids = new FieldMolder[fmId.length];
        for (int i = 0; i < this._ids.length; ++i) {
            this._ids[i] = new FieldMolder(ds, this, fmId[i]);
        }
        FieldMapping[] fmFields = this.getFullFields(clsMap);
        this._fhs = new FieldMolder[fmFields.length];
        for (int i = 0; i < this._fhs.length; ++i) {
            if (fmFields[i].getSql() != null && fmFields[i].getSql().getManyTable() != null) {
                String[] manyName;
                String[] manyKey;
                String manyTable = null;
                String[] idSQL = null;
                int[] idType = null;
                String[] relatedIdSQL = null;
                int[] relatedIdType = null;
                TypeConvertor[] idConvertTo = null;
                TypeConvertor[] idConvertFrom = null;
                String[] idConvertParam = null;
                TypeConvertor[] relatedIdConvertTo = null;
                TypeConvertor[] relatedIdConvertFrom = null;
                String[] relatedIdConvertParam = null;
                manyTable = fmFields[i].getSql().getManyTable();
                idSQL = new String[fmId.length];
                idType = new int[fmId.length];
                idConvertFrom = new TypeConvertor[fmId.length];
                idConvertTo = new TypeConvertor[fmId.length];
                idConvertParam = new String[fmId.length];
                FieldDescriptor[] fd = ((ClassDescriptorImpl)clsDesc).getIdentities();
                for (int j = 0; j < fmId.length; ++j) {
                    idSQL[j] = fmId[j].getSql().getName()[0];
                    if (!(fd[j] instanceof JDOFieldDescriptor)) {
                        throw new MappingException("Identity type must contains sql information: " + this._name);
                    }
                    int[] type = ((JDOFieldDescriptor)fd[j]).getSQLType();
                    idType[j] = type == null ? 0 : type[0];
                    FieldHandlerImpl fh = (FieldHandlerImpl)fd[j].getHandler();
                    idConvertTo[j] = fh.getConvertTo();
                    idConvertFrom[j] = fh.getConvertFrom();
                    idConvertParam[j] = fh.getConvertParam();
                }
                relatedIdSQL = null;
                String relatedType = fmFields[i].getType();
                ClassDescriptor relDesc = loader.getDescriptor(ds.resolve(relatedType));
                if (relDesc instanceof JDOClassDescriptor) {
                    FieldDescriptor[] relatedIds = ((JDOClassDescriptor)relDesc).getIdentities();
                    relatedIdSQL = new String[relatedIds.length];
                    relatedIdType = new int[relatedIds.length];
                    relatedIdConvertTo = new TypeConvertor[relatedIds.length];
                    relatedIdConvertFrom = new TypeConvertor[relatedIds.length];
                    relatedIdConvertParam = new String[relatedIds.length];
                    for (int j = 0; j < relatedIdSQL.length; ++j) {
                        if (!(relatedIds[j] instanceof JDOFieldDescriptor)) {
                            throw new MappingException("Field type is not persistence-capable: " + relatedIds[j].getFieldName());
                        }
                        String[] tempId = ((JDOFieldDescriptor)relatedIds[j]).getSQLName();
                        relatedIdSQL[j] = tempId == null ? null : tempId[0];
                        int[] tempType = ((JDOFieldDescriptor)relatedIds[j]).getSQLType();
                        relatedIdType[j] = tempType == null ? 0 : tempType[0];
                        FieldHandlerImpl fh = (FieldHandlerImpl)relatedIds[j].getHandler();
                        relatedIdConvertTo[j] = fh.getConvertTo();
                        relatedIdConvertFrom[j] = fh.getConvertFrom();
                        relatedIdConvertParam[j] = fh.getConvertParam();
                    }
                }
                if ((manyKey = fmFields[i].getSql().getManyKey()) != null && manyKey.length != 0) {
                    if (manyKey.length != idSQL.length) {
                        throw new MappingException("The number of many-keys doesn't match referred object: " + clsDesc.getJavaClass().getName());
                    }
                    idSQL = manyKey;
                }
                if ((manyName = fmFields[i].getSql().getName()) != null && manyName.length != 0) {
                    if (manyName.length != relatedIdSQL.length) {
                        throw new MappingException("The number of many-keys doesn't match referred object: " + relDesc.getJavaClass().getName());
                    }
                    relatedIdSQL = manyName;
                }
                this._fhs[i] = new FieldMolder(ds, this, fmFields[i], manyTable, idSQL, idType, idConvertTo, idConvertFrom, idConvertParam, relatedIdSQL, relatedIdType, relatedIdConvertTo, relatedIdConvertFrom, relatedIdConvertParam);
                continue;
            }
            this._fhs[i] = new FieldMolder(ds, this, fmFields[i]);
        }
        if ((class$org$exolab$castor$jdo$Persistent == null ? (class$org$exolab$castor$jdo$Persistent = ClassMolder.class$("org.exolab.castor.jdo.Persistent")) : class$org$exolab$castor$jdo$Persistent).isAssignableFrom(ds.resolve(this._name))) {
            this._callback = new JDOCallback();
        }
    }

    private FieldMapping[] getIdFields(ClassMapping clsMap) throws MappingException {
        ClassMapping base = clsMap;
        while (base.getExtends() != null) {
            base = (ClassMapping)base.getExtends();
        }
        Object fmDepended = null;
        String[] identities = base.getIdentity();
        if (identities == null || identities.length == 0) {
            throw new MappingException("Identity is null!");
        }
        FieldMapping[] fmIds = new FieldMapping[identities.length];
        FieldMapping[] fmBase = base.getFieldMapping();
        block1: for (int i = 0; i < fmBase.length; ++i) {
            for (int k = 0; k < identities.length; ++k) {
                if (!fmBase[i].getName().equals(identities[k])) continue;
                fmIds[k] = fmBase[i];
                continue block1;
            }
        }
        if (fmDepended == null) {
            return fmIds;
        }
        FieldMapping[] fmResult = new FieldMapping[(fmDepended).length + identities.length];
        System.arraycopy(fmIds, 0, fmResult, 0, fmIds.length);
        System.arraycopy(fmDepended, 0, fmResult, fmIds.length, (fmDepended).length);
        return fmIds;
    }

    private FieldMapping[] getFullFields(ClassMapping clsMap) throws MappingException {
        FieldMapping[] fields = null;
        ClassMapping extend = (ClassMapping)clsMap.getExtends();
        if (extend != null) {
            int i;
            ClassMapping origin = extend;
            while (origin.getExtends() != null) {
                origin = (ClassMapping)origin.getExtends();
            }
            String[] identities = origin.getIdentity();
            FieldMapping[] extendFields = this.getFullFields(extend);
            FieldMapping[] thisFields = clsMap.getFieldMapping();
            ArrayList<FieldMapping> fieldList = new ArrayList<FieldMapping>(extendFields.length + thisFields.length);
            for (i = 0; i < extendFields.length; ++i) {
                fieldList.add(extendFields[i]);
            }
            block2: for (i = 0; i < thisFields.length; ++i) {
                for (int k = 0; k < identities.length; ++k) {
                    if (thisFields[i].getName().equals(identities[k])) continue;
                    fieldList.add(thisFields[i]);
                    continue block2;
                }
            }
            fields = new FieldMapping[fieldList.size()];
            fieldList.toArray(fields);
        } else {
            String[] identities = clsMap.getIdentity();
            if (identities == null || identities.length == 0) {
                throw new MappingException("Identity is null!");
            }
            FieldMapping[] thisFields = clsMap.getFieldMapping();
            fields = new FieldMapping[thisFields.length - identities.length];
            int j = 0;
            for (int i = 0; i < thisFields.length; ++i) {
                boolean idfield = false;
                for (int k = 0; k < identities.length; ++k) {
                    if (!thisFields[i].getName().equals(identities[k])) continue;
                    idfield = true;
                    break;
                }
                if (idfield) continue;
                fields[j] = thisFields[i];
                ++j;
            }
        }
        return fields;
    }

    public static Vector resolve(MappingLoader loader, LockEngine lock, PersistenceFactory factory) throws MappingException, ClassNotFoundException {
        Vector<ClassMolder> result = new Vector<ClassMolder>();
        DatingService ds = new DatingService(loader.getClassLoader());
        Enumeration enumeration = loader.listJavaClasses();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor desc = loader.getDescriptor((Class)enumeration.nextElement());
            Persistence persist = factory.getPersistence(desc);
            ClassMolder mold = new ClassMolder(ds, loader, lock, desc, persist);
            result.add(mold);
        }
        ds.close();
        return result;
    }

    private boolean removeRelation(TransactionContext tx, Object object, ClassMolder relatedMolder, Object relatedObject) {
        boolean removed = false;
        boolean updateCache = false;
        boolean updatePersist = false;
        ClassMolder relatedBaseMolder = null;
        block4: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 2: {
                    Object related;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    relatedBaseMolder = relatedMolder;
                    while (fieldClassMolder != relatedBaseMolder && relatedBaseMolder != null) {
                        relatedBaseMolder = relatedBaseMolder._extends;
                    }
                    if (fieldClassMolder != relatedBaseMolder || (related = this._fhs[i].getValue(object, tx.getClassLoader())) != relatedObject) continue block4;
                    this._fhs[i].setValue(object, null, tx.getClassLoader());
                    updateCache = true;
                    updatePersist = true;
                    removed = true;
                    continue block4;
                }
                case 3: 
                case 4: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    relatedBaseMolder = relatedMolder;
                    while (fieldClassMolder != relatedBaseMolder && relatedBaseMolder != null) {
                        relatedBaseMolder = relatedBaseMolder._extends;
                    }
                    if (fieldClassMolder != relatedBaseMolder) continue block4;
                    boolean changed = false;
                    Object related = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (related instanceof RelationCollection) {
                        RelationCollection lazy = (RelationCollection)related;
                        changed = lazy.remove(relatedObject);
                    } else {
                        Iterator itor = this.getIterator(related);
                        while (itor.hasNext()) {
                            Object o = itor.next();
                            if (o != relatedObject) continue;
                            changed = true;
                            itor.remove();
                        }
                    }
                    if (!changed) continue block4;
                    updateCache = true;
                    updatePersist = false;
                    removed = true;
                }
            }
        }
        tx.markModified(object, updatePersist, updateCache);
        return removed;
    }

    public int getPriority() {
        if (this._priority == -2) {
            return 0;
        }
        if (this._priority < 0) {
            int i;
            this._priority = -2;
            int maxPrior = 0;
            for (i = 0; i < this._fhs.length; ++i) {
                if (!this._fhs[i].isPersistanceCapable() || this._fhs[i].getFieldClassMolder() == this || !this._fhs[i].isStored() || !this._fhs[i].getFieldClassMolder().isKeyGeneratorUsed()) continue;
                maxPrior = Math.max(maxPrior, this._fhs[i].getFieldClassMolder().getPriority() + 1);
            }
            if (this._extendent != null) {
                for (i = 0; i < this._extendent.size(); ++i) {
                    maxPrior = Math.max(maxPrior, ((ClassMolder)this._extendent.get(i)).getPriority());
                }
            }
            this._priority = maxPrior;
        }
        return this._priority;
    }

    public Object load(TransactionContext tx, OID oid, DepositBox locker, Object object, AccessMode suggestedAccessMode) throws ObjectNotFoundException, PersistenceException {
        return this.load(tx, oid, locker, object, suggestedAccessMode, null);
    }

    public Object load(TransactionContext tx, OID oid, DepositBox locker, Object object, AccessMode suggestedAccessMode, QueryResults results) throws ObjectNotFoundException, PersistenceException {
        Object stamp = null;
        AccessMode accessMode = this.getAccessMode(suggestedAccessMode);
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identities of the object to be loaded is null");
        }
        Object[] fields = (Object[])locker.getObject(tx);
        if (fields == null || accessMode == AccessMode.DbLocked) {
            fields = new Object[this._fhs.length];
            if (results != null) {
                stamp = results.getQuery().fetch(fields, oid.getIdentity());
            } else {
                Connection conn = (Connection)tx.getConnection(oid.getLockEngine());
                stamp = this._persistence.load(conn, fields, oid.getIdentity(), accessMode);
            }
            oid.setDbLock(accessMode == AccessMode.DbLocked);
            locker.setObject(tx, fields);
        }
        if (object instanceof TimeStampable) {
            ((TimeStampable)object).jdoSetTimeStamp(locker.getTimeStamp());
        }
        Object ids = oid.getIdentity();
        this.setIdentity(tx, object, ids);
        block12: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: {
                    Object temp = fields[i];
                    if (temp != null) {
                        this._fhs[i].setValue(object, temp, tx.getClassLoader());
                        continue block12;
                    }
                    this._fhs[i].setValue(object, null, tx.getClassLoader());
                    continue block12;
                }
                case 1: {
                    try {
                        byte[] bytes = (byte[])fields[i];
                        if (bytes != null) {
                            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                            ObjectInputStream os = new ObjectInputStream(bis);
                            Object o = os.readObject();
                            this._fhs[i].setValue(object, o, tx.getClassLoader());
                            continue block12;
                        }
                        this._fhs[i].setValue(object, null, tx.getClassLoader());
                        continue block12;
                    }
                    catch (OptionalDataException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                }
                case 2: {
                    Object temp;
                    if (this._fhs[i].isLazy()) {
                        System.err.println("Warning: Lazy loading of object is not yet support!");
                    }
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    if (fields[i] != null) {
                        try {
                            temp = tx.load(fieldEngine, fieldClassMolder, fields[i], null, suggestedAccessMode);
                        }
                        catch (ObjectNotFoundException ex) {
                            temp = null;
                        }
                        this._fhs[i].setValue(object, temp, tx.getClassLoader());
                        continue block12;
                    }
                    this._fhs[i].setValue(object, null, tx.getClassLoader());
                    continue block12;
                }
                case 3: 
                case 4: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    if (!this._fhs[i].isLazy()) {
                        ArrayList v = (ArrayList)fields[i];
                        if (v != null) {
                            int j;
                            int l;
                            Class collectionType = this._fhs[i].getCollectionType();
                            if (collectionType.isArray()) {
                                Object[] value = (Object[])Array.newInstance(collectionType.getComponentType(), v.size());
                                l = v.size();
                                for (j = 0; j < l; ++j) {
                                    value[j] = tx.load(oid.getLockEngine(), fieldClassMolder, v.get(j), null, suggestedAccessMode);
                                }
                                this._fhs[i].setValue(object, value, tx.getClassLoader());
                                continue block12;
                            }
                            CollectionProxy cp = CollectionProxy.create(this._fhs[i], object, tx.getClassLoader());
                            l = v.size();
                            for (j = 0; j < l; ++j) {
                                cp.add(v.get(j), tx.load(oid.getLockEngine(), fieldClassMolder, v.get(j), null, suggestedAccessMode));
                            }
                            cp.close();
                            continue block12;
                        }
                        this._fhs[i].setValue(object, null, tx.getClassLoader());
                        continue block12;
                    }
                    ArrayList list = (ArrayList)fields[i];
                    RelationCollection relcol = new RelationCollection(tx, oid, fieldEngine, fieldClassMolder, accessMode, list);
                    this._fhs[i].setValue(object, relcol, tx.getClassLoader());
                    continue block12;
                }
                default: {
                    throw new PersistenceException("Unexpected field type!");
                }
            }
        }
        return stamp;
    }

    public Object create(TransactionContext tx, OID oid, DepositBox locker, Object object) throws DuplicateIdentityException, PersistenceException {
        ArrayList fids;
        Object o;
        ClassMolder fieldClassMolder;
        short fieldType;
        int i;
        if (this._persistence == null) {
            throw new PersistenceException("non persistence capable: " + oid.getName());
        }
        Object[] fields = new Object[this._fhs.length];
        Object ids = oid.getIdentity();
        block12: for (i = 0; i < this._fhs.length; ++i) {
            fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: {
                    fields[i] = this._fhs[i].getValue(object, tx.getClassLoader());
                    continue block12;
                }
                case 2: {
                    Object fid;
                    fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null || (fid = fieldClassMolder.getIdentity(tx, o)) == null) continue block12;
                    fields[i] = fid;
                    continue block12;
                }
                case 1: {
                    try {
                        Object dependent = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (dependent != null) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ObjectOutputStream os = new ObjectOutputStream(bos);
                            os.writeObject(dependent);
                            fields[i] = bos.toByteArray();
                            continue block12;
                        }
                        fields[i] = null;
                        continue block12;
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Error during serializing dependent object", e);
                    }
                }
                case 3: {
                    fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) continue block12;
                    fids = this.extractIdentityList(tx, fieldClassMolder, o);
                    fields[i] = fids;
                    continue block12;
                }
                case 4: {
                    fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) continue block12;
                    fids = this.extractIdentityList(tx, fieldClassMolder, o);
                    fields[i] = fids;
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Field type invalid!");
                }
            }
        }
        Object createdId = this._persistence.create(tx.getDatabase(), (Connection)tx.getConnection(oid.getLockEngine()), fields, ids);
        if (createdId == null) {
            throw new PersistenceException("Identity can't be created!");
        }
        locker.setObject(tx, fields);
        oid.setDbLock(true);
        if (object instanceof TimeStampable) {
            ((TimeStampable)object).jdoSetTimeStamp(locker.getTimeStamp());
        }
        this.setIdentity(tx, object, createdId);
        block13: for (i = 0; i < this._fhs.length; ++i) {
            fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 4: {
                    fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) continue block13;
                    fids = this.extractIdentityList(tx, fieldClassMolder, o);
                    fields[i] = fids;
                    Iterator itor = this.getIterator(o);
                    while (itor.hasNext()) {
                        Object oo = itor.next();
                        if (!tx.isPersistent(oo)) continue;
                        this._fhs[i].getRelationLoader().createRelation((Connection)tx.getConnection(oid.getLockEngine()), createdId, fieldClassMolder.getIdentity(tx, oo));
                    }
                    continue block13;
                }
            }
        }
        return createdId;
    }

    public void markCreate(TransactionContext tx, OID oid, DepositBox locker, Object object) throws DuplicateIdentityException, PersistenceException {
        boolean updateCache = false;
        block6: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: 
                case 1: {
                    continue block6;
                }
                case 2: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) continue block6;
                    if (this._fhs[i].isDependent()) {
                        if (!tx.isRecorded(o)) {
                            tx.markCreate(fieldEngine, fieldClassMolder, o, oid);
                            if (this._fhs[i].isStored() || !fieldClassMolder._isKeyGenUsed) continue block6;
                            updateCache = true;
                            continue block6;
                        }
                        if (tx.isDepended(oid, o)) continue block6;
                        throw new PersistenceException("Dependent object may not change its master. Object: " + o + " new master: " + oid);
                    }
                    if (!tx.isAutoStore() || tx.isRecorded(o)) continue block6;
                    tx.markCreate(fieldEngine, fieldClassMolder, o, null);
                    if (this._fhs[i].isStored() || !fieldClassMolder._isKeyGenUsed) continue block6;
                    updateCache = true;
                    continue block6;
                }
                case 3: {
                    Object oo;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) continue block6;
                    Iterator itor = this.getIterator(o);
                    while (itor.hasNext()) {
                        oo = itor.next();
                        if (this._fhs[i].isDependent()) {
                            if (!tx.isRecorded(oo)) {
                                tx.markCreate(fieldEngine, fieldClassMolder, oo, oid);
                                if (!fieldClassMolder._isKeyGenUsed) continue;
                                updateCache = true;
                                continue;
                            }
                            if (tx.isDepended(oid, oo)) continue;
                            throw new PersistenceException("Dependent object may not change its master");
                        }
                        if (!tx.isAutoStore() || tx.isRecorded(oo)) continue;
                        tx.markCreate(fieldEngine, fieldClassMolder, oo, null);
                        if (!fieldClassMolder._isKeyGenUsed) continue;
                        updateCache = true;
                    }
                    continue block6;
                }
                case 4: {
                    Object oo;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) continue block6;
                    Iterator itor = this.getIterator(o);
                    while (itor.hasNext()) {
                        oo = itor.next();
                        if (!tx.isAutoStore() || tx.isRecorded(oo)) continue;
                        tx.markCreate(fieldEngine, fieldClassMolder, oo, null);
                        updateCache = true;
                    }
                    continue block6;
                }
            }
        }
        tx.markModified(object, false, updateCache);
    }

    private boolean isEquals(Collection c1, Collection c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.containsAll(c2) && c2.containsAll(c1);
    }

    private static boolean isEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1 instanceof BigDecimal && ((BigDecimal)o1).compareTo(o2) == 0) {
            return true;
        }
        if (o1 instanceof Timestamp && o2 instanceof Timestamp) {
            Timestamp t1 = (Timestamp)o1;
            Timestamp t2 = (Timestamp)o2;
            return t1.getTime() == t2.getTime() && t1.getNanos() / 1000000 == t2.getNanos() / 1000000;
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        return false;
    }

    public boolean preStore(TransactionContext tx, OID oid, DepositBox locker, Object object, int timeout) throws PersistenceException {
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identity of the object to be stored is null");
        }
        if (!oid.getIdentity().equals(this.getIdentity(tx, object))) {
            throw new PersistenceException(Messages.format("jdo.identityChanged", this._name, oid.getIdentity(), this.getIdentity(tx, object)));
        }
        Object[] fields = (Object[])locker.getObject(tx);
        if (fields == null) {
            throw new PersistenceException("Object, " + oid + ",  isn't loaded in the persistence storage!");
        }
        Object[] newfields = new Object[this._fhs.length];
        boolean updateCache = false;
        boolean updatePersist = false;
        block11: for (int i = 0; i < newfields.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (ClassMolder.isEquals(fields[i], value)) continue block11;
                    if (this._fhs[i].isReadonly()) {
                        this._fhs[i].setValue(object, fields[i], tx.getClassLoader());
                        continue block11;
                    }
                    if (this._fhs[i].isStored()) {
                        updatePersist = true;
                    }
                    updateCache = true;
                    continue block11;
                }
                case 1: {
                    try {
                        byte[] bytes = (byte[])fields[i];
                        Object fieldValue = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (fieldValue == null && bytes == null) continue block11;
                        if (fieldValue == null || bytes == null) {
                            if (this._fhs[i].isStored()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                            continue block11;
                        }
                        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                        ObjectInputStream os = new ObjectInputStream(bis);
                        Object dependent = os.readObject();
                        if (dependent.equals(fieldValue)) continue block11;
                        if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                            updatePersist = true;
                        }
                        updateCache = true;
                        continue block11;
                    }
                    catch (OptionalDataException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                }
                case 2: {
                    Object deref;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (value != null) {
                        newfields[i] = fieldClassMolder.getIdentity(tx, value);
                    }
                    if (ClassMolder.isEquals(fields[i], newfields[i])) {
                        if (!this._debug || fields[i] == null) continue block11;
                        if (value != null && tx.isDeleted(value)) {
                            System.err.println("Warning: deleted object found!");
                            if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                            this._fhs[i].setValue(object, null, tx.getClassLoader());
                            continue block11;
                        }
                        if (!tx.isAutoStore() && !this._fhs[i].isDependent() || value == tx.fetch(fieldEngine, fieldClassMolder, fields[i], null)) continue block11;
                        throw new DuplicateIdentityException("");
                    }
                    if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                        updatePersist = true;
                    }
                    updateCache = true;
                    if (this._fhs[i].isDependent()) {
                        Object reldel;
                        if (fields[i] != null && (reldel = tx.fetch(fieldEngine, fieldClassMolder, fields[i], null)) != null) {
                            tx.delete(reldel);
                        }
                        if (value == null || tx.isRecorded(value)) continue block11;
                        tx.markCreate(fieldEngine, fieldClassMolder, value, oid);
                        continue block11;
                    }
                    if (tx.isAutoStore()) {
                        if (fields[i] != null && (deref = tx.fetch(fieldEngine, fieldClassMolder, fields[i], null)) != null) {
                            fieldClassMolder.removeRelation(tx, deref, this, object);
                        }
                        if (value == null || tx.isRecorded(value)) continue block11;
                        tx.markCreate(fieldEngine, fieldClassMolder, value, null);
                        continue block11;
                    }
                    if (fields[i] != null && (deref = tx.fetch(fieldEngine, fieldClassMolder, fields[i], null)) != null) {
                        fieldClassMolder.removeRelation(tx, deref, this, object);
                    }
                    if (value == null || tx.isRecorded(value)) continue block11;
                    throw new PersistenceException("Object, " + object + ", links to another object, " + value + " that is not loaded/updated/created in this transaction");
                }
                case 3: {
                    Object toBeAdded;
                    Iterator itor;
                    Iterator addedItor;
                    Collection added;
                    Object reldel;
                    Iterator removedItor;
                    Collection removed;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    ArrayList orgFields = (ArrayList)fields[i];
                    if (!(value instanceof Lazy)) {
                        removed = this.getRemovedIdsList(tx, orgFields, value, fieldClassMolder);
                        removedItor = removed.iterator();
                        if (removedItor.hasNext()) {
                            if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                        }
                        while (removedItor.hasNext()) {
                            Object removedId = removedItor.next();
                            reldel = tx.fetch(fieldEngine, fieldClassMolder, removedId, null);
                            if (reldel == null) continue;
                            if (this._fhs[i].isDependent()) {
                                tx.delete(reldel);
                                continue;
                            }
                            fieldClassMolder.removeRelation(tx, reldel, this, object);
                        }
                        added = this.getAddedValuesList(tx, orgFields, value, fieldClassMolder);
                        addedItor = added.iterator();
                        if (addedItor.hasNext()) {
                            if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                        }
                        while (addedItor.hasNext()) {
                            Object addedValue = addedItor.next();
                            if (this._fhs[i].isDependent()) {
                                if (tx.isRecorded(addedValue)) continue;
                                tx.markCreate(fieldEngine, fieldClassMolder, addedValue, oid);
                                continue;
                            }
                            if (!tx.isAutoStore() || tx.isRecorded(addedValue)) continue;
                            tx.markCreate(fieldEngine, fieldClassMolder, addedValue, null);
                        }
                        continue block11;
                    }
                    RelationCollection lazy = (RelationCollection)value;
                    tx.addTxSynchronizable(lazy);
                    ArrayList deleted = lazy.getDeleted();
                    if (!deleted.isEmpty()) {
                        if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                            updatePersist = true;
                        }
                        updateCache = true;
                        itor = deleted.iterator();
                        while (itor.hasNext()) {
                            updateCache = true;
                            Object toBeDeleted = lazy.find(itor.next());
                            if (toBeDeleted == null || !tx.isPersistent(toBeDeleted)) continue;
                            if (this._fhs[i].isDependent()) {
                                tx.delete(toBeDeleted);
                                continue;
                            }
                            fieldClassMolder.removeRelation(tx, toBeDeleted, this, object);
                        }
                    }
                    if (((ArrayList)(added = lazy.getAdded())).isEmpty()) continue block11;
                    if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                        updatePersist = true;
                    }
                    updateCache = true;
                    if (this._fhs[i].isDependent()) {
                        itor = ((ArrayList)added).iterator();
                        while (itor.hasNext()) {
                            toBeAdded = lazy.find(itor.next());
                            if (toBeAdded == null) continue;
                            tx.markCreate(fieldEngine, fieldClassMolder, toBeAdded, oid);
                        }
                        continue block11;
                    }
                    if (!tx.isAutoStore()) continue block11;
                    itor = ((ArrayList)added).iterator();
                    while (itor.hasNext()) {
                        toBeAdded = lazy.find(itor.next());
                        if (toBeAdded == null || tx.isRecorded(toBeAdded)) continue;
                        tx.markCreate(fieldEngine, fieldClassMolder, toBeAdded, null);
                    }
                    continue block11;
                }
                case 4: {
                    Iterator itor;
                    Iterator addedItor;
                    Collection added;
                    Object reldel;
                    Iterator removedItor;
                    Collection removed;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    ArrayList orgFields = (ArrayList)fields[i];
                    if (!(value instanceof Lazy)) {
                        removed = this.getRemovedIdsList(tx, orgFields, value, fieldClassMolder);
                        removedItor = removed.iterator();
                        if (removedItor.hasNext()) {
                            if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                        }
                        while (removedItor.hasNext()) {
                            Object id = removedItor.next();
                            if (tx.isDeletedByOID(new OID(fieldEngine, fieldClassMolder, id)) || (reldel = tx.load(fieldEngine, fieldClassMolder, id, null, null)) == null || !tx.isPersistent(reldel)) continue;
                            tx.writeLock(reldel, tx.getLockTimeout());
                            this._fhs[i].getRelationLoader().deleteRelation((Connection)tx.getConnection(oid.getLockEngine()), oid.getIdentity(), id);
                            fieldClassMolder.removeRelation(tx, reldel, this, object);
                        }
                        added = this.getAddedValuesList(tx, orgFields, value, fieldClassMolder);
                        addedItor = added.iterator();
                        if (addedItor.hasNext()) {
                            if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                        }
                        while (addedItor.hasNext()) {
                            Object addedField = addedItor.next();
                            tx.markModified(addedField, false, true);
                            if (tx.isPersistent(addedField)) {
                                this._fhs[i].getRelationLoader().createRelation((Connection)tx.getConnection(oid.getLockEngine()), oid.getIdentity(), fieldClassMolder.getIdentity(tx, addedField));
                                continue;
                            }
                            if (!tx.isAutoStore() || tx.isDeleted(addedField)) continue;
                            tx.markCreate(fieldEngine, fieldClassMolder, addedField, null);
                        }
                        continue block11;
                    }
                    RelationCollection lazy = (RelationCollection)value;
                    tx.addTxSynchronizable(lazy);
                    ArrayList deleted = lazy.getDeleted();
                    if (!deleted.isEmpty()) {
                        if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                            updatePersist = true;
                        }
                        updateCache = true;
                        itor = deleted.iterator();
                        while (itor.hasNext()) {
                            updateCache = true;
                            Object deletedId = itor.next();
                            Object toBeDeleted = lazy.find(deletedId);
                            if (toBeDeleted == null || !tx.isPersistent(toBeDeleted)) continue;
                            tx.writeLock(toBeDeleted, 0);
                            this._fhs[i].getRelationLoader().deleteRelation((Connection)tx.getConnection(oid.getLockEngine()), oid.getIdentity(), deletedId);
                            fieldClassMolder.removeRelation(tx, toBeDeleted, this, object);
                        }
                    }
                    if (((ArrayList)(added = lazy.getAdded())).isEmpty()) continue block11;
                    if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                        updatePersist = true;
                    }
                    updateCache = true;
                    itor = ((ArrayList)added).iterator();
                    while (itor.hasNext()) {
                        Object addedId = itor.next();
                        Object toBeAdded = lazy.find(addedId);
                        if (toBeAdded == null) continue;
                        if (tx.isPersistent(toBeAdded)) {
                            this._fhs[i].getRelationLoader().createRelation((Connection)tx.getConnection(oid.getLockEngine()), oid.getIdentity(), addedId);
                            continue;
                        }
                        if (!tx.isAutoStore() || tx.isRecorded(toBeAdded)) continue;
                        tx.markCreate(fieldEngine, fieldClassMolder, toBeAdded, null);
                    }
                    continue block11;
                }
            }
        }
        tx.markModified(object, updatePersist, updateCache);
        if (updateCache || updatePersist) {
            tx.writeLock(object, timeout);
        }
        return updateCache;
    }

    public void store(TransactionContext tx, OID oid, DepositBox locker, Object object) throws DuplicateIdentityException, PersistenceException, ObjectModifiedException, ObjectDeletedException {
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identities of the object to be stored is null");
        }
        if (!oid.getIdentity().equals(this.getIdentity(tx, object))) {
            throw new PersistenceException("Identities changes is not allowed!");
        }
        Object[] fields = (Object[])locker.getObject(tx);
        if (fields == null) {
            throw new PersistenceException("Object, " + oid + ",  isn't loaded in the persistence storage!");
        }
        Object[] newfields = new Object[this._fhs.length];
        block9: for (int i = 0; i < newfields.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: {
                    newfields[i] = this._fhs[i].getValue(object, tx.getClassLoader());
                    continue block9;
                }
                case 1: {
                    try {
                        Object dependent = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (dependent != null) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ObjectOutputStream os = new ObjectOutputStream(bos);
                            os.writeObject(dependent);
                            newfields[i] = bos.toByteArray();
                            continue block9;
                        }
                        newfields[i] = null;
                        continue block9;
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Error during serializing dependent object", e);
                    }
                }
                case 2: {
                    if (!this._fhs[i].isStored()) continue block9;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (value == null) continue block9;
                    newfields[i] = fieldClassMolder.getIdentity(tx, value);
                    continue block9;
                }
                case 3: {
                    continue block9;
                }
                case 4: {
                    continue block9;
                }
            }
        }
        Object stamp = this._persistence.store(tx.getConnection(oid.getLockEngine()), newfields, oid.getIdentity(), fields, oid.getStamp());
        oid.setStamp(stamp);
    }

    private Collection getAddedValuesList(TransactionContext tx, ArrayList orgIds, Object collection, ClassMolder ch) {
        if (collection == null) {
            return new ArrayList(0);
        }
        if (collection instanceof Map) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                return ((Map)collection).values();
            }
            Map newMap = (Map)collection;
            ArrayList added = new ArrayList(newMap.size());
            Iterator newItor = newMap.entrySet().iterator();
            while (newItor.hasNext()) {
                Map.Entry newId = newItor.next();
                if (orgIds.contains(newId.getKey())) continue;
                added.add(newId.getValue());
            }
            return added;
        }
        if (collection instanceof Collection) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                return (Collection)collection;
            }
            if (collection == null) {
                return new ArrayList(0);
            }
            Collection newValues = (Collection)collection;
            ArrayList added = new ArrayList(newValues.size());
            Iterator newItor = newValues.iterator();
            while (newItor.hasNext()) {
                Object newValue = newItor.next();
                Object newId = ch.getIdentity(tx, newValue);
                if (newId != null && orgIds.contains(newId)) continue;
                added.add(newValue);
            }
            return added;
        }
        if (collection.getClass().isArray()) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                Object[] newValues = (Object[])collection;
                ArrayList<Object> result = new ArrayList<Object>(newValues.length);
                for (int i = 0; i < newValues.length; ++i) {
                    result.add(newValues[i]);
                }
                return result;
            }
            if (collection == null) {
                return new ArrayList(0);
            }
            Object[] newValues = (Object[])collection;
            ArrayList<Object> added = new ArrayList<Object>(newValues.length);
            for (int i = 0; i < newValues.length; ++i) {
                Object newValue = newValues[i];
                Object newId = ch.getIdentity(tx, newValue);
                if (newId != null && orgIds.contains(newId)) continue;
                added.add(newValue);
            }
            return added;
        }
        throw new IllegalArgumentException("Collection type " + collection.getClass().getName() + " is not supported!");
    }

    private Collection getRemovedIdsList(TransactionContext tx, ArrayList orgIds, Object collection, ClassMolder ch) {
        if (collection == null) {
            if (orgIds == null) {
                return new ArrayList(0);
            }
            return orgIds;
        }
        if (collection instanceof Map) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Map newMap = (Map)collection;
            Iterator orgItor = orgIds.iterator();
            ArrayList removed = new ArrayList(orgIds.size());
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        if (collection instanceof Collection) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Collection newCol = (Collection)collection;
            Iterator orgItor = orgIds.iterator();
            ArrayList removed = new ArrayList(0);
            HashMap newMap = new HashMap();
            Iterator newColItor = newCol.iterator();
            while (newColItor.hasNext()) {
                Object newObject = newColItor.next();
                Object newId = ch.getIdentity(tx, newObject);
                if (newId == null) continue;
                newMap.put(newId, newObject);
            }
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        if (collection.getClass().isArray()) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Object[] newCol = (Object[])collection;
            Iterator orgItor = orgIds.iterator();
            ArrayList removed = new ArrayList(0);
            HashMap<Object, Object> newMap = new HashMap<Object, Object>();
            for (int i = 0; i < newCol.length; ++i) {
                Object newObject = newCol[i];
                Object newId = ch.getIdentity(tx, newObject);
                if (newId == null) continue;
                newMap.put(newId, newObject);
            }
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        throw new IllegalArgumentException("Collection type " + collection.getClass().getName() + " is not supported!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public boolean update(TransactionContext tx, OID oid, DepositBox locker, Object object, AccessMode suggestedAccessMode) throws PersistenceException, ObjectModifiedException {
        long objectTimestamp;
        AccessMode accessMode = this.getAccessMode(suggestedAccessMode);
        Object[] fields = (Object[])locker.getObject(tx);
        if (!this.isDependent() && !this._timeStampable) {
            throw new IllegalArgumentException("A master object that involves in a long transaction must be a TimeStampable!");
        }
        long lockTimestamp = locker.getTimeStamp();
        long l = objectTimestamp = this._timeStampable ? ((TimeStampable)object).jdoGetTimeStamp() : 1L;
        if (objectTimestamp > 0L && oid.getIdentity() != null) {
            if (this._timeStampable && objectTimestamp != lockTimestamp) {
                throw new ObjectModifiedException("Timestamp mismatched!");
            }
            if (!this._timeStampable && this.isDependent() && fields == null) {
                fields = new Object[this._fhs.length];
                Connection conn = (Connection)tx.getConnection(oid.getLockEngine());
                Object stamp = this._persistence.load(conn, fields, oid.getIdentity(), accessMode);
                oid.setDbLock(accessMode == AccessMode.DbLocked);
                locker.setObject(tx, fields);
            }
            try {
                int i = 0;
                while (i < this._fhs.length) {
                    short fieldType = this._fhs[i].getFieldType();
                    switch (fieldType) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                            LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                            Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                            if (this._fhs[i].isDependent()) {
                                if (o != null && !tx.isRecorded(o)) {
                                    tx.markUpdate(fieldEngine, fieldClassMolder, o, oid);
                                }
                                if (fields[i] == null) break;
                                tx.load(fieldEngine, fieldClassMolder, fields[i], null, suggestedAccessMode);
                                break;
                            }
                            if (!tx.isAutoStore()) break;
                            if (o != null && !tx.isRecorded(o)) {
                                tx.markUpdate(fieldEngine, fieldClassMolder, o, null);
                            }
                            if (fields[i] == null) break;
                            tx.load(fieldEngine, fieldClassMolder, fields[i], null, suggestedAccessMode);
                            break;
                        }
                        case 3: {
                            ArrayList<Object> newSetOfIds;
                            ArrayList v;
                            Iterator itor;
                            ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                            LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                            if (this._fhs[i].isDependent()) {
                                if (!this._fhs[i].isLazy()) {
                                    itor = this.getIterator(this._fhs[i].getValue(object, tx.getClassLoader()));
                                    v = (ArrayList)fields[i];
                                    newSetOfIds = new ArrayList();
                                    while (itor.hasNext()) {
                                        Object element = itor.next();
                                        Object actualIdentity = fieldClassMolder.getActualIdentity(tx, element);
                                        newSetOfIds.add(actualIdentity);
                                        if (v == null || !v.contains(actualIdentity) || tx.isRecorded(element)) continue;
                                        tx.markUpdate(fieldEngine, fieldClassMolder, element, oid);
                                    }
                                    if (v == null) break;
                                    int l2 = v.size();
                                    for (int j = 0; j < l2; ++j) {
                                        if (newSetOfIds.contains(v.get(j))) continue;
                                        tx.load(oid.getLockEngine(), fieldClassMolder, v.get(j), null, suggestedAccessMode);
                                    }
                                    break;
                                } else {
                                    fieldClassMolder = this._fhs[i].getFieldClassMolder();
                                    fieldEngine = this._fhs[i].getFieldLockEngine();
                                    break;
                                }
                            }
                            if (!tx.isAutoStore()) break;
                            itor = this.getIterator(this._fhs[i].getValue(object, tx.getClassLoader()));
                            v = (ArrayList)fields[i];
                            newSetOfIds = new ArrayList();
                            while (itor.hasNext()) {
                                Object element = itor.next();
                                Object actualIdentity = fieldClassMolder.getActualIdentity(tx, element);
                                newSetOfIds.add(actualIdentity);
                                if (v != null && v.contains(actualIdentity)) {
                                    if (tx.isRecorded(element)) continue;
                                    tx.markUpdate(fieldEngine, fieldClassMolder, element, null);
                                    continue;
                                }
                                if (tx.isRecorded(element)) continue;
                                tx.markUpdate(fieldEngine, fieldClassMolder, element, null);
                            }
                            if (v == null) break;
                            int l3 = v.size();
                            for (int j = 0; j < l3; ++j) {
                                if (newSetOfIds.contains(v.get(j))) continue;
                                tx.load(oid.getLockEngine(), fieldClassMolder, v.get(j), null, suggestedAccessMode);
                            }
                            break;
                        }
                        case 4: {
                            ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                            LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                            if (!tx.isAutoStore()) break;
                            Iterator itor = this.getIterator(this._fhs[i].getValue(object, tx.getClassLoader()));
                            ArrayList v = (ArrayList)fields[i];
                            ArrayList<Object> newSetOfIds = new ArrayList<Object>();
                            while (itor.hasNext()) {
                                Object element = itor.next();
                                Object actualIdentity = fieldClassMolder.getActualIdentity(tx, element);
                                newSetOfIds.add(actualIdentity);
                                if (v != null && v.contains(actualIdentity)) {
                                    if (tx.isRecorded(element)) continue;
                                    tx.markUpdate(fieldEngine, fieldClassMolder, element, null);
                                    continue;
                                }
                                if (tx.isRecorded(element)) continue;
                                tx.markUpdate(fieldEngine, fieldClassMolder, element, null);
                            }
                            if (v == null) break;
                            int l4 = v.size();
                            for (int j = 0; j < l4; ++j) {
                                if (newSetOfIds.contains(v.get(j))) continue;
                                tx.load(oid.getLockEngine(), fieldClassMolder, v.get(j), null, suggestedAccessMode);
                            }
                            break;
                        }
                    }
                    ++i;
                }
                return false;
            }
            catch (ObjectNotFoundException e) {
                e.printStackTrace();
                throw new ObjectModifiedException("dependent object deleted concurrently");
            }
        }
        if (objectTimestamp != 0L && objectTimestamp != 1L) {
            System.err.println("object: " + object + " timestamp: " + objectTimestamp + "lockertimestamp: " + lockTimestamp);
            throw new ObjectModifiedException("Invalid object timestamp detected.");
        }
        boolean updateCache = false;
        int i = 0;
        while (true) {
            if (i >= this._fhs.length) {
                tx.markModified(object, false, updateCache);
                return true;
            }
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    boolean creating;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) break;
                    if (this._fhs[i].isDependent()) {
                        if (tx.isRecorded(o)) break;
                        tx.markCreate(fieldEngine, fieldClassMolder, o, oid);
                        if (this._fhs[i].isStored() || !fieldClassMolder._isKeyGenUsed) break;
                        updateCache = true;
                        break;
                    }
                    if (!tx.isAutoStore() || tx.isRecorded(o) || !(creating = tx.markUpdate(fieldEngine, fieldClassMolder, o, null)) || this._fhs[i].isStored() || !fieldClassMolder._isKeyGenUsed) break;
                    updateCache = true;
                    break;
                }
                case 3: {
                    boolean creating;
                    Object oo;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) break;
                    Iterator itor = this.getIterator(o);
                    while (itor.hasNext()) {
                        oo = itor.next();
                        if (this._fhs[i].isDependent()) {
                            if (!tx.isRecorded(oo)) {
                                tx.markCreate(fieldEngine, fieldClassMolder, oo, oid);
                                if (!fieldClassMolder._isKeyGenUsed) continue;
                                updateCache = true;
                                continue;
                            }
                            if (tx.isDepended(oid, oo)) continue;
                            throw new PersistenceException("Dependent object may not change its master");
                        }
                        if (!tx.isAutoStore() || tx.isRecorded(oo) || !(creating = tx.markUpdate(fieldEngine, fieldClassMolder, oo, null)) || !fieldClassMolder._isKeyGenUsed) continue;
                        updateCache = true;
                    }
                    break;
                }
                case 4: {
                    boolean creating;
                    Object oo;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) break;
                    Iterator itor = this.getIterator(o);
                    while (itor.hasNext()) {
                        oo = itor.next();
                        if (!tx.isAutoStore() || tx.isRecorded(oo) || !(creating = tx.markUpdate(fieldEngine, fieldClassMolder, oo, null))) continue;
                        updateCache = true;
                    }
                    break;
                }
            }
            ++i;
        }
    }

    public void updateCache(TransactionContext tx, OID oid, DepositBox locker, Object object) {
        Object[] fields = new Object[this._fhs.length];
        if (oid.getIdentity() == null) {
            throw new IllegalStateException("The identities of the cache to be updated is null");
        }
        block9: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: {
                    fields[i] = this._fhs[i].getValue(object, tx.getClassLoader());
                    continue block9;
                }
                case 1: {
                    try {
                        Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (o != null) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ObjectOutputStream os = new ObjectOutputStream(bos);
                            os.writeObject(o);
                            fields[i] = bos.toByteArray();
                            continue block9;
                        }
                        fields[i] = null;
                    }
                    catch (IOException e) {}
                    continue block9;
                }
                case 2: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (value != null) {
                        Object fid = fieldClassMolder.getIdentity(tx, value);
                        if (fid == null) continue block9;
                        fields[i] = fid;
                        continue block9;
                    }
                    fields[i] = null;
                    continue block9;
                }
                case 3: {
                    RelationCollection lazy;
                    ArrayList fids;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (value != null) {
                        if (!(value instanceof Lazy)) {
                            fids = this.extractIdentityList(tx, fieldClassMolder, value);
                            fields[i] = fids;
                            continue block9;
                        }
                        lazy = (RelationCollection)value;
                        fids = (ArrayList)lazy.getIdentitiesList().clone();
                        fields[i] = fids;
                        continue block9;
                    }
                    fields[i] = null;
                    continue block9;
                }
                case 4: {
                    RelationCollection lazy;
                    ArrayList fids;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (value != null) {
                        if (!(value instanceof Lazy)) {
                            fids = this.extractIdentityList(tx, fieldClassMolder, value);
                            fields[i] = fids;
                            continue block9;
                        }
                        lazy = (RelationCollection)value;
                        fids = (ArrayList)lazy.getIdentitiesList().clone();
                        fields[i] = fids;
                        continue block9;
                    }
                    fields[i] = null;
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Field type invalid!");
                }
            }
        }
        locker.setObject(tx, fields);
        if (object instanceof TimeStampable) {
            ((TimeStampable)object).jdoSetTimeStamp(locker.getTimeStamp());
        }
    }

    private static void deleteExtend(TransactionContext tx, ClassMolder extend, Object identity) throws ObjectNotFoundException, PersistenceException {
        Object[] persistFields = null;
        for (int i = 0; i < extend._fhs.length; ++i) {
            if (extend._fhs[i].isDependent()) {
                try {
                    if (persistFields == null) {
                        persistFields = new Object[extend._fhs.length];
                        extend._persistence.load((Connection)tx.getConnection(extend._engine), persistFields, identity, AccessMode.ReadOnly);
                    }
                    if (!extend._fhs[i].isMulti()) continue;
                    ArrayList listOfIds = (ArrayList)persistFields[i];
                    int j = 0;
                    while (i < listOfIds.size()) {
                        extend._persistence.delete(tx.getConnection(extend._fhs[i].getFieldLockEngine()), listOfIds.get(j));
                        ++j;
                    }
                    continue;
                }
                catch (ObjectNotFoundException e) {
                    _log.warn((Object)"Could not find object", (Throwable)e);
                    continue;
                }
            }
            if (!extend._fhs[i].isManyToMany()) continue;
            extend._fhs[i].getRelationLoader().deleteRelation((Connection)tx.getConnection(extend._fhs[i].getFieldLockEngine()), identity);
        }
    }

    public void delete(TransactionContext tx, OID oid) throws PersistenceException {
        int i;
        Object ids = oid.getIdentity();
        for (int i2 = 0; i2 < this._fhs.length; ++i2) {
            if (!this._fhs[i2].isManyToMany()) continue;
            this._fhs[i2].getRelationLoader().deleteRelation((Connection)tx.getConnection(oid.getLockEngine()), ids);
        }
        this._persistence.delete((Connection)tx.getConnection(oid.getLockEngine()), ids);
        Vector<ClassMolder> extendPath = new Vector<ClassMolder>();
        ClassMolder base = this;
        while (base != null) {
            extendPath.add(base);
            base = base._extends;
        }
        base = this._depends;
        while (base != null) {
            if (base._extendent != null) {
                for (i = 0; i < base._extendent.size(); ++i) {
                    if (extendPath.contains(base._extendent.get(i))) continue;
                }
            }
            base = base._extends;
        }
        if (this._extendent != null) {
            for (i = 0; i < this._extendent.size(); ++i) {
                if (extendPath.contains(this._extendent.get(i))) continue;
            }
        }
    }

    public void markDelete(TransactionContext tx, OID oid, DepositBox locker, Object object) throws ObjectNotFoundException, PersistenceException {
        Object[] fields = (Object[])locker.getObject(tx);
        block6: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: 
                case 1: {
                    continue block6;
                }
                case 2: {
                    Object fobject;
                    Object fid;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    if (this._fhs[i].isDependent()) {
                        fid = fields[i];
                        Object fetched = null;
                        if (fid != null && (fetched = tx.fetch(fieldEngine, fieldClassMolder, fid, null)) != null) {
                            tx.delete(fetched);
                        }
                        if ((fobject = this._fhs[i].getValue(object, tx.getClassLoader())) == null || !tx.isPersistent(fobject)) continue block6;
                        tx.delete(fobject);
                        continue block6;
                    }
                    fid = fields[i];
                    Object fetched = null;
                    if (fid == null || (fetched = tx.fetch(fieldEngine, fieldClassMolder, fields[i], null)) == null) continue block6;
                    fieldClassMolder.removeRelation(tx, fetched, this, object);
                    continue block6;
                }
                case 3: {
                    Object fetched;
                    Object fid;
                    ArrayList alist;
                    Object fobject;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    if (this._fhs[i].isDependent()) {
                        alist = (ArrayList)fields[i];
                        if (fields[i] == null) continue block6;
                        for (int j = 0; j < alist.size(); ++j) {
                            fid = alist.get(j);
                            fetched = null;
                            if (fid == null || (fetched = tx.fetch(fieldEngine, fieldClassMolder, fid, null)) == null) continue;
                            tx.delete(fetched);
                        }
                        Iterator itor = this.getIterator(this._fhs[i].getValue(object, tx.getClassLoader()));
                        while (itor.hasNext()) {
                            fobject = itor.next();
                            if (fobject == null || !tx.isPersistent(fobject)) continue;
                            tx.delete(fobject);
                        }
                        continue block6;
                    }
                    if (fields[i] == null) continue block6;
                    alist = (ArrayList)fields[i];
                    for (int j = 0; j < alist.size(); ++j) {
                        fid = alist.get(j);
                        fetched = null;
                        if (fid == null || (fetched = tx.fetch(fieldEngine, fieldClassMolder, fid, null)) == null) continue;
                        fieldClassMolder.removeRelation(tx, fetched, this, object);
                    }
                    Iterator itor = this.getIterator(this._fhs[i].getValue(object, tx.getClassLoader()));
                    while (itor.hasNext()) {
                        fobject = itor.next();
                        if (fobject == null || !tx.isPersistent(fobject)) continue;
                        fieldClassMolder.removeRelation(tx, fobject, this, object);
                    }
                    continue block6;
                }
                case 4: {
                    Object fetched;
                    Object fid;
                    ArrayList alist;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    if (fields[i] != null) {
                        alist = (ArrayList)fields[i];
                        for (int j = 0; j < alist.size(); ++j) {
                            fid = alist.get(j);
                            fetched = null;
                            if (fid == null || (fetched = tx.fetch(fieldEngine, fieldClassMolder, fid, null)) == null) continue;
                            fieldClassMolder.removeRelation(tx, fetched, this, object);
                        }
                    }
                    Iterator itor = this.getIterator(this._fhs[i].getValue(object, tx.getClassLoader()));
                    while (itor.hasNext()) {
                        Object fobject = itor.next();
                        if (fobject == null || !tx.isPersistent(fobject)) continue;
                        fieldClassMolder.removeRelation(tx, fobject, this, object);
                    }
                    continue block6;
                }
                default: {
                    throw new PersistenceException("Invalid field type!");
                }
            }
        }
    }

    public void revertObject(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identities of the object to be revert is null");
        }
        Object[] fields = (Object[])locker.getObject(tx);
        this.setIdentity(tx, object, oid.getIdentity());
        block10: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: {
                    Object temp = fields[i];
                    this._fhs[i].setValue(object, temp, tx.getClassLoader());
                    continue block10;
                }
                case 1: {
                    try {
                        byte[] bytes = (byte[])fields[i];
                        if (bytes != null) {
                            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                            ObjectInputStream os = new ObjectInputStream(bis);
                            Object o = os.readObject();
                            this._fhs[i].setValue(object, o, tx.getClassLoader());
                            continue block10;
                        }
                        this._fhs[i].setValue(object, null, tx.getClassLoader());
                        continue block10;
                    }
                    catch (OptionalDataException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                }
                case 2: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    if (fields[i] != null) {
                        Object value = tx.fetch(fieldEngine, fieldClassMolder, fields[i], null);
                        this._fhs[i].setValue(object, value, tx.getClassLoader());
                        continue block10;
                    }
                    this._fhs[i].setValue(object, null, tx.getClassLoader());
                    continue block10;
                }
                case 3: 
                case 4: {
                    LockEngine fieldEngine;
                    ClassMolder fieldClassMolder;
                    Object o = fields[i];
                    if (o == null) {
                        this._fhs[i].setValue(object, null, tx.getClassLoader());
                        continue block10;
                    }
                    if (!this._fhs[i].isLazy()) {
                        fieldClassMolder = this._fhs[i].getFieldClassMolder();
                        fieldEngine = this._fhs[i].getFieldLockEngine();
                        Class collectionType = this._fhs[i].getCollectionType();
                        ArrayList v = (ArrayList)fields[i];
                        if (v != null) {
                            int j;
                            int l;
                            if (collectionType.isArray()) {
                                Object[] arrayValue = (Object[])Array.newInstance(collectionType.getComponentType(), v.size());
                                l = v.size();
                                for (j = 0; j < l; ++j) {
                                    arrayValue[j] = tx.fetch(oid.getLockEngine(), fieldClassMolder, v.get(j), null);
                                }
                                this._fhs[i].setValue(object, arrayValue, tx.getClassLoader());
                                continue block10;
                            }
                            CollectionProxy cp = CollectionProxy.create(this._fhs[i], object, tx.getClassLoader());
                            this._fhs[i].setValue(object, cp.getCollection(), tx.getClassLoader());
                            l = v.size();
                            for (j = 0; j < l; ++j) {
                                cp.add(v.get(j), tx.fetch(oid.getLockEngine(), fieldClassMolder, v.get(j), null));
                            }
                            cp.close();
                            continue block10;
                        }
                        this._fhs[i].setValue(object, null, tx.getClassLoader());
                        continue block10;
                    }
                    ArrayList list = (ArrayList)fields[i];
                    fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    fieldEngine = this._fhs[i].getFieldLockEngine();
                    RelationCollection relcol = new RelationCollection(tx, oid, fieldEngine, fieldClassMolder, null, list);
                    this._fhs[i].setValue(object, relcol, tx.getClassLoader());
                    continue block10;
                }
            }
        }
    }

    public void writeLock(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
    }

    public Object newInstance(ClassLoader loader) {
        try {
            if (loader != null) {
                return loader.loadClass(this._name).newInstance();
            }
            return Class.forName(this._name).newInstance();
        }
        catch (ClassNotFoundException e) {
            _log.warn((Object)e);
        }
        catch (IllegalAccessException e) {
            _log.warn((Object)e);
        }
        catch (InstantiationException e) {
            _log.warn((Object)e);
        }
        catch (ExceptionInInitializerError e) {
            _log.warn((Object)e);
        }
        catch (SecurityException e) {
            _log.warn((Object)e);
        }
        return null;
    }

    public AccessMode getAccessMode(AccessMode txMode) {
        if (txMode == null) {
            return this._accessMode;
        }
        if (this._accessMode == AccessMode.ReadOnly || txMode == AccessMode.ReadOnly) {
            return AccessMode.ReadOnly;
        }
        if (this._accessMode == AccessMode.DbLocked || txMode == AccessMode.DbLocked) {
            return AccessMode.DbLocked;
        }
        if (this._accessMode == AccessMode.Exclusive || txMode == AccessMode.Exclusive) {
            return AccessMode.Exclusive;
        }
        return txMode;
    }

    public CallbackInterceptor getCallback() {
        return this._callback;
    }

    public boolean isDefaultIdentity(Object identity) {
        if (this._ids.length == 1) {
            return this._ids[0].isDefault(identity);
        }
        if (identity == null) {
            return true;
        }
        Complex c = (Complex)identity;
        for (int i = 0; i < c.size(); ++i) {
            if (this._ids[i].isDefault(c.get(i))) continue;
            return false;
        }
        return true;
    }

    public Object getIdentity(TransactionContext tx, Object o) {
        if (this.isKeyGeneratorUsed() && !tx.isPersistent(o) && !tx.isReadOnly(o)) {
            return null;
        }
        return this.getActualIdentity(tx, o);
    }

    public Object getActualIdentity(TransactionContext tx, Object o) {
        return this.getActualIdentity(tx.getClassLoader(), o);
    }

    public Object getActualIdentity(ClassLoader loader, Object o) {
        if (this._ids.length == 1) {
            return this._ids[0].getValue(o, loader);
        }
        if (this._ids.length == 2) {
            Object temp = this._ids[0].getValue(o, loader);
            return temp == null ? null : new Complex(temp, this._ids[1].getValue(o, loader));
        }
        Object[] osIds = new Object[this._ids.length];
        for (int i = 0; i < osIds.length; ++i) {
            osIds[i] = this._ids[i].getValue(o, loader);
        }
        if (osIds[0] == null) {
            return null;
        }
        return new Complex(osIds);
    }

    public void setIdentity(TransactionContext tx, Object object, Object identity) throws PersistenceException {
        if (this._ids.length > 1) {
            if (identity instanceof Complex) {
                Complex com = (Complex)identity;
                if (com.size() != this._ids.length) {
                    throw new PersistenceException("Complex size mismatched!");
                }
                for (int i = 0; i < this._ids.length; ++i) {
                    this._ids[i].setValue(object, com.get(i), tx.getClassLoader());
                }
            }
        } else {
            if (identity instanceof Complex) {
                throw new PersistenceException("Complex type not accepted!");
            }
            this._ids[0].setValue(object, identity, tx.getClassLoader());
        }
    }

    public Persistence getPersistence() {
        return this._persistence;
    }

    public void setPersistence(Persistence persist) {
        this._persistence = persist;
    }

    public Class getJavaClass(ClassLoader loader) {
        Class<?> result = null;
        try {
            result = loader != null ? loader.loadClass(this._name) : Class.forName(this._name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isAssignableFrom(Class cls) {
        ClassLoader loader = cls.getClassLoader();
        Class<?> molderClass = null;
        try {
            molderClass = loader != null ? loader.loadClass(this._name) : Class.forName(this._name);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return molderClass.isAssignableFrom(cls);
    }

    public String getName() {
        return this._name;
    }

    public FieldMolder[] getFields() {
        return this._fhs;
    }

    public FieldMolder[] getIds() {
        return this._ids;
    }

    public ClassMolder getExtends() {
        return this._extends;
    }

    public ClassMolder getDepends() {
        return this._depends;
    }

    public LockEngine getLockEngine() {
        return this._engine;
    }

    public String getCacheType() {
        return this._cachetype;
    }

    public int getCacheParam() {
        return this._cacheparam;
    }

    public boolean isDependent() {
        return this._depends != null;
    }

    public void setFieldsNull(Object object) {
    }

    void addExtendent(ClassMolder ext) {
        if (this._extendent == null) {
            this._extendent = new Vector();
        }
        this._extendent.add(ext);
    }

    void addDependent(ClassMolder dep) {
        if (this._dependent == null) {
            this._dependent = new Vector();
        }
        this._dependent.add(dep);
    }

    void setExtends(ClassMolder ext) {
        this._extends = ext;
        ext.addExtendent(this);
    }

    void setDepends(ClassMolder dep) {
        this._depends = dep;
        dep.addDependent(this);
    }

    private Iterator getIterator(Object o) {
        if (o == null) {
            return new Iterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (o instanceof Collection) {
            return ((Collection)o).iterator();
        }
        if (o instanceof Map) {
            return ((Map)o).values().iterator();
        }
        if (o.getClass().isArray()) {
            final class ArrayIterator
            implements Iterator {
                Object[] array;
                int i = 0;

                ArrayIterator(Object[] array) {
                    this.array = array;
                }

                public boolean hasNext() {
                    return this.i < this.array.length;
                }

                public Object next() {
                    return this.array[this.i++];
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new ArrayIterator((Object[])o);
        }
        throw new IllegalArgumentException();
    }

    private ArrayList extractIdentityList(TransactionContext tx, ClassMolder molder, Object col) {
        if (col == null) {
            return new ArrayList();
        }
        if (col instanceof Collection) {
            ArrayList<Object> idList = new ArrayList<Object>();
            Iterator itor = ((Collection)col).iterator();
            while (itor.hasNext()) {
                Object id = molder.getIdentity(tx, itor.next());
                if (id == null) continue;
                idList.add(id);
            }
            return idList;
        }
        if (col instanceof Map) {
            ArrayList idList = new ArrayList();
            Iterator itor = ((Map)col).keySet().iterator();
            while (itor.hasNext()) {
                idList.add(itor.next());
            }
            return idList;
        }
        if (col.getClass().isArray()) {
            ArrayList<Object> idList = new ArrayList<Object>();
            Object[] arrayCol = (Object[])col;
            for (int i = 0; i < arrayCol.length; ++i) {
                Object id = molder.getIdentity(tx, arrayCol[i]);
                if (id == null) continue;
                idList.add(id);
            }
            return idList;
        }
        throw new IllegalArgumentException("A Collection or Map is expected!");
    }

    public String toString() {
        return "ClassMolder " + this._name;
    }

    public boolean isKeyGeneratorUsed() {
        return this._isKeyGenUsed || this._extends != null && this._extends.isKeyGeneratorUsed();
    }

    public void expireCache(TransactionContext tx, ObjectLock locker) throws PersistenceException {
        if (locker == null) {
            return;
        }
        Object[] fields = (Object[])locker.getObject();
        if (fields == null) {
            return;
        }
        block6: for (int i = 0; i < this._fhs.length; ++i) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    continue block6;
                }
                case 2: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    if (fields[i] == null) continue block6;
                    tx.expireCache(fieldEngine, fieldClassMolder, fields[i]);
                    continue block6;
                }
                case 3: 
                case 4: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    ArrayList v = (ArrayList)fields[i];
                    if (v == null) continue block6;
                    int l = v.size();
                    for (int j = 0; j < l; ++j) {
                        tx.expireCache(fieldEngine, fieldClassMolder, v.get(j));
                    }
                    continue block6;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

