/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.filechooser;

import com.googlecode.vfsjfilechooser2.utils.SwingCommonsUtilities;
import com.googlecode.vfsjfilechooser2.utils.VFSResources;
import com.googlecode.vfsjfilechooser2.utils.VFSUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.DecoratedFileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;

public abstract class AbstractVFSFileSystemView {
    static AbstractVFSFileSystemView genericFileSystemView = null;
    static boolean useSystemExtensionsHiding = false;
    FileObject[] localRoots = new FileObject[0];

    public static AbstractVFSFileSystemView getFileSystemView() {
        useSystemExtensionsHiding = UIManager.getDefaults().getBoolean("FileChooser.useSystemExtensionHiding");
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("lookAndFeel")) {
                    useSystemExtensionsHiding = UIManager.getDefaults().getBoolean("FileChooser.useSystemExtensionHiding");
                }
            }
        });
        if (genericFileSystemView == null) {
            genericFileSystemView = new GenericFileSystemView();
        }
        return genericFileSystemView;
    }

    public boolean isRoot(FileObject f) {
        return VFSUtils.isRoot(f);
    }

    public Boolean isTraversable(FileObject f) {
        return VFSUtils.isDirectory(f);
    }

    public String getSystemDisplayName(FileObject f) {
        String name = null;
        if (f != null && !(name = f.getName().getBaseName()).trim().equals("")) {
            name = VFSUtils.getFriendlyName(f.getName() + "");
        }
        return name;
    }

    public String getSystemTypeDescription(FileObject f) {
        return VFSUtils.getFriendlyName(f.getName().toString());
    }

    public Icon getSystemIcon(FileObject f) {
        if (f != null) {
            return UIManager.getIcon(VFSUtils.isDirectory(f) ? "FileView.directoryIcon" : "FileView.fileIcon");
        }
        return null;
    }

    public boolean isParent(FileObject folder, FileObject file) {
        return VFSUtils.isParent(folder, file);
    }

    public FileObject getChild(FileObject parent, String fileName) {
        return this.createFileObject(parent, fileName);
    }

    public boolean isFileSystem(FileObject f) {
        return true;
    }

    public abstract FileObject createNewFolder(FileObject var1) throws FileSystemException;

    public boolean isHiddenFile(FileObject f) {
        return VFSUtils.isHiddenFile(f);
    }

    public boolean isFileSystemRoot(FileObject dir) {
        return VFSUtils.isRoot(dir);
    }

    public boolean isDrive(FileObject dir) {
        return VFSUtils.getParentDirectory(dir) == null;
    }

    public boolean isFloppyDrive(FileObject dir) {
        return false;
    }

    public boolean isComputerNode(FileObject dir) {
        return false;
    }

    public FileObject[] getRoots(FileObject fo) {
        if (fo instanceof DecoratedFileObject) {
            fo = ((DecoratedFileObject)fo).getDecoratedFileObject();
        }
        if (fo instanceof LocalFile) {
            File[] roots = File.listRoots();
            int count = roots.length;
            this.localRoots = new FileObject[roots.length];
            for (int i = 0; i < count; ++i) {
                this.localRoots[i] = VFSUtils.toFileObject(roots[i]);
            }
            return (FileObject[])this.localRoots.clone();
        }
        FileObject p = VFSUtils.getRootFileSystem(fo);
        return new FileObject[]{p};
    }

    public FileObject getHomeDirectory() {
        return SwingCommonsUtilities.getVFSFileChooserDefaultDirectory();
    }

    public FileObject getDefaultDirectory() {
        return this.createFileObject(System.getProperty("user.dir"));
    }

    public FileObject createFileObject(FileObject dir, String filename) {
        if (dir == null) {
            return VFSUtils.createFileObject(filename);
        }
        return VFSUtils.resolveFileObject(dir, filename);
    }

    public FileObject createFileObject(String path) {
        return VFSUtils.resolveFileObject(path);
    }

    public FileObject[] getFiles(FileObject dir, boolean useFileHiding) {
        return VFSUtils.getFiles(dir, useFileHiding);
    }

    public FileObject getParentDirectory(FileObject dir) {
        if (dir != null && VFSUtils.exists(dir)) {
            FileObject parentDir = VFSUtils.getParentDirectory(dir);
            if (parentDir == null) {
                return dir;
            }
            return parentDir;
        }
        return null;
    }

    protected FileObject createFileSystemRoot(FileObject f) {
        return VFSUtils.createFileSystemRoot(f);
    }

    static class GenericFileSystemView
    extends AbstractVFSFileSystemView {
        private static final String newFolderString = VFSResources.getMessage("VFSJFileChooser.other.newFolder");
        private static final String newFolderNextString = VFSResources.getMessage("VFSJFileChooser.other.newFolder.subsequent");

        GenericFileSystemView() {
        }

        @Override
        public FileObject createNewFolder(FileObject containingDir) throws FileSystemException {
            if (containingDir == null) {
                throw new FileSystemException("Trying to create a new folder into a non existing folder");
            }
            FileObject newFolder = null;
            newFolder = this.createFileObject(containingDir, newFolderString);
            int i = 1;
            while (newFolder.exists()) {
                newFolder = this.createFileObject(containingDir, MessageFormat.format(newFolderNextString, i));
                ++i;
            }
            if (newFolder.exists()) {
                throw new FileSystemException("Directory already exists:" + newFolder.getName().getURI());
            }
            newFolder.createFolder();
            return newFolder;
        }
    }
}

