/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.util.Selector;

public class X509CertStoreSelector
extends X509CertSelector
implements Selector {
    public boolean match(Object object) {
        if (!(object instanceof Certificate)) {
            return false;
        }
        return super.match((Certificate)object);
    }

    public X500Principal getSubject() {
        try {
            byte[] byArray = this.getSubjectAsBytes();
            if (byArray != null) {
                return new X500Principal(byArray);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("badly encoded subject");
        }
        return null;
    }

    public X500Principal getIssuer() {
        try {
            byte[] byArray = this.getIssuerAsBytes();
            if (byArray != null) {
                return new X500Principal(byArray);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("badly encoded issuer");
        }
        return null;
    }

    public static X509CertStoreSelector getInstance(X509CertSelector x509CertSelector) {
        if (x509CertSelector == null) {
            throw new IllegalArgumentException("cannot create from null selector");
        }
        X509CertStoreSelector x509CertStoreSelector = new X509CertStoreSelector();
        x509CertStoreSelector.setAuthorityKeyIdentifier(x509CertSelector.getAuthorityKeyIdentifier());
        x509CertStoreSelector.setBasicConstraints(x509CertSelector.getBasicConstraints());
        x509CertStoreSelector.setCertificate(x509CertSelector.getCertificate());
        x509CertStoreSelector.setCertificateValid(x509CertSelector.getCertificateValid());
        try {
            x509CertStoreSelector.setExtendedKeyUsage(x509CertSelector.getExtendedKeyUsage());
            x509CertStoreSelector.setNameConstraints(x509CertSelector.getNameConstraints());
            x509CertStoreSelector.setPathToNames(x509CertSelector.getPathToNames());
            x509CertStoreSelector.setPolicy(x509CertSelector.getPolicy());
            x509CertStoreSelector.setSubjectPublicKeyAlgID(x509CertSelector.getSubjectPublicKeyAlgID());
            x509CertStoreSelector.setIssuer(x509CertSelector.getIssuerAsBytes());
            x509CertStoreSelector.setSubject(x509CertSelector.getSubjectAsBytes());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
        x509CertStoreSelector.setKeyUsage(x509CertSelector.getKeyUsage());
        x509CertStoreSelector.setMatchAllSubjectAltNames(x509CertSelector.getMatchAllSubjectAltNames());
        x509CertStoreSelector.setPrivateKeyValid(x509CertSelector.getPrivateKeyValid());
        x509CertStoreSelector.setSerialNumber(x509CertSelector.getSerialNumber());
        x509CertStoreSelector.setSubjectKeyIdentifier(x509CertSelector.getSubjectKeyIdentifier());
        x509CertStoreSelector.setSubjectPublicKey(x509CertSelector.getSubjectPublicKey());
        return x509CertStoreSelector;
    }
}

