/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.spi.formatter.value;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;

public class Case
implements Formatter<ExpressionBuilder.Value> {
    private final Formatter<ExpressionBuilder.Value> formatter;

    public Case(Formatter<ExpressionBuilder.Value> formatter) {
        this.formatter = formatter;
    }

    @Override
    public boolean canApply(ExpressionBuilder.Value value) {
        return value instanceof ExpressionBuilder.Function && StringUtils.equalsIgnoreCase((CharSequence)"CASE", (CharSequence)((ExpressionBuilder.Function)value).name());
    }

    @Override
    public String format(ExpressionBuilder.Value function0) {
        int elseValue;
        int firstValue;
        int count;
        ExpressionBuilder.Function function = (ExpressionBuilder.Function)function0;
        List<ExpressionBuilder.Value> args = function.parameters();
        if (args.size() % 2 == 0) {
            firstValue = count = args.size() / 2;
            elseValue = -1;
        } else {
            firstValue = count = (args.size() - 1) / 2;
            elseValue = args.size() - 1;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("CASE ");
        for (int i = 0; i < count; ++i) {
            builder.append(MessageFormat.format("WHEN ({0}) THEN ({1}) ", args.get(i).toString(this.formatter), args.get(firstValue + i).toString(this.formatter)));
        }
        if (elseValue >= 0 && args.get(elseValue) != null) {
            builder.append(MessageFormat.format("ELSE ({0})", args.get(elseValue).toString()));
        }
        builder.append(" END");
        return builder.toString();
    }
}

