/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class SHAHashingUtils {
    public static String hash_sha256(String input) {
        return SHAHashingUtils.hexhash(input, "SHA-256");
    }

    public static String hash_sha512(String input) {
        return SHAHashingUtils.hexhash(input, "SHA-512");
    }

    public static byte[] hash(String input, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] bytes = md.digest(input.getBytes());
            return bytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String hexhash(String input, String algorithm) {
        try {
            byte[] bytes = SHAHashingUtils.hash(input, algorithm);
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String base64hash(String input, String algorithm) {
        try {
            byte[] bytes = SHAHashingUtils.hash(input, algorithm);
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        String input = "password";
        String hash = SHAHashingUtils.hash_sha256(input);
        System.out.println("SHA-256 Hash: " + hash + ", len: " + hash.length());
        hash = SHAHashingUtils.hash_sha512(input);
        System.out.println("SHA-512 Hash: " + hash + ", len: " + hash.length());
        hash = SHAHashingUtils.base64hash(input, "SHA-256");
        System.out.println("SHA-256 Hash: " + hash + ", len: " + hash.length());
        hash = SHAHashingUtils.base64hash(input, "SHA-512");
        System.out.println("SHA-512 Hash: " + hash + ", len: " + hash.length());
    }
}

