/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dataTypes.impl.coercion;

import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.commons.codec.binary.Hex;
import org.gvsig.tools.dataTypes.AbstractCoercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionException;

public class CoerceToBytearray
extends AbstractCoercion {
    public static final String PREFIX_HEX = "0x#";
    public static final String SUFFIX_HEX = "#";
    public static final int PREFIX_LEN = "0x#".length();
    public static final int SUFFIX_LEN = "#".length();

    @Override
    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        if (value == null || value instanceof Byte[] || value instanceof byte[]) {
            return value;
        }
        try {
            if (value instanceof CharSequence) {
                String s = value.toString();
                if (s.startsWith(PREFIX_HEX) && s.endsWith(SUFFIX_HEX)) {
                    s = s.substring(PREFIX_LEN, s.length() - SUFFIX_LEN);
                    return Hex.decodeHex((char[])s.toCharArray());
                }
                return s.getBytes();
            }
            if (value instanceof Number) {
                if (value instanceof Short) {
                    ByteBuffer buffer = ByteBuffer.allocate(2);
                    buffer.putShort((Short)value);
                    return buffer.array();
                }
                if (value instanceof Integer) {
                    ByteBuffer buffer = ByteBuffer.allocate(4);
                    buffer.putInt((Integer)value);
                    return buffer.array();
                }
                if (value instanceof Long) {
                    ByteBuffer buffer = ByteBuffer.allocate(8);
                    buffer.putLong((Long)value);
                    return buffer.array();
                }
                if (value instanceof Float) {
                    ByteBuffer buffer = ByteBuffer.allocate(4);
                    buffer.putFloat(((Float)value).floatValue());
                    return buffer.array();
                }
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.putDouble((Double)value);
                return buffer.array();
            }
            if (value instanceof Date) {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.putLong(((Date)value).getTime());
                return buffer.array();
            }
        }
        catch (Exception e) {
            throw new CoercionException(e);
        }
        throw new CoercionException("Can't coerce '" + value.getClass().getName() + "' to byte[].");
    }
}

