/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject.impl;

import org.gvsig.tools.dynobject.DynClassName;

public class DefaultDynClassName
implements DynClassName {
    private String name;
    private String namespace;

    public DefaultDynClassName(String namespace, String name) {
        this.setNamespace(namespace);
        this.setName(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefaultDynClassName(String fullname) {
        int x = fullname.indexOf(":");
        int y = fullname.lastIndexOf(":");
        if (x > -1) {
            if (x != y) throw new IllegalArgumentException("Fullname '" + fullname + "' not allowed. Only one '" + ":" + "' is possible.");
            this.setNamespace(fullname.substring(0, x));
            this.setName(fullname.substring(x + 1));
            return;
        } else {
            this.namespace = null;
            this.setName(fullname);
        }
    }

    public DefaultDynClassName(String[] name) {
        this.setNamespace(name[0]);
        this.setName(name[1]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getFullName() {
        if (this.namespace == null) {
            return this.name;
        }
        return this.namespace + ":" + this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNamespace(String namespace) {
        if (namespace != null) {
            if (namespace.indexOf(":") > -1) throw new IllegalArgumentException("Namespace '" + namespace + "' not allowed. Character " + ":" + " forbidden whithin a dynClass' namespace'");
            this.namespace = namespace;
            return;
        } else {
            this.namespace = null;
        }
    }

    public void setName(String name) {
        if (name != null) {
            if (name.indexOf(":") > -1) {
                throw new IllegalArgumentException("Name '" + name + "' not allowed. Character '" + ":" + "' is not valid within a dynClass' name.");
            }
        } else {
            throw new IllegalArgumentException("Null value unsupported for a dynClass' name.");
        }
        this.name = name;
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DynClassName) {
            DynClassName obj2 = (DynClassName)obj;
            return this.getFullName().equalsIgnoreCase(obj2.getFullName());
        }
        return false;
    }

    public String toString() {
        return this.getFullName();
    }
}

