/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.task.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTaskStatus
implements SimpleTaskStatus {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTaskStatus.class);
    protected long lastModification = 0L;
    protected SubtaskValues values;
    protected List subtaskStack = null;
    protected String title = null;
    protected String code = null;
    protected boolean isCancelled = false;
    protected boolean isAbortedByError = false;
    protected TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
    protected boolean isCancellable;
    protected boolean isCancellationRequested;
    protected ObservableHelper observers = null;
    protected boolean autoremove = true;
    private long startMillis;
    private long lastNotification = 0L;

    public BaseTaskStatus(String title) {
        this.title = title;
        this.values = new SubtaskValues();
        this.isCancelled = false;
        this.isAbortedByError = false;
        this.isCancellable = false;
        this.isCancellationRequested = false;
        this.code = this.manager.getNewCode();
        this.observers = new ObservableHelper();
        this.touch();
    }

    public BaseTaskStatus(String tittle, long minValue, long maxValue) {
        this(tittle);
        this.values.minValue = minValue;
        this.values.maxValue = maxValue;
    }

    @Override
    public void restart() {
        this.autoremove = true;
        this.values = new SubtaskValues();
        this.isCancelled = false;
        this.isAbortedByError = false;
        this.isCancellable = false;
        this.isCancellationRequested = false;
        this.touch();
    }

    @Override
    public void setRangeOfValues(long min, long max) {
        this.values.minValue = min;
        this.values.maxValue = max;
        this.values.curValue = min;
    }

    protected void touch() {
        this.touch(true);
    }

    protected void touch(boolean clearmsg) {
        long now = System.currentTimeMillis();
        if (clearmsg && this.lastModification != 0L && now - this.lastModification > 4000L) {
            this.values.message = null;
        }
        this.lastModification = now;
        this.notifyObservers();
    }

    protected void notifyObservers() {
        this.manager.update(this);
        this.observers.notifyObservers(this, null);
    }

    @Override
    public Date getLastModification() {
        return new Date(this.lastModification);
    }

    @Override
    public void message(String message) {
        this.values.message = message;
        this.touch(false);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public void setCurValue(long value) {
        this.values.curValue = value;
        this.touch(false);
    }

    @Override
    public long getCurValue() {
        return this.values.curValue;
    }

    @Override
    public void incrementCurrentValue() {
        ++this.values.curValue;
        long now = System.currentTimeMillis();
        if (this.values.curValue >= this.values.maxValue) {
            this.touch(false);
            this.lastNotification = now;
        } else if (now - this.lastNotification > 200L) {
            this.touch(false);
            this.lastNotification = now;
        } else {
            this.lastModification = now;
        }
    }

    @Override
    public int getCompleted() {
        if (!this.values.isRunning) {
            return 100;
        }
        if (this.values.maxValue == this.values.minValue) {
            return 100;
        }
        try {
            return (int)((this.values.curValue - this.values.minValue) * 100L / (this.values.maxValue - this.values.minValue));
        }
        catch (Exception e) {
            return 100;
        }
    }

    @Override
    public String getLabel() {
        if (this.values.message == null) {
            return this.getProgressLabel();
        }
        return this.values.message + this.getProgressLabel();
    }

    @Override
    public String getProgressLabel() {
        String progress = this.values.maxValue == this.values.minValue ? (this.values.curValue > 0L ? " (" + this.values.curValue + ")" : "") : " (" + (this.values.curValue - this.values.minValue) + " / " + (this.values.maxValue - this.values.minValue) + ")";
        return progress;
    }

    @Override
    public String getMessage() {
        return this.values.message;
    }

    @Override
    public void terminate() {
        if (!this.values.isRunning) {
            return;
        }
        this.values.isRunning = false;
        if (LOG.isDebugEnabled()) {
            long endMillis = System.currentTimeMillis();
            LOG.debug("Terminated status {} execution in {} ms", (Object)this.getTitle(), (Object)(endMillis - this.startMillis));
        }
        this.touch();
        if (this.autoremove && (this.subtaskStack == null || this.subtaskStack.isEmpty())) {
            this.remove();
        }
    }

    @Override
    public void cancel() {
        if (!this.values.isRunning) {
            return;
        }
        this.isCancelled = true;
        this.values.isRunning = false;
        this.touch();
        if (this.autoremove && (this.subtaskStack == null || this.subtaskStack.isEmpty())) {
            this.remove();
        }
    }

    @Override
    public void abort() {
        if (!this.values.isRunning) {
            return;
        }
        this.isAbortedByError = true;
        this.values.isRunning = false;
        this.touch(false);
        if (this.autoremove && (this.subtaskStack == null || this.subtaskStack.isEmpty())) {
            this.remove();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isAborted() {
        return this.isAbortedByError;
    }

    @Override
    public boolean isRunning() {
        return this.values.isRunning;
    }

    @Override
    public TaskStatusManager getManager() {
        return this.manager;
    }

    @Override
    public boolean isIndeterminate() {
        return this.values.maxValue <= this.values.minValue;
    }

    @Override
    public void add() {
        this.manager.add(this);
        if (LOG.isDebugEnabled()) {
            this.startMillis = System.currentTimeMillis();
        }
    }

    @Override
    public void remove() {
        if (!(this.isRunning() || this.isAborted() || this.isCancelled())) {
            this.values.message = "";
        }
        this.manager.remove(this);
    }

    @Override
    public boolean isCancellable() {
        return this.isCancellable;
    }

    @Override
    public void setCancellable(boolean cancellable) {
        this.isCancellable = cancellable;
    }

    @Override
    public synchronized boolean isCancellationRequested() {
        return this.isCancellationRequested;
    }

    @Override
    public synchronized void cancelRequest() {
        this.isCancellationRequested = true;
    }

    @Override
    public synchronized void addObserver(Observer o) {
        this.observers.addObserver(o);
    }

    @Override
    public synchronized void deleteObserver(Observer o) {
        this.observers.deleteObserver(o);
    }

    @Override
    public synchronized void deleteObservers() {
        this.observers.deleteObservers();
    }

    @Override
    public void setTittle(String tittle) {
        this.setTitle(tittle);
    }

    @Override
    public void setTitle(String title) {
        if (!StringUtils.equals((CharSequence)title, (CharSequence)this.title)) {
            this.title = title;
            this.touch(false);
        }
    }

    @Override
    public void setAutoremove(boolean autoremove) {
        this.autoremove = autoremove;
    }

    @Override
    public boolean getAutoRemove() {
        return this.autoremove;
    }

    @Override
    public void push() {
        if (this.subtaskStack == null) {
            this.subtaskStack = new ArrayList();
        }
        this.subtaskStack.add(0, this.values);
        try {
            this.values = (SubtaskValues)this.values.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    @Override
    public void pop() {
        if (this.subtaskStack == null || this.subtaskStack.isEmpty()) {
            if (!this.isAborted()) {
                this.values.message = "";
            }
            this.values.isRunning = false;
            this.values.maxValue = 0L;
            this.values.minValue = 0L;
            this.values.curValue = 0L;
            this.notifyObservers();
            return;
        }
        if (this.isAborted()) {
            String msg = this.values.message;
            this.values = (SubtaskValues)this.subtaskStack.get(0);
            this.subtaskStack.remove(0);
            this.values.message = msg;
            this.touch(false);
        } else {
            this.values = (SubtaskValues)this.subtaskStack.get(0);
            this.subtaskStack.remove(0);
            this.touch();
        }
    }

    @Override
    public void setIndeterminate() {
        this.values.maxValue = 0L;
        this.values.minValue = 0L;
        this.values.curValue = 0L;
        this.notifyObservers();
    }

    protected class SubtaskValues {
        long minValue = 0L;
        long maxValue = 0L;
        long curValue = 0L;
        String message = null;
        boolean isRunning = true;

        protected SubtaskValues() {
        }

        public Object clone() throws CloneNotSupportedException {
            SubtaskValues other = new SubtaskValues();
            other.curValue = this.curValue;
            other.maxValue = this.maxValue;
            other.minValue = this.minValue;
            other.message = this.message;
            other.isRunning = this.isRunning;
            return other;
        }
    }
}

