/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.io.Closeable;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedValue<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(CachedValue.class);
    private T value = null;
    private long lastAccess = 0L;
    private long expireTimeInMillis;
    private Callable<T> reload;

    public CachedValue() {
        this(3000L, null);
    }

    public CachedValue(long expireTimeInMillis) {
        this(expireTimeInMillis, null);
    }

    public CachedValue(Callable<T> reload) {
        this(3000L, reload);
    }

    public CachedValue(long expireTimeInMillis, Callable<T> reload) {
        this.expireTimeInMillis = expireTimeInMillis;
        this.reload = reload;
    }

    protected void reload() {
        if (this.reload != null) {
            try {
                this.value = this.reload.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final T getValue() {
        return this.value;
    }

    protected void setValue(T value) {
        this.cleanValue();
        this.value = value;
    }

    public final boolean isExpired() {
        long now = System.currentTimeMillis();
        return now - this.lastAccess > this.expireTimeInMillis;
    }

    public final void set(T value) {
        this.cleanValue();
        this.value = value;
        this.lastAccess = System.currentTimeMillis();
    }

    public final void setExpireTime(long expireTimeInMillis) {
        this.expireTimeInMillis = expireTimeInMillis;
    }

    public final long getExpireTime() {
        return this.expireTimeInMillis;
    }

    public final void resetAccess() {
        this.lastAccess = System.currentTimeMillis();
    }

    public final void expired() {
        this.lastAccess = 0L;
    }

    protected void cleanValue() {
        if (this.value instanceof Disposable) {
            DisposeUtils.disposeQuietly((Disposable)this.value);
        } else if (this.value instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)this.value));
        }
        this.value = null;
    }

    public final T get() {
        if (this.isExpired()) {
            this.reload();
        }
        this.resetAccess();
        return this.getValue();
    }
}

