/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.util.Iterator;
import java.util.function.Predicate;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.util.FilteredIterator;

public class FilteredIterable<T>
implements Iterable<T>,
DisposableIterable<T> {
    private final Iterable<T> it;
    private final Predicate<T> filter;
    private T next;

    public FilteredIterable(Iterable<T> it, Predicate<T> filter) {
        this.it = it;
        this.filter = filter;
    }

    @Override
    public Iterator<T> iterator() {
        return new FilteredIterator<T>(this.it.iterator(), this.filter);
    }

    @Override
    public void dispose() {
        if (this.it instanceof Disposable) {
            DisposeUtils.dispose(this.it);
        }
    }
}

