/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.util.Iterator;
import java.util.function.Predicate;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;

public class FilteredIterator<T>
implements Iterator<T>,
DisposableIterator<T> {
    private final Iterator<T> it;
    private final Predicate<T> filter;
    private T next;

    public FilteredIterator(Iterator<T> it, Predicate<T> filter) {
        this.it = it;
        this.filter = filter;
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        while (this.it.hasNext()) {
            this.next = this.it.next();
            if (!this.filter.test(this.next)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        return this.next;
    }

    @Override
    public void dispose() {
        if (this.it instanceof Disposable) {
            DisposeUtils.dispose(this.it);
        }
    }
}

