/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.api.documentfilters;

import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class DoubleDocumentFilter
extends DocumentFilter {
    private final JTextField text;
    private final Color backgroundOk;
    private final Color backgroundErr;

    public static void install(JTextField text) {
        Document doc = text.getDocument();
        if (doc instanceof PlainDocument) {
            ((PlainDocument)doc).setDocumentFilter(new DoubleDocumentFilter(text));
        }
    }

    public static void setValue(JTextField text, double value) {
        text.setText(String.valueOf(value));
    }

    public static double getValue(JTextField text) {
        String s = text.getText();
        if (StringUtils.isEmpty((CharSequence)s)) {
            return Double.NaN;
        }
        try {
            double n = Double.parseDouble(s);
            return n;
        }
        catch (Exception ex) {
            return Double.NaN;
        }
    }

    public static boolean isValid(JTextField text) {
        String s = text.getText();
        if (StringUtils.isEmpty((CharSequence)s)) {
            return true;
        }
        try {
            double n = Double.parseDouble(s);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isEmpty(JTextField text) {
        String s = text.getText();
        if (StringUtils.isEmpty((CharSequence)s)) {
            return true;
        }
        try {
            double n = Double.parseDouble(s);
            return false;
        }
        catch (Exception ex) {
            return true;
        }
    }

    public DoubleDocumentFilter(JTextField text) {
        this.text = text;
        this.backgroundOk = text.getBackground();
        this.backgroundErr = ToolsSwingLocator.getToolsSwingManager().getWarningBackgroundColor();
    }

    private boolean test(String text) {
        try {
            Double.parseDouble(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        super.insertString(fb, offset, string, attr);
        String s = this.text.getText();
        if (this.test(s)) {
            this.text.setBackground(this.backgroundOk);
        } else {
            this.text.setBackground(this.backgroundErr);
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        super.replace(fb, offset, length, text, attrs);
        String s = this.text.getText();
        if (this.test(s)) {
            this.text.setBackground(this.backgroundOk);
        } else {
            this.text.setBackground(this.backgroundErr);
        }
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        super.remove(fb, offset, length);
        String s = this.text.getText();
        if (this.test(s)) {
            this.text.setBackground(this.backgroundOk);
        } else {
            this.text.setBackground(this.backgroundErr);
        }
    }
}

