/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.datainput;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;

public class DataInputField
extends Container
implements PropertyChangeListener {
    private static final long serialVersionUID = 8633824284253287604L;
    private JFormattedTextField textField = null;
    private ArrayList actionChangedListeners = new ArrayList();
    private NumberFormat doubleDisplayFormat;
    private NumberFormat doubleEditFormat;
    private boolean eventsEnabled = true;
    private int maximumFractionDigits = 3;

    public DataInputField(int maximumFractionDigits) {
        this.maximumFractionDigits = maximumFractionDigits;
        this.setUpFormats();
        this.initialize();
    }

    public DataInputField() {
        this.setUpFormats();
        this.initialize();
    }

    private void setUpFormats() {
        this.doubleDisplayFormat = NumberFormat.getNumberInstance();
        this.doubleDisplayFormat.setMinimumFractionDigits(0);
        this.doubleDisplayFormat.setMaximumFractionDigits(this.maximumFractionDigits);
        this.doubleEditFormat = NumberFormat.getNumberInstance();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJFormattedTextField(), "Center");
    }

    private JFormattedTextField getJFormattedTextField() {
        if (this.textField == null) {
            this.textField = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(this.doubleDisplayFormat), new NumberFormatter(this.doubleDisplayFormat), new NumberFormatter(this.doubleEditFormat)));
            this.textField.setBackground(Color.white);
            this.textField.setValue(0.0);
            this.textField.setColumns(10);
            this.textField.addPropertyChangeListener("value", this);
        }
        return this.textField;
    }

    public String getValue() {
        double value = ((Number)this.getJFormattedTextField().getValue()).doubleValue();
        return Double.toString(value);
    }

    public void setControlEnabled(boolean en) {
        this.getJFormattedTextField().setEnabled(en);
        if (en) {
            this.getJFormattedTextField().setBackground(Color.white);
        } else {
            this.getJFormattedTextField().setBackground(this.getBackground());
        }
    }

    public void setValue(String value) {
        this.eventsEnabled = false;
        this.getJFormattedTextField().setValue(Double.valueOf(value));
        this.eventsEnabled = true;
    }

    public void addValueChangedListener(DataInputContainerListener listener) {
        if (!this.actionChangedListeners.contains(listener)) {
            this.actionChangedListeners.add(listener);
        }
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.textField.addKeyListener(listener);
    }

    public void removeValueChangedListener(DataInputContainerListener listener) {
        this.actionChangedListeners.remove(listener);
    }

    private void callValueChangedListeners() {
        if (!this.eventsEnabled) {
            return;
        }
        for (DataInputContainerListener listener : this.actionChangedListeners) {
            listener.actionValueChanged(new EventObject(this));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.callValueChangedListeners();
    }
}

