/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.filterPanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.controls.MultiLineToolTip;
import org.gvsig.gui.beans.editabletextcomponent.JEditableTextArea;
import org.gvsig.gui.beans.filterPanel.filterButtons.FilterButtonsJPanel;
import org.gvsig.gui.beans.panelGroup.panels.AbstractPanel;

public abstract class AbstractFilterQueryJPanel
extends AbstractPanel
implements Serializable {
    public static final int DefaultHeight = 280;
    public static final int DefaultWidth = 490;
    protected final int fieldsJPanelHeight = 145;
    protected final int fieldsJPanelWidth = 145;
    protected final int valuesJPanelHeight = 145;
    protected final int valuesJPanelWidth = 145;
    protected final int defaultBottomJPanelWidth = 480;
    protected final int defaultBottomJPanelHeight = 110;
    protected int filterJScrollPaneHeight;
    protected int filterJScrollPanelWidth;
    protected final int filterButtonsPanelHeight = 104;
    protected final int filterButtonsPanelWidth = 190;
    protected final int defaultTopJPanelWidth = 480;
    protected final int defaultTopJPanelHeight = 145;
    protected int fieldsAndValuesJScrollPaneHeight = 110;
    protected int fieldsAndValuesJScrollPaneWidth = 145;
    protected JLabelML fieldsJLabel = null;
    protected JLabelML valuesJLabel = null;
    protected JPanelML fieldsJPanel = null;
    protected JPanelML valuesJPanel = null;
    protected FilterButtonsJPanel filterButtonsJPanel = null;
    protected JScrollPaneML filterJScrollPane = null;
    protected JPanelML topJPanel = null;
    protected JPanelML bottomJPanel = null;
    protected JEditableTextAreaML txtExpression = null;
    protected JTreeML fieldsJTree = null;
    protected JListML valuesJList = null;
    protected JScrollPaneML fieldsJScrollPane = null;
    protected JScrollPaneML valuesJScrollPane = null;
    protected String title;
    protected DefaultTreeModel defaultTreeModel;
    protected DefaultListModel valuesListModel;
    private Set<String> operatorSymbols;

    public AbstractFilterQueryJPanel(String _title) {
        this.title = _title;
    }

    public AbstractFilterQueryJPanel() {
    }

    @Override
    protected void initialize() {
        this.operatorSymbols = new HashSet<String>();
        this.operatorSymbols.add("and");
        this.operatorSymbols.add("<>");
        this.operatorSymbols.add("!=");
        this.operatorSymbols.add("=");
        this.operatorSymbols.add(">=");
        this.operatorSymbols.add("<=");
        this.operatorSymbols.add(">");
        this.operatorSymbols.add("not");
        this.operatorSymbols.add("or");
        this.operatorSymbols.add("(");
        this.operatorSymbols.add(")");
        this.operatorSymbols.add("<");
        this.setPreferredSize(new Dimension(490, 280));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.getTopJPanel(), gridBagConstraints);
        gridBagConstraints.anchor = 15;
        this.add((Component)this.getBottomJPanel(), gridBagConstraints);
    }

    protected abstract JPanel getTopJPanel();

    protected abstract JPanel getBottomJPanel();

    protected JLabel getFieldsJLabel() {
        if (this.fieldsJLabel == null) {
            this.fieldsJLabel = new JLabelML();
            this.fieldsJLabel.setText(Messages.getText("fields_uppercase_first") + ":");
        }
        return this.fieldsJLabel;
    }

    protected abstract JList getValuesJList();

    protected abstract JPanel getFieldsJPanel();

    protected abstract JScrollPane getFieldsJScrollPane();

    protected JLabel getValuesJLabel() {
        if (this.valuesJLabel == null) {
            this.valuesJLabel = new JLabelML();
            this.valuesJLabel.setText(Messages.getText("known_values") + ":");
        }
        return this.valuesJLabel;
    }

    protected abstract JPanel getValuesJPanel();

    protected abstract JScrollPane getValuesJScrollPane();

    protected abstract JScrollPane getFilterJScrollPane();

    protected abstract JTextArea getTxtExpression();

    protected void putSymbol(String symbol) {
        int position = this.getTxtExpression().getCaretPosition();
        this.getTxtExpression().setText(AbstractFilterQueryJPanel.insert(this.getTxtExpression().getText(), position, symbol));
        position = symbol.equals(" () ") ? (position += 2) : (position += symbol.length());
        this.getTxtExpression().setCaretPosition(position);
    }

    protected JTree getFieldsJTree() {
        if (this.fieldsJTree == null) {
            this.fieldsJTree = new JTreeML(new Vector(0, 1));
            DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
            defaultTreeCellRenderer.setOpenIcon(null);
            defaultTreeCellRenderer.setClosedIcon(null);
            defaultTreeCellRenderer.setLeafIcon(null);
            this.fieldsJTree.setRootVisible(false);
            this.fieldsJTree.setCellRenderer(defaultTreeCellRenderer);
        }
        return this.fieldsJTree;
    }

    protected static String insert(String base, int position, String graft) {
        return base.substring(0, position) + graft + base.substring(position);
    }

    protected JPanel getFilterButtonsJPanel() {
        if (this.filterButtonsJPanel == null) {
            this.filterButtonsJPanel = new FilterButtonsJPanel();
            this.filterButtonsJPanel.setPreferredSize(new Dimension(190, 104));
            this.filterButtonsJPanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (arg0.getPropertyName().equals("Button Clicked")) {
                        switch (Integer.parseInt(arg0.getNewValue().toString())) {
                            case 7: {
                                AbstractFilterQueryJPanel.this.putSymbol(" and ");
                                break;
                            }
                            case 10: {
                                AbstractFilterQueryJPanel.this.putSymbol(((FilterButtonsJPanel)arg0.getSource()).getLastSelectedDate());
                                break;
                            }
                            case 2: {
                                AbstractFilterQueryJPanel.this.putSymbol(" != ");
                                break;
                            }
                            case 1: {
                                AbstractFilterQueryJPanel.this.putSymbol(" = ");
                                break;
                            }
                            case 5: {
                                AbstractFilterQueryJPanel.this.putSymbol(" >= ");
                                break;
                            }
                            case 6: {
                                AbstractFilterQueryJPanel.this.putSymbol(" <= ");
                                break;
                            }
                            case 3: {
                                AbstractFilterQueryJPanel.this.putSymbol(" > ");
                                break;
                            }
                            case 9: {
                                AbstractFilterQueryJPanel.this.putSymbol(" not ");
                                break;
                            }
                            case 8: {
                                AbstractFilterQueryJPanel.this.putSymbol(" or ");
                                break;
                            }
                            case 11: {
                                AbstractFilterQueryJPanel.this.putSymbol(" () ");
                                break;
                            }
                            case 4: {
                                AbstractFilterQueryJPanel.this.putSymbol(" < ");
                                break;
                            }
                            case 12: {
                                AbstractFilterQueryJPanel.this.txtExpression.setText("");
                                break;
                            }
                        }
                    }
                }
            });
        }
        return this.filterButtonsJPanel;
    }

    protected Set<String> getAllOperatorSymbols() {
        return this.operatorSymbols;
    }

    public void resizeHeight(int new_Height) {
        int difference = new_Height - 280;
        if (difference > 0) {
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getPreferredSize().height + difference));
            this.getTopJPanel().setPreferredSize(new Dimension(this.getTopJPanel().getPreferredSize().width, this.getTopJPanel().getPreferredSize().height + difference));
            this.getFieldsJPanel().setPreferredSize(new Dimension(this.getFieldsJPanel().getPreferredSize().width, this.getFieldsJPanel().getPreferredSize().height + difference));
            this.getFieldsJScrollPane().setPreferredSize(new Dimension(this.getFieldsJScrollPane().getPreferredSize().width, this.getFieldsJScrollPane().getPreferredSize().height + difference));
            this.getValuesJPanel().setPreferredSize(new Dimension(this.getValuesJPanel().getPreferredSize().width, this.getValuesJPanel().getPreferredSize().height + difference));
            this.getValuesJScrollPane().setPreferredSize(new Dimension(this.getValuesJScrollPane().getPreferredSize().width, this.getValuesJScrollPane().getPreferredSize().height + difference));
        }
    }

    public abstract void resizeWidth(int var1);

    @Override
    public void resize(int width, int height) {
        int difference = height - 280;
        if (difference != 0) {
            this.resizeHeight(height);
        }
        this.resizeWidth(width);
    }

    @Override
    public void resize(Dimension d) {
        int difference = d.height - 280;
        if (difference != 0) {
            this.resizeHeight(d.height);
        }
        this.resizeWidth(d.width);
    }

    @Override
    public void accept() {
    }

    @Override
    public void apply() {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void selected() {
    }

    protected class JButtonML
    extends JButton {
        private static final long serialVersionUID = -6052122756677251026L;

        public JButtonML() {
        }

        public JButtonML(Action a) {
            super(a);
        }

        public JButtonML(Icon icon) {
            super(icon);
        }

        public JButtonML(String text, Icon icon) {
            super(text, icon);
        }

        public JButtonML(String text) {
            super(text);
        }

        @Override
        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent(this);
            return tip;
        }
    }

    protected class JCheckBoxML
    extends JCheckBox {
        private static final long serialVersionUID = 2610142188236840664L;

        public JCheckBoxML() {
        }

        public JCheckBoxML(Action a) {
            super(a);
        }

        public JCheckBoxML(Icon icon, boolean selected) {
            super(icon, selected);
        }

        public JCheckBoxML(Icon icon) {
            super(icon);
        }

        public JCheckBoxML(String text, boolean selected) {
            super(text, selected);
        }

        public JCheckBoxML(String text, Icon icon, boolean selected) {
            super(text, icon, selected);
        }

        public JCheckBoxML(String text, Icon icon) {
            super(text, icon);
        }

        public JCheckBoxML(String text) {
            super(text);
        }

        @Override
        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent(this);
            return tip;
        }
    }

    protected class JListML
    extends JList {
        private static final long serialVersionUID = 5316332987144988365L;

        public JListML() {
        }

        public JListML(ListModel dataModel) {
            super(dataModel);
        }

        public JListML(Object[] listData) {
            super(listData);
        }

        public JListML(Vector<?> listData) {
            super(listData);
        }

        @Override
        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent(this);
            return tip;
        }
    }

    protected class JTreeML
    extends JTree {
        private static final long serialVersionUID = -8619256256346496435L;

        public JTreeML() {
        }

        public JTreeML(Hashtable<?, ?> value) {
            super(value);
        }

        public JTreeML(Object[] value) {
            super(value);
        }

        public JTreeML(TreeModel newModel) {
            super(newModel);
        }

        public JTreeML(TreeNode root, boolean asksAllowsChildren) {
            super(root, asksAllowsChildren);
        }

        public JTreeML(TreeNode root) {
            super(root);
        }

        public JTreeML(Vector<?> value) {
            super(value);
        }

        @Override
        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent(this);
            return tip;
        }
    }

    protected class JEditableTextAreaML
    extends JEditableTextArea {
        private static final long serialVersionUID = -6963953475368014077L;

        public JEditableTextAreaML() {
        }

        public JEditableTextAreaML(Document doc, String text, int rows, int columns) {
            super(doc, text, rows, columns);
        }

        public JEditableTextAreaML(Document doc) {
            super(doc);
        }

        public JEditableTextAreaML(int rows, int columns) {
            super(rows, columns);
        }

        public JEditableTextAreaML(String text, int rows, int columns) {
            super(text, rows, columns);
        }

        public JEditableTextAreaML(String text) {
            super(text);
        }

        @Override
        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent(this);
            return tip;
        }
    }

    protected class JPanelML
    extends JPanel {
        private static final long serialVersionUID = 5951860640473906815L;

        public JPanelML() {
        }

        public JPanelML(boolean isDoubleBuffered) {
            super(isDoubleBuffered);
        }

        public JPanelML(LayoutManager layout, boolean isDoubleBuffered) {
            super(layout, isDoubleBuffered);
        }

        public JPanelML(LayoutManager layout) {
            super(layout);
        }

        @Override
        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent(this);
            return tip;
        }
    }

    protected class JLabelML
    extends JLabel {
        private static final long serialVersionUID = 525349503578470487L;

        public JLabelML() {
        }

        public JLabelML(Icon image, int horizontalAlignment) {
            super(image, horizontalAlignment);
        }

        public JLabelML(Icon image) {
            super(image);
        }

        public JLabelML(String text, Icon icon, int horizontalAlignment) {
            super(text, icon, horizontalAlignment);
        }

        public JLabelML(String text, int horizontalAlignment) {
            super(text, horizontalAlignment);
        }

        public JLabelML(String text) {
            super(text);
        }

        @Override
        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent(this);
            return tip;
        }
    }

    protected class JScrollPaneML
    extends JScrollPane {
        private static final long serialVersionUID = 5222187234181725243L;

        public JScrollPaneML() {
        }

        public JScrollPaneML(Component view, int vsbPolicy, int hsbPolicy) {
            super(view, vsbPolicy, hsbPolicy);
        }

        public JScrollPaneML(Component view) {
            super(view);
        }

        public JScrollPaneML(int vsbPolicy, int hsbPolicy) {
            super(vsbPolicy, hsbPolicy);
        }

        @Override
        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent(this);
            return tip;
        }
    }
}

