/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.progresspanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanel;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.gui.beans.defaultbuttonspanel.DefaultButtonsPanel;
import org.gvsig.gui.beans.progresspanel.LogControl;

public class ProgressPanel
extends JDialog {
    private static final long serialVersionUID = 4321011219898234352L;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JPanel jPanel1 = null;
    private JPanel njp = null;
    private DefaultButtonsPanel defaultButtonsPanel = null;
    private JProgressBar jProgressBar = null;
    private JScrollPane jScrollPane = null;
    private JTextPane jTextPane = null;
    private LogControl text = new LogControl();
    private long startTime = System.currentTimeMillis();
    private boolean showPause = true;

    public ProgressPanel() {
        this.initialize();
    }

    public ProgressPanel(boolean showPause) {
        this.showPause = showPause;
        this.initialize();
    }

    public ProgressPanel(Dialog owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.initialize();
    }

    public ProgressPanel(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) throws HeadlessException {
        super(owner, title, modal, gc);
        this.initialize();
    }

    public ProgressPanel(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.initialize();
    }

    public ProgressPanel(Dialog owner, String title) throws HeadlessException {
        super(owner, title);
        this.initialize();
    }

    public ProgressPanel(Dialog owner) throws HeadlessException {
        super(owner);
        this.initialize();
    }

    public ProgressPanel(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.initialize();
    }

    public ProgressPanel(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.initialize();
    }

    public ProgressPanel(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.initialize();
    }

    public ProgressPanel(Frame owner, String title) throws HeadlessException {
        super(owner, title);
        this.initialize();
    }

    public ProgressPanel(Frame owner) throws HeadlessException {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.njp = new JPanel();
        this.njp.setLayout(new BorderLayout(5, 5));
        this.njp.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        this.setContentPane(this.njp);
        this.setResizable(false);
        this.njp.add((Component)this.getJPanel(), "North");
        this.njp.add((Component)this.getJPanel1(), "Center");
        this.njp.add((Component)this.getButtonsPanel(), "South");
        this.showLog(false);
        this.setPercent(0);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(d.getWidth() - (double)this.getWidth()) >> 1, (int)(d.getHeight() - (double)this.getHeight()) >> 1);
        this.setVisible(true);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabel1 = new JLabel();
            this.jLabel = new JLabel();
            this.jLabel.setText(Messages.getText("espere") + "...");
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout(5, 5));
            this.jPanel.add((Component)this.jLabel, "West");
            this.jPanel.add((Component)this.jLabel1, "East");
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new BorderLayout(5, 5));
            this.jPanel1.add((Component)this.getJProgressBar(), "North");
            this.jPanel1.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanel1;
    }

    public void addButtonPressedListener(ButtonsPanelListener listener) {
        this.getDefaultButtonsPanel().addButtonPressedListener(listener);
    }

    public void removeButtonPressedListener(ButtonsPanelListener listener) {
        this.getDefaultButtonsPanel().removeButtonPressedListener(listener);
    }

    public void showLog(boolean visible) {
        this.getButtonsPanel().getButton(8).setVisible(!visible);
        this.getButtonsPanel().getButton(9).setVisible(visible);
        this.jScrollPane.setVisible(visible);
        this.setIgnoreRepaint(true);
        if (visible) {
            this.setSize(this.getWidth(), 300);
        } else {
            this.pack();
        }
        this.setIgnoreRepaint(false);
        if (this.isVisible()) {
            this.setVisible(true);
        }
    }

    public void showPause(boolean visible) {
        if (this.showPause) {
            this.getButtonsPanel().getButton(11).setVisible(!visible);
            this.getButtonsPanel().getButton(10).setVisible(visible);
        } else {
            this.getButtonsPanel().getButton(11).setVisible(false);
            this.getButtonsPanel().getButton(10).setVisible(false);
        }
    }

    public ButtonsPanel getButtonsPanel() {
        return this.getDefaultButtonsPanel().getButtonsPanel();
    }

    public DefaultButtonsPanel getDefaultButtonsPanel() {
        if (this.defaultButtonsPanel == null) {
            this.defaultButtonsPanel = new DefaultButtonsPanel(8);
            this.getButtonsPanel().addSeeDetails();
            this.getButtonsPanel().addHideDetails();
            this.getButtonsPanel().addPause();
            this.getButtonsPanel().addRestart();
            this.showPause(true);
            this.getButtonsPanel().addCancel();
            this.getButtonsPanel().setLayout(new FlowLayout(1));
            this.getButtonsPanel().addButtonPressedListener(new ButtonsPanelListener(){

                @Override
                public void actionButtonPressed(ButtonsPanelEvent e) {
                    switch (e.getButton()) {
                        case 8: {
                            ProgressPanel.this.showLog(true);
                            break;
                        }
                        case 9: {
                            ProgressPanel.this.showLog(false);
                            break;
                        }
                        case 10: {
                            ProgressPanel.this.showPause(false);
                            break;
                        }
                        case 11: {
                            ProgressPanel.this.showPause(true);
                        }
                    }
                }
            });
        }
        return this.defaultButtonsPanel;
    }

    private JProgressBar getJProgressBar() {
        if (this.jProgressBar == null) {
            this.jProgressBar = new JProgressBar();
            this.jProgressBar.setValue(50);
            this.jProgressBar.setPreferredSize(new Dimension(450, 18));
        }
        return this.jProgressBar;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextPane());
            this.jScrollPane.setVisible(false);
        }
        return this.jScrollPane;
    }

    private JTextPane getJTextPane() {
        if (this.jTextPane == null) {
            this.jTextPane = new JTextPane();
            this.jTextPane.setEditable(false);
        }
        return this.jTextPane;
    }

    private void updateLog() {
        this.jTextPane.setText(this.text.getText());
        this.jTextPane.setCaretPosition(this.jTextPane.getText().length());
    }

    public void addLineLog(String line) {
        this.text.addLine(line);
        this.updateLog();
    }

    public void replaceLastLineLog(String line) {
        this.text.replaceLastLine(line);
        this.updateLog();
    }

    public void setLog(String value) {
        long time = (System.currentTimeMillis() - this.startTime) / 1000L;
        this.text.setText(value + "\n" + Messages.getText("tiempo_transcurrido") + ": " + time + "s");
        this.updateLog();
    }

    public int getPercent() {
        return this.jProgressBar.getValue();
    }

    public void setPercent(int value) {
        if (value == 0 && !this.jProgressBar.isIndeterminate()) {
            this.jProgressBar.setIndeterminate(true);
            this.jLabel1.setVisible(false);
        }
        if (value != 0 && this.jProgressBar.isIndeterminate()) {
            this.jProgressBar.setIndeterminate(false);
            this.jLabel1.setVisible(true);
        }
        this.jProgressBar.setValue(value);
        this.jLabel1.setText(value + "%");
    }

    public void setLabel(String value) {
        this.jLabel.setText(value);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.getJProgressBar().setIndeterminate(indeterminate);
    }

    public boolean getIndeterminate() {
        return this.getJProgressBar().isIndeterminate();
    }
}

