/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.swing.celleditors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.gvsig.gui.beans.swing.cellrenderers.StringTableCellRenderer;

public class StringTableCellEditor
implements TableCellEditor {
    private StringTableCellRenderer renderer;
    private ArrayList listeners = new ArrayList();

    public StringTableCellEditor(JTable ownerTable) {
        this.renderer = new StringTableCellRenderer();
    }

    @Override
    public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, int row, int column) {
        if (value == null) {
            return null;
        }
        JComponent aux = (JComponent)this.renderer.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        ((JTextField)aux).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.editingStopped(new ChangeEvent(table));
            }
        });
        return aux;
    }

    @Override
    public void cancelCellEditing() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener l = (CellEditorListener)this.listeners.get(i);
            ChangeEvent evt = new ChangeEvent(this);
            l.editingCanceled(evt);
        }
    }

    @Override
    public boolean stopCellEditing() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener l = (CellEditorListener)this.listeners.get(i);
            ChangeEvent evt = new ChangeEvent(this);
            l.editingStopped(evt);
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.renderer != null && this.renderer.getText() != null) {
            return Boolean.valueOf(this.renderer.getText());
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }
}

